/*
 * Decompiled with CFR 0.152.
 */
package espacedev.gaml.extensions.genstar.utils;

import java.util.Arrays;
import java.util.List;

public class GenStarConstant {
    public static final String GSGENERATOR = "generator";
    public static final String GSATTRIBUTES = "attributes";
    public static final String GSLOCALISE = "localize";
    public static final String GSLINK = "link";
    public static final String GSFEATURE = "feature";
    public static final String NESTATTRIBUTES = "nest_attribute";
    public static final String DISTRIBUTION = "distribution";
    public static final String CONSTRAINTS = "constraints";
    public static final Double EPSILON = Math.pow(10.0, -6.0);
    public static final String ENTITIES = "entities";
    public static final String NESTS = "nests";
    public static final String MATCHER = "matcher";
    public static final String MAPPER = "mapper";
    public static final String MAXDIST = "max_dist";
    public static final String MINDIST = "min_dist";
    public static final String MAXDISTLOCALIZATIONCST = "max_dist_loc";
    public static final String STEPISTLOCALIZATIONCST = "step_dist_loc";
    public static final String PARAMETERS = "parameters";

    public static enum GenerationAlgorithm implements IGSAlias
    {
        DIRECTSAMPLING(Arrays.asList("Direct Sampling", "DS", "IS")),
        HIERARCHICALSAMPLING(Arrays.asList("Hierarchical Sampling", "HS")),
        UNIFORMSAMPLING(Arrays.asList("Uniform Sampling", "US", "simple_draw")),
        MULTILAYER(Arrays.asList("Multi Type", "Multi Layer", "Household", "ML"));

        List<String> alias;

        private GenerationAlgorithm(List<String> list) {
            this.alias = list;
        }

        @Override
        public List<String> getAlias() {
            return this.alias;
        }

        public static GenerationAlgorithm getAlgorithm(String string) {
            if (DIRECTSAMPLING.getMatch(string)) {
                return DIRECTSAMPLING;
            }
            if (HIERARCHICALSAMPLING.getMatch(string)) {
                return HIERARCHICALSAMPLING;
            }
            if (UNIFORMSAMPLING.getMatch(string)) {
                return UNIFORMSAMPLING;
            }
            if (MULTILAYER.getMatch(string)) {
                return MULTILAYER;
            }
            throw new IllegalArgumentException(string + ": No such generation algorithm supported");
        }
    }

    public static interface IGSAlias {
        public List<String> getAlias();

        default public boolean getMatch(String string) {
            return this.getAlias().stream().anyMatch(string2 -> string2.equalsIgnoreCase(string));
        }

        default public String getDefault() {
            return this.getAlias().get(0);
        }
    }

    public static enum InputDataType implements IGSAlias
    {
        CONTINGENCY(Arrays.asList("Contingency", "Contingency table", "ContingencyTable")),
        FREQUENCY(Arrays.asList("Frequency", "Frequency table", "FrequencyTable", "Global Frequency", "Global Frequency Table", "GlobalFrequencyTable")),
        LOCAL(Arrays.asList("Local", "Local Frequency Table", "LocalFrequency", "Local Frequency", "LocalFrequencyTable")),
        SAMPLE(Arrays.asList("Sample", "Micro Sample", "MicroSample", "Micro Data", "MicroData"));

        List<String> alias;

        private InputDataType(List<String> list) {
            this.alias = list;
        }

        @Override
        public List<String> getAlias() {
            return this.alias;
        }
    }

    public static enum NetworkEngine implements IGSAlias
    {
        COMPLETE(Arrays.asList("Complete", "Complet")),
        RANDOM(Arrays.asList("Random", "Uniform", "Al\u00e9atoire")),
        REGULAR(Arrays.asList("Regular", "Latice", "Regulier")),
        SPATIAL(Arrays.asList("Spatial", "Spatiale")),
        SCALE_FREE(Arrays.asList("Scale free", "SF", "Barab\u00e1si\u2013Albert", "Power low")),
        SMALL_WORLD(Arrays.asList("Small world", "SW", "Watts-Strogatz"));

        List<String> alias;

        private NetworkEngine(List<String> list) {
            this.alias = list;
        }

        @Override
        public List<String> getAlias() {
            return this.alias;
        }
    }

    public static enum SpatialConstraint implements IGSAlias
    {
        CAPACITY(Arrays.asList("capacity", "number", "threshold")),
        DENSITY(Arrays.asList("density")),
        DISTANCE(Arrays.asList("distance", "proximity"));

        private final List<String> alias;

        private SpatialConstraint(List<String> list) {
            this.alias = list;
        }

        @Override
        public List<String> getAlias() {
            return this.alias;
        }
    }

    public static enum SpatialDistribution implements IGSAlias
    {
        DEFAULT(Arrays.asList("uniform", ""), SpatialDistributionConcept.SIMPLE),
        AREA(Arrays.asList("area", "areal"), SpatialDistributionConcept.SIMPLE),
        CAPACITY(Arrays.asList("capacity", "number"), SpatialDistributionConcept.NUMBER),
        DENSITY(Arrays.asList("density"), SpatialDistributionConcept.NUMBER);

        List<String> alias;
        SpatialDistributionConcept concept;

        private SpatialDistribution(List<String> list, SpatialDistributionConcept spatialDistributionConcept) {
            this.alias = list;
            this.concept = spatialDistributionConcept;
        }

        @Override
        public List<String> getAlias() {
            return this.alias;
        }

        public SpatialDistributionConcept getConcept() {
            return this.concept;
        }

        public static enum SpatialDistributionConcept {
            SIMPLE,
            NUMBER,
            COMPLEX;

        }
    }
}

