/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.co.metamodel.neighbor;

import core.metamodel.IPopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.entity.comparator.HammingEntityComparator;
import core.metamodel.value.IValue;
import core.util.random.GenstarRandomUtils;
import gospl.GosplPopulation;
import gospl.algo.co.metamodel.neighbor.IPopulationNeighborSearch;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PopulationEntityNeighborSearch
implements IPopulationNeighborSearch<GosplPopulation, ADemoEntity> {
    private IPopulation<ADemoEntity, Attribute<? extends IValue>> sample;
    private Collection<ADemoEntity> predicates = new HashSet<ADemoEntity>();

    @Override
    public Map<ADemoEntity, ADemoEntity> getPairwisedEntities(GosplPopulation gosplPopulation, ADemoEntity aDemoEntity, int n) {
        return this.getPairwisedEntities(gosplPopulation, aDemoEntity, n, false);
    }

    @Override
    public Map<ADemoEntity, ADemoEntity> getPairwisedEntities(GosplPopulation gosplPopulation, int n, boolean bl) {
        return this.getPairwisedEntities(gosplPopulation, GenstarRandomUtils.oneOf(this.getPredicates()), n, false);
    }

    @Override
    public Map<ADemoEntity, ADemoEntity> getPairwisedEntities(GosplPopulation gosplPopulation, ADemoEntity aDemoEntity2, int n, boolean bl) {
        HashMap<ADemoEntity, ADemoEntity> hashMap = new HashMap<ADemoEntity, ADemoEntity>();
        Set<ADemoEntity> set = new HashSet<ADemoEntity>(Arrays.asList(aDemoEntity2));
        if (n > 1) {
            set = gosplPopulation.stream().sorted(new HammingEntityComparator(aDemoEntity2)).limit(n).collect(Collectors.toSet());
        }
        if (bl && aDemoEntity2.hasChildren()) {
            int n2 = aDemoEntity2.getChildren().size();
            set = set.stream().filter(aDemoEntity -> aDemoEntity.hasChildren() && aDemoEntity.getChildren().size() == n2).collect(Collectors.toSet());
        }
        for (ADemoEntity aDemoEntity3 : set) {
            ADemoEntity aDemoEntity4 = (ADemoEntity)GenstarRandomUtils.oneOf(this.sample);
            while (aDemoEntity4.equals(aDemoEntity3)) {
                aDemoEntity4 = (ADemoEntity)GenstarRandomUtils.oneOf(this.sample);
            }
            hashMap.put(aDemoEntity3, aDemoEntity4);
        }
        return hashMap;
    }

    @Override
    public Collection<ADemoEntity> getPredicates() {
        return Collections.unmodifiableCollection(this.predicates);
    }

    @Override
    public void setPredicates(Collection<ADemoEntity> collection) {
        this.predicates = collection;
    }

    @Override
    public void updatePredicates(GosplPopulation gosplPopulation) {
        this.setPredicates(gosplPopulation);
    }

    @Override
    public void setSample(GosplPopulation gosplPopulation) {
        this.sample = gosplPopulation;
    }
}

