/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.co.metamodel.solution;

import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import core.util.random.GenstarRandomUtils;
import gospl.GosplPopulation;
import gospl.algo.co.metamodel.neighbor.IPopulationNeighborSearch;
import gospl.algo.co.metamodel.solution.ISyntheticPopulationSolution;
import gospl.distribution.GosplNDimensionalMatrixFactory;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.validation.GosplIndicatorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class SyntheticPopulationSolution
implements ISyntheticPopulationSolution<GosplPopulation> {
    protected GosplPopulation population;
    private double fitness = -1.0;

    public SyntheticPopulationSolution(GosplPopulation gosplPopulation) {
        this.population = gosplPopulation;
    }

    public SyntheticPopulationSolution(Collection<ADemoEntity> collection) {
        this(new GosplPopulation(collection));
    }

    @Override
    public <U> Collection<ISyntheticPopulationSolution<GosplPopulation>> getNeighbors(IPopulationNeighborSearch<GosplPopulation, U> iPopulationNeighborSearch) {
        return this.getNeighbors(iPopulationNeighborSearch, 1);
    }

    @Override
    public <U> Collection<ISyntheticPopulationSolution<GosplPopulation>> getNeighbors(IPopulationNeighborSearch<GosplPopulation, U> iPopulationNeighborSearch, int n) {
        return iPopulationNeighborSearch.getPredicates().stream().map(object -> new SyntheticPopulationSolution(iPopulationNeighborSearch.getNeighbor(this.population, object, n, false))).collect(Collectors.toCollection(ArrayList::new));
    }

    public <U> SyntheticPopulationSolution getRandomNeighbor(IPopulationNeighborSearch<GosplPopulation, U> iPopulationNeighborSearch) {
        return this.getRandomNeighbor((IPopulationNeighborSearch)iPopulationNeighborSearch, 1);
    }

    public <U> SyntheticPopulationSolution getRandomNeighbor(IPopulationNeighborSearch<GosplPopulation, U> iPopulationNeighborSearch, int n) {
        return new SyntheticPopulationSolution(iPopulationNeighborSearch.getNeighbor(this.population, GenstarRandomUtils.oneOf(iPopulationNeighborSearch.getPredicates()), n, false));
    }

    @Override
    public Double getFitness(Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> set) {
        if (this.fitness == -1.0) {
            AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix = GosplNDimensionalMatrixFactory.getFactory().createContingency(this.population);
            this.fitness = set.stream().mapToDouble(iNDimensionalMatrix -> GosplIndicatorFactory.getFactory().getIntegerTAE((INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number>)iNDimensionalMatrix, aFullNDimensionalMatrix)).sum();
        }
        return this.fitness;
    }

    @Override
    public INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> getAbsoluteErrors(INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix, Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> set) {
        throw new UnsupportedOperationException("Ask dev to code it ;)");
    }

    @Override
    public GosplPopulation getSolution() {
        return this.population;
    }

    public int hashCode() {
        return Objects.hash(this.population);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SyntheticPopulationSolution syntheticPopulationSolution = (SyntheticPopulationSolution)object;
        return Objects.equals(this.population, syntheticPopulationSolution.population);
    }
}

