/*
 * Decompiled with CFR 0.152.
 */
package gospl.algo.co.tabusearch;

import core.util.GSPerformanceUtil;
import core.util.random.GenstarRandom;
import gospl.GosplPopulation;
import gospl.algo.co.metamodel.AOptimizationAlgorithm;
import gospl.algo.co.metamodel.neighbor.IPopulationNeighborSearch;
import gospl.algo.co.metamodel.neighbor.PopulationAttributeNeighborSearch;
import gospl.algo.co.metamodel.solution.ISyntheticPopulationSolution;
import gospl.algo.co.tabusearch.ITabuList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TabuSearch
extends AOptimizationAlgorithm<GosplPopulation> {
    private final ITabuList tabuList;
    private final int maxIterations;

    public TabuSearch(ITabuList iTabuList, double d, int n) {
        this(new PopulationAttributeNeighborSearch(), iTabuList, d, n);
    }

    public TabuSearch(IPopulationNeighborSearch<GosplPopulation, ?> iPopulationNeighborSearch, ITabuList iTabuList, double d, int n) {
        super(iPopulationNeighborSearch, d);
        this.tabuList = iTabuList;
        this.maxIterations = n;
    }

    @Override
    public ISyntheticPopulationSolution<GosplPopulation> run(ISyntheticPopulationSolution<GosplPopulation> iSyntheticPopulationSolution2) {
        double d;
        ISyntheticPopulationSolution iSyntheticPopulationSolution3 = iSyntheticPopulationSolution2;
        ISyntheticPopulationSolution iSyntheticPopulationSolution4 = iSyntheticPopulationSolution2;
        this.getNeighborSearchAlgorithm().updatePredicates(iSyntheticPopulationSolution2.getSolution());
        double d2 = d = iSyntheticPopulationSolution2.getFitness(this.getObjectives()).doubleValue();
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Start Tabu Search algorithm\nPopulation size = " + iSyntheticPopulationSolution2.getSolution().size() + "\nSample size = " + super.getSample().size() + "\nMax iteration = " + this.maxIterations + "\nNeighbor search = " + super.getNeighborSearchAlgorithm().getClass().getSimpleName() + "\nSolution = " + iSyntheticPopulationSolution2.getClass().getSimpleName());
        gSPerformanceUtil.setObjectif(this.maxIterations);
        gSPerformanceUtil.sysoStempPerformance(0.0, (Object)this);
        gSPerformanceUtil.sysoStempMessage("Random start solution fitness is " + d);
        int n = 0;
        int n2 = 0;
        while (n++ < this.maxIterations && d > this.getFitnessThreshold()) {
            Collection<ISyntheticPopulationSolution<GosplPopulation>> collection;
            Map map;
            double d3;
            if ((double)n % ((double)this.maxIterations / 10.0) == 0.0 || d2 - d > d2 / 10.0) {
                gSPerformanceUtil.sysoStempPerformance((double)n / gSPerformanceUtil.getObjectif(), (Object)this);
                gSPerformanceUtil.sysoStempMessage("Current fitness is " + d);
                gSPerformanceUtil.sysoStempMessage("Tabu size " + this.tabuList.getSize() + " | number of stucked iteration " + n2 + " | Current buffer " + super.computeBuffer(d * (double)n2, iSyntheticPopulationSolution4));
                d2 = d;
            }
            if ((d3 = Collections.min((map = (collection = iSyntheticPopulationSolution4.getNeighbors(super.getNeighborSearchAlgorithm())).stream().filter(iSyntheticPopulationSolution -> !this.tabuList.contains((ISyntheticPopulationSolution<GosplPopulation>)iSyntheticPopulationSolution)).collect(Collectors.toMap(Function.identity(), iSyntheticPopulationSolution -> iSyntheticPopulationSolution.getFitness(this.getObjectives())))).values()).doubleValue()) < d) {
                iSyntheticPopulationSolution3 = map.entrySet().stream().filter(entry -> (Double)entry.getValue() == d3).map(Map.Entry::getKey).findFirst().orElse(null);
                d = d3;
                n2 = 0;
            }
            double d4 = Math.log1p(n2++) / Math.log(this.tabuList.maxSize());
            if (GenstarRandom.getInstance().nextDouble() < d4) {
                iSyntheticPopulationSolution4 = iSyntheticPopulationSolution4.getRandomNeighbor(super.getNeighborSearchAlgorithm(), super.computeBuffer(d * (double)n2, iSyntheticPopulationSolution4));
                n2 = 0;
            }
            this.tabuList.add(iSyntheticPopulationSolution4);
        }
        return iSyntheticPopulationSolution3;
    }
}

