/*
 * Decompiled with CFR 0.152.
 */
package gospl.distribution;

import core.metamodel.attribute.Attribute;
import core.metamodel.io.GSSurveyType;
import core.metamodel.value.IValue;
import core.util.data.GSDataParser;
import core.util.data.GSEnumDataType;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.control.ControlContingency;
import gospl.distribution.matrix.coordinate.ACoordinate;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class GosplContingencyTable
extends AFullNDimensionalMatrix<Integer> {
    public GosplContingencyTable(Set<Attribute<? extends IValue>> set) {
        super(set, GSSurveyType.ContingencyTable);
    }

    protected GosplContingencyTable(Map<ACoordinate<Attribute<? extends IValue>, IValue>, AControl<Integer>> map) {
        super(new ConcurrentHashMap(map));
    }

    @Override
    public boolean addValue(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate, AControl<? extends Number> aControl) {
        if (this.matrix.containsKey(aCoordinate)) {
            return false;
        }
        return this.setValue(aCoordinate, aControl);
    }

    @Override
    public final boolean addValue(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate, Integer n) {
        return this.addValue(aCoordinate, (AControl<? extends Number>)new ControlContingency(n));
    }

    @Override
    public boolean setValue(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate, AControl<? extends Number> aControl) {
        if (this.isCoordinateCompliant(aCoordinate)) {
            aCoordinate.setHashIndex(this.matrix.size());
            this.matrix.put(aCoordinate, new ControlContingency(aControl.getValue().intValue()));
            return true;
        }
        return false;
    }

    @Override
    public final boolean setValue(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate, Integer n) {
        return this.setValue(aCoordinate, (AControl<? extends Number>)new ControlContingency(n));
    }

    @Override
    public AControl<Integer> getNulVal() {
        return new ControlContingency(0);
    }

    @Override
    public AControl<Integer> getIdentityProductVal() {
        return new ControlContingency(1);
    }

    @Override
    public AControl<Integer> getAtomicVal() {
        return new ControlContingency(1);
    }

    @Override
    public AControl<Integer> parseVal(GSDataParser gSDataParser, String string) {
        if (!GSEnumDataType.Integer.equals((Object)gSDataParser.getValueType(string))) {
            return this.getNulVal();
        }
        return new ControlContingency(Integer.valueOf(string));
    }

    @Override
    public boolean checkGlobalSum() {
        return true;
    }

    @Override
    public void normalize() throws IllegalArgumentException {
        throw new IllegalArgumentException("should not normalize a " + String.valueOf((Object)this.getMetaDataType()));
    }
}

