/*
 * Decompiled with CFR 0.152.
 */
package gospl.distribution;

import core.metamodel.attribute.Attribute;
import core.metamodel.io.GSSurveyType;
import core.metamodel.value.IValue;
import core.util.data.GSDataParser;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.control.ControlFrequency;
import gospl.distribution.matrix.coordinate.ACoordinate;
import java.util.Map;
import java.util.Set;

public class GosplJointDistribution
extends AFullNDimensionalMatrix<Double> {
    private final Double min = Math.pow(10.0, -8.0);

    protected GosplJointDistribution(Map<ACoordinate<Attribute<? extends IValue>, IValue>, AControl<Double>> map) {
        super(map);
    }

    public GosplJointDistribution(Set<Attribute<? extends IValue>> set, GSSurveyType gSSurveyType) {
        super(set, gSSurveyType);
    }

    @Override
    public boolean addValue(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate, AControl<? extends Number> aControl) {
        if (this.matrix.containsKey(aCoordinate)) {
            return false;
        }
        return this.setValue(aCoordinate, aControl);
    }

    @Override
    public final boolean addValue(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate, Double d) {
        return this.addValue(aCoordinate, (AControl<? extends Number>)new ControlFrequency(d));
    }

    @Override
    public boolean setValue(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate, AControl<? extends Number> aControl) {
        if (this.isCoordinateCompliant(aCoordinate)) {
            aCoordinate.setHashIndex(this.matrix.size());
            this.matrix.put(aCoordinate, new ControlFrequency(aControl.getValue().doubleValue()));
            return true;
        }
        return false;
    }

    @Override
    public final boolean setValue(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate, Double d) {
        return this.setValue(aCoordinate, (AControl<? extends Number>)new ControlFrequency(d));
    }

    @Override
    public AControl<Double> getNulVal() {
        return new ControlFrequency(0.0);
    }

    @Override
    public AControl<Double> getIdentityProductVal() {
        return new ControlFrequency(1.0);
    }

    @Override
    public AControl<Double> getAtomicVal() {
        return new ControlFrequency(this.min / (double)this.size());
    }

    @Override
    public AControl<Double> parseVal(GSDataParser gSDataParser, String string) {
        if (!gSDataParser.getValueType(string).isNumericValue()) {
            return this.getNulVal();
        }
        return new ControlFrequency(gSDataParser.getDouble(string));
    }

    @Override
    public void normalize() throws IllegalArgumentException {
        Double d = (Double)this.getVal().getValue();
        for (AControl<Double> aControl : this.getMatrix().values()) {
            aControl.multiply(1.0 / d);
        }
    }
}

