/*
 * Decompiled with CFR 0.152.
 */
package gospl.distribution.matrix;

import core.metamodel.attribute.Attribute;
import core.metamodel.io.GSSurveyType;
import core.metamodel.value.IValue;
import gospl.distribution.exception.IllegalDistributionCreation;
import gospl.distribution.exception.IllegalNDimensionalMatrixAccess;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.distribution.matrix.ISegmentedNDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.coordinate.ACoordinate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class ASegmentedNDimensionalMatrix<T extends Number>
implements ISegmentedNDimensionalMatrix<T> {
    protected final Set<AFullNDimensionalMatrix<T>> jointDistributionSet;
    protected String label = null;
    protected List<String> genesis = new LinkedList<String>();

    private ASegmentedNDimensionalMatrix() {
        this.jointDistributionSet = new HashSet<AFullNDimensionalMatrix<T>>();
    }

    protected ASegmentedNDimensionalMatrix(Set<AFullNDimensionalMatrix<T>> set) throws IllegalDistributionCreation {
        this();
        if (set.isEmpty()) {
            throw new IllegalArgumentException("Not any distributions to fill in the conditional distribution");
        }
        this.jointDistributionSet.addAll(set);
        if (set.stream().map(AFullNDimensionalMatrix::getMetaDataType).collect(Collectors.toSet()).size() > 1) {
            throw new IllegalDistributionCreation("Divergent frame of reference among sub joint distribution");
        }
    }

    @Override
    public GSSurveyType getMetaDataType() {
        Set set = this.jointDistributionSet.stream().map(AFullNDimensionalMatrix::getMetaDataType).collect(Collectors.toSet());
        if (set.size() != 1) {
            return null;
        }
        return (GSSurveyType)((Object)set.iterator().next());
    }

    @Override
    public boolean isSegmented() {
        return true;
    }

    @Override
    public int getDegree() {
        return this.jointDistributionSet.stream().mapToInt(AFullNDimensionalMatrix::getDegree).sum();
    }

    @Override
    public Set<Attribute<? extends IValue>> getDimensions() {
        return this.jointDistributionSet.stream().flatMap(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().stream()).collect(Collectors.toSet());
    }

    @Override
    public Map<Attribute<? extends IValue>, Set<? extends IValue>> getDimensionsAsAttributesAndValues() {
        HashMap<Attribute<? extends IValue>, Set<? extends IValue>> hashMap = new HashMap<Attribute<? extends IValue>, Set<? extends IValue>>();
        for (AFullNDimensionalMatrix<T> aFullNDimensionalMatrix : this.jointDistributionSet) {
            hashMap.putAll(aFullNDimensionalMatrix.getDimensionsAsAttributesAndValues());
        }
        return hashMap;
    }

    @Override
    public Attribute<? extends IValue> getDimension(IValue iValue) {
        if (this.getDimensions().stream().noneMatch(attribute -> attribute.getValueSpace().contains(iValue) || attribute.getValueSpace().getEmptyValue().equals(iValue))) {
            throw new NullPointerException("Trying to access to aspect value \"" + String.valueOf(iValue) + "\" (\"" + iValue.getValueSpace().getAttribute().getAttributeName() + "\") while this matrix does not contains this dimension");
        }
        return this.getDimensions().stream().filter(attribute -> attribute.getValueSpace().contains(iValue) || attribute.getValueSpace().getEmptyValue().equals(iValue)).findFirst().orElse(null);
    }

    @Override
    public Set<IValue> getAspects() {
        return this.getDimensions().stream().flatMap(attribute -> attribute.getValueSpace().getValues().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<IValue> getAspects(Attribute<? extends IValue> attribute) {
        return Collections.unmodifiableSet(attribute.getValueSpace().getValues());
    }

    @Override
    public int size() {
        return this.jointDistributionSet.stream().mapToInt(AFullNDimensionalMatrix::size).sum();
    }

    @Override
    public ACoordinate<Attribute<? extends IValue>, IValue> getEmptyCoordinate() {
        return this.jointDistributionSet.iterator().next().getEmptyCoordinate();
    }

    @Override
    public Collection<ACoordinate<Attribute<? extends IValue>, IValue>> getCoordinates(Set<IValue> set) {
        Map map = set.stream().collect(Collectors.groupingBy(this::getDimension, Collectors.mapping(Function.identity(), Collectors.toSet())));
        List<AFullNDimensionalMatrix> list = this.jointDistributionSet.stream().filter(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().stream().anyMatch(attribute -> map.keySet().stream().anyMatch(attribute::isLinked))).toList();
        if (list.size() == 1) {
            return list.get(0).getCoordinates(set);
        }
        HashMap hashMap = new HashMap();
        Set set2 = list.stream().flatMap(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().stream()).collect(Collectors.toSet());
        for (Attribute object2 : map.keySet()) {
            for (Attribute attribute : set2.stream().filter(attribute2 -> attribute2.isLinked(object2)).toList()) {
                HashSet<IValue> hashSet = new HashSet<IValue>();
                for (IValue iValue : map.get(object2)) {
                    hashSet.addAll(attribute.findMappedAttributeValues(iValue));
                }
                hashMap.put(attribute, hashSet);
            }
        }
        ArrayList<ACoordinate<Attribute<? extends IValue>, IValue>> arrayList = new ArrayList<ACoordinate<Attribute<? extends IValue>, IValue>>();
        for (Object object4 : list.stream().flatMap(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getMatrix().keySet().stream()).collect(Collectors.toSet())) {
            if (!((ACoordinate)object4).getMap().entrySet().stream().filter(entry -> hashMap.containsKey(entry.getKey())).allMatch(entry -> ((Set)hashMap.get(entry.getKey())).contains(entry.getValue()))) continue;
            arrayList.add((ACoordinate<Attribute<? extends IValue>, IValue>)object4);
        }
        return arrayList;
    }

    @Override
    public Collection<ACoordinate<Attribute<? extends IValue>, IValue>> getOrCreateCoordinates(Set<IValue> set) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Collection<ACoordinate<Attribute<? extends IValue>, IValue>> getCoordinates(String ... stringArray) throws IllegalArgumentException {
        return this.getCoordinates(this.getValues(stringArray));
    }

    @Override
    public ACoordinate<Attribute<? extends IValue>, IValue> getCoordinate(Set<IValue> set) throws NullPointerException {
        Optional<AFullNDimensionalMatrix> optional = this.jointDistributionSet.stream().filter(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getAspects().containsAll(set)).findFirst();
        if (optional.isPresent()) {
            return optional.get().getCoordinate(set);
        }
        throw new NullPointerException("Trying to access coordinate with values " + Arrays.toString(set.toArray()) + " with not any correlates in the matrix " + this.getLabel());
    }

    @Override
    public ACoordinate<Attribute<? extends IValue>, IValue> getCoordinate(String ... stringArray) throws IllegalArgumentException {
        Collection<ACoordinate<Attribute<IValue>, IValue>> collection = this.getCoordinates(stringArray);
        if (collection.size() > 1) {
            throw new IllegalArgumentException("these coordinates do not map to a single cell of the matrix");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("these coordinates do not map to any cell in the matrix");
        }
        return collection.iterator().next();
    }

    @Override
    public Collection<INDimensionalMatrix<Attribute<? extends IValue>, IValue, T>> getMatrices() {
        return Collections.unmodifiableSet(this.jointDistributionSet);
    }

    @Override
    public Map<ACoordinate<Attribute<? extends IValue>, IValue>, AControl<T>> getMatrix() {
        HashMap<ACoordinate<Attribute<IValue>, IValue>, AControl<T>> hashMap = new HashMap<ACoordinate<Attribute<IValue>, IValue>, AControl<T>>();
        for (AFullNDimensionalMatrix<T> aFullNDimensionalMatrix : this.jointDistributionSet) {
            hashMap.putAll(aFullNDimensionalMatrix.getMatrix());
        }
        return hashMap;
    }

    @Override
    public LinkedHashMap<ACoordinate<Attribute<? extends IValue>, IValue>, AControl<T>> getOrderedMatrix() {
        LinkedHashMap<ACoordinate<Attribute<IValue>, IValue>, AControl<T>> linkedHashMap = new LinkedHashMap<ACoordinate<Attribute<IValue>, IValue>, AControl<T>>();
        for (AFullNDimensionalMatrix<T> aFullNDimensionalMatrix : this.jointDistributionSet) {
            linkedHashMap.putAll(aFullNDimensionalMatrix.getOrderedMatrix());
        }
        return linkedHashMap;
    }

    @Override
    public AControl<T> getVal() {
        AControl aControl = this.getNulVal();
        for (AFullNDimensionalMatrix<T> aFullNDimensionalMatrix : this.jointDistributionSet) {
            for (AControl aControl2 : aFullNDimensionalMatrix.matrix.values()) {
                this.getSummedControl(aControl, aControl2);
            }
        }
        return aControl;
    }

    @Override
    public AControl<T> getVal(ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate) {
        return this.getVal((Collection<IValue>)new HashSet<IValue>(aCoordinate.values()), true);
    }

    @Override
    public AControl<T> getVal(IValue iValue) throws IllegalNDimensionalMatrixAccess {
        return this.getVal(iValue, false);
    }

    @Override
    public AControl<T> getVal(IValue iValue, boolean bl) {
        AControl aControl = null;
        for (AFullNDimensionalMatrix aFullNDimensionalMatrix2 : this.jointDistributionSet.stream().filter(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().contains(iValue.getValueSpace().getAttribute())).toList()) {
            if (aControl == null) {
                aControl = aFullNDimensionalMatrix2.getVal(iValue, bl);
                continue;
            }
            if (aControl.equalsVal(aFullNDimensionalMatrix2.getVal(iValue), Math.pow(10.0, -4.0))) continue;
            throw new IllegalNDimensionalMatrixAccess("Incongruent probability in underlying distributions: pv = " + ((Number)aControl.getValue()).doubleValue() + " | nv = " + ((Number)aFullNDimensionalMatrix2.getVal(iValue).getValue()).doubleValue());
        }
        return aControl;
    }

    @Override
    public final AControl<T> getVal(IValue ... iValueArray) {
        return this.getVal(new HashSet<IValue>(Arrays.asList(iValueArray)));
    }

    @Override
    public final AControl<T> getVal(String ... stringArray) {
        return this.getVal(this.getValues(stringArray));
    }

    @Override
    public final AControl<T> getVal(Collection<IValue> collection, boolean bl) {
        return this.getVal(collection);
    }

    private AControl<T> getSummedControl(AControl<T> aControl, AControl<T> aControl2) {
        return aControl.add(aControl2);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Segmented matrix with ").append(this.jointDistributionSet.size()).append(" inner full matrices:\n");
        stringBuilder.append(this.jointDistributionSet.stream().map(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.toString() + "\n").reduce("", (string, string2) -> string + string2));
        return stringBuilder.toString();
    }

    @Override
    public String toCsv(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        for (AFullNDimensionalMatrix<T> aFullNDimensionalMatrix : this.jointDistributionSet) {
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append("\n");
            }
            stringBuilder.append("-- Matrix: ").append(aFullNDimensionalMatrix.getDimensions().size()).append(" dimensions and ").append(aFullNDimensionalMatrix.getDimensions().stream().mapToInt(attribute -> attribute.getValueSpace().getValues().size()).sum()).append(" aspects (theoretical size:").append(this.size()).append(")--\n");
            stringBuilder.append(aFullNDimensionalMatrix.toCsv(c));
        }
        return stringBuilder.toString();
    }

    @Override
    public Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, T>> getMatricesInvolving(Attribute<? extends IValue> attribute) {
        return this.jointDistributionSet.stream().filter(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().contains(attribute)).collect(Collectors.toSet());
    }

    @Override
    public Set<IValue> getValues(String ... stringArray) throws IllegalArgumentException {
        HashSet<IValue> hashSet = new HashSet<IValue>();
        Map map = this.getDimensionsAsAttributesAndValues().keySet().stream().collect(Collectors.toMap(Attribute::getAttributeName, Function.identity()));
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("you should pass pairs of attribute name and corresponding value, such as attribute 1 name, value for attribute 1, attribute 2 name, value for attribute 2...");
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = stringArray[n + 1];
            Attribute attribute = (Attribute)map.get(string);
            if (attribute == null) {
                throw new IllegalArgumentException("unknown attribute " + string);
            }
            hashSet.add((IValue)attribute.getValueSpace().addValue(string2));
            n += 2;
        }
        return hashSet;
    }

    @Override
    public Attribute<? extends IValue> getDimension(String string3) throws IllegalArgumentException {
        for (AFullNDimensionalMatrix<T> aFullNDimensionalMatrix2 : this.jointDistributionSet) {
            for (Attribute<IValue> attribute : aFullNDimensionalMatrix2.getDimensions()) {
                if (!attribute.getAttributeName().equals(string3)) continue;
                return attribute;
            }
        }
        throw new IllegalArgumentException("No dimension named " + string3 + "; available dimensions are: " + this.jointDistributionSet.stream().map(aFullNDimensionalMatrix -> aFullNDimensionalMatrix.getDimensions().stream().map(Attribute::getAttributeName).reduce("", (string, string2) -> string + "," + string2)).reduce("", (string, string2) -> string + "," + string2));
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public List<String> getGenesisAsList() {
        return Collections.unmodifiableList(this.genesis);
    }

    @Override
    public String getGenesisAsString() {
        return String.join((CharSequence)"->", this.genesis);
    }

    @Override
    public void inheritGenesis(AFullNDimensionalMatrix<?> aFullNDimensionalMatrix) {
        this.genesis.addAll(aFullNDimensionalMatrix.getGenesisAsList());
    }

    @Override
    public void addGenesis(String string) {
        this.genesis.add(string);
    }
}

