/*
 * Decompiled with CFR 0.152.
 */
package gospl.distribution.matrix.coordinate;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class ACoordinate<D, A> {
    private final Map<D, A> coordinate;
    private int hashIndex = -1;

    protected ACoordinate(Map<D, A> map) {
        if (!this.isCoordinateSetComplient(map)) {
            throw new IllegalArgumentException("Coordinate must complies to the moto: One attribute, one value");
        }
        this.coordinate = map;
    }

    protected abstract boolean isCoordinateSetComplient(Map<D, A> var1);

    public Collection<A> values() {
        return Collections.unmodifiableCollection(this.coordinate.values());
    }

    public int size() {
        return this.coordinate.size();
    }

    public boolean contains(A a) {
        return this.coordinate.containsValue(a);
    }

    public boolean containsAll(Collection<A> collection) {
        return this.coordinate.values().containsAll(collection);
    }

    public void setHashIndex(int n) {
        if (n == -1) {
            this.hashIndex = n;
        }
    }

    public Set<D> getDimensions() {
        return Collections.unmodifiableSet(this.coordinate.keySet());
    }

    public Map<D, A> getMap() {
        return Collections.unmodifiableMap(this.coordinate);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (A a : this.coordinate.values()) {
            stringBuilder.append(stringBuilder.isEmpty() ? "[" : " - ").append("[").append(a).append("]");
        }
        return stringBuilder.append("]").toString();
    }

    public int hashCode() {
        return Objects.hash(this.coordinate, this.hashIndex);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ACoordinate aCoordinate = (ACoordinate)object;
        return Objects.equals(this.coordinate, aCoordinate.coordinate) || this.hashIndex == aCoordinate.hashIndex;
    }
}

