/*
 * Decompiled with CFR 0.152.
 */
package gospl.generator.util;

import core.configuration.dictionary.AttributeDictionary;
import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.AttributeFactory;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import core.util.data.GSEnumDataType;
import core.util.exception.GSIllegalRangedData;
import core.util.random.GenstarRandom;
import core.util.random.GenstarRandomUtils;
import core.util.random.roulette.ARouletteWheelSelection;
import core.util.random.roulette.RouletteWheelSelectionFactory;
import gospl.GosplEntity;
import gospl.GosplPopulation;
import gospl.generator.ISyntheticGosplPopGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GSUtilGenerator
implements ISyntheticGosplPopGenerator {
    private int maxAtt;
    private int maxVal;
    char[] chars = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    private AttributeDictionary dictionary;
    private Map<Attribute<? extends IValue>, ARouletteWheelSelection<Double, IValue>> attributesProba;
    Random random = GenstarRandom.getInstance();

    public GSUtilGenerator(int n, int n2) {
        this.maxAtt = n;
        this.maxVal = n2;
    }

    public GSUtilGenerator(AttributeDictionary attributeDictionary) {
        this.dictionary = attributeDictionary;
    }

    @Override
    public GosplPopulation generate(int n2) {
        Object object;
        int n3;
        GSPerformanceUtil gSPerformanceUtil = new GSPerformanceUtil("Generate util population", GSPerformanceUtil.Level.TRACE);
        GosplPopulation gosplPopulation = new GosplPopulation();
        if (this.dictionary == null) {
            this.dictionary = new AttributeDictionary();
        }
        if (this.dictionary.getAttributes() == null || this.dictionary.getAttributes().isEmpty()) {
            gSPerformanceUtil.getStempPerformance("Generating dictionary from scratch");
            n3 = this.random.nextInt(this.maxAtt);
            n3 = n3 <= 1 ? 2 : n3;
            object = new Attribute[n3];
            this.dictionary.addAttributes(IntStream.range(0, n3).mapToObj(n -> this.random.nextDouble() > 0.5 ? this.createStringAtt() : this.createIntegerAtt()).toList().toArray((T[])object));
        }
        this.setupAttributeProbabilityTable();
        gSPerformanceUtil.sysoStempPerformance(0.0, "Start generating " + n2 + " entity", (Object)this);
        n3 = 0;
        while (n3 < n2) {
            object = new GosplEntity(this.attributesProba.keySet().stream().collect(Collectors.toMap(Function.identity(), this::randomVal)));
            for (Attribute attribute2 : this.dictionary.getAttributes().stream().filter(attribute -> !this.attributesProba.containsKey(attribute)).collect(Collectors.toSet())) {
                IValue iValue = ((ADemoEntity)object).getValueForAttribute(attribute2.getReferentAttribute());
                if (iValue == null) continue;
                Collection<IValue> collection = attribute2.findMappedAttributeValues(iValue);
                ((ADemoEntity)object).setAttributeValue(attribute2, this.randomUniformVal(collection));
            }
            gosplPopulation.add((ADemoEntity)object);
            if ((double)n3 % ((double)n2 / 10.0) == 0.0) {
                gSPerformanceUtil.sysoStempPerformance((double)n3 / ((double)n2 * 1.0), (Object)this);
            }
            ++n3;
        }
        gSPerformanceUtil.sysoStempPerformance(1.0, (Object)this);
        return gosplPopulation;
    }

    private Attribute<? extends IValue> createIntegerAtt() {
        int n = this.random.nextInt(this.maxVal);
        n = n <= 1 ? 2 : n;
        Attribute<? extends IValue> attribute = null;
        try {
            attribute = AttributeFactory.getFactory().createAttribute(this.generateName(this.random.nextInt(6) + 1), GSEnumDataType.Integer, IntStream.range(0, n).mapToObj(String::valueOf).toList());
        }
        catch (GSIllegalRangedData gSIllegalRangedData) {
            gSIllegalRangedData.printStackTrace();
        }
        return attribute;
    }

    private Attribute<? extends IValue> createStringAtt() {
        int n2 = this.random.nextInt(this.maxVal);
        n2 = n2 <= 1 ? 2 : n2;
        Attribute<? extends IValue> attribute = null;
        try {
            attribute = AttributeFactory.getFactory().createAttribute(this.generateName(this.random.nextInt(6) + 1), GSEnumDataType.Nominal, IntStream.range(0, n2).mapToObj(n -> this.generateName(this.random.nextInt(n + 1))).toList());
        }
        catch (GSIllegalRangedData gSIllegalRangedData) {
            gSIllegalRangedData.printStackTrace();
        }
        return attribute;
    }

    private String generateName(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < n) {
            char c = this.chars[this.random.nextInt(this.chars.length)];
            stringBuilder.append(c);
            ++n2;
        }
        return stringBuilder.toString();
    }

    private void setupAttributeProbabilityTable() {
        this.attributesProba = new HashMap<Attribute<? extends IValue>, ARouletteWheelSelection<Double, IValue>>();
        Set set = this.dictionary.getAttributes().stream().filter(attribute -> attribute.getReferentAttribute().equals(attribute)).collect(Collectors.toSet());
        for (Attribute attribute2 : set) {
            ArrayList arrayList = new ArrayList(attribute2.getValueSpace().getValues());
            List<Double> list = arrayList.stream().map(iValue -> this.random.nextDouble()).toList();
            double d = list.stream().mapToDouble(Double::doubleValue).sum();
            this.attributesProba.put(attribute2, RouletteWheelSelectionFactory.getRouletteWheel(list.stream().map(d2 -> d2 / d).toList(), arrayList));
        }
    }

    private IValue randomVal(Attribute<? extends IValue> attribute) {
        return (IValue)this.attributesProba.get(attribute).drawObject();
    }

    private IValue randomUniformVal(Collection<? extends IValue> collection) {
        return GenstarRandomUtils.oneOf(collection);
    }
}

