/*
 * Decompiled with CFR 0.152.
 */
package gospl.io;

import core.configuration.dictionary.IGenstarDictionary;
import core.metamodel.attribute.Attribute;
import core.metamodel.io.GSSurveyType;
import core.metamodel.io.IGSSurvey;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public abstract class AbstractInputHandler
implements IGSSurvey {
    protected final String surveyCompleteFile;
    protected final String surveyFileName;
    protected final String surveyFilePath;
    protected final GSSurveyType dataFileType;
    private final GSPerformanceUtil gspu;
    public static GSPerformanceUtil.Level LOG_LEVEL = GSPerformanceUtil.Level.TRACE;

    public AbstractInputHandler(GSSurveyType gSSurveyType, String string) {
        this.dataFileType = gSSurveyType;
        this.gspu = new GSPerformanceUtil("Read header from survey file");
        this.surveyCompleteFile = string;
        this.surveyFileName = Paths.get(string, new String[0]).getFileName().toString();
        this.surveyFilePath = Paths.get(string, new String[0]).toAbsolutePath().toString();
    }

    public AbstractInputHandler(GSSurveyType gSSurveyType, File file) {
        this.dataFileType = gSSurveyType;
        this.gspu = new GSPerformanceUtil("Read header from survey file");
        this.surveyCompleteFile = file.getAbsolutePath();
        this.surveyFileName = file.getName();
        this.surveyFilePath = file.getAbsolutePath();
    }

    @Override
    public Map<Integer, Set<IValue>> getColumnHeaders(IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary) {
        HashMap<Integer, Set<IValue>> hashMap = new HashMap<Integer, Set<IValue>>();
        int n = this.getFirstColumnIndex();
        while (n <= this.getLastColumnIndex()) {
            List<String> list = this.readLines(0, this.getFirstRowIndex(), n);
            this.gspu.sysoStempMessage("trying to detect an attribute based on row values: " + String.valueOf(list), LOG_LEVEL);
            for (String string2 : list) {
                Set set = iGenstarDictionary.getAttributeAndRecord().stream().flatMap(iAttribute -> iAttribute.getValueSpace().getValues().stream()).filter(iValue -> iValue.getStringValue().equals(string2)).collect(Collectors.toSet());
                if (set.isEmpty()) continue;
                if (set.size() > 1) {
                    HashSet hashSet = new HashSet(set);
                    set = list.stream().flatMap(string -> iGenstarDictionary.getAttributeAndRecord().stream().filter(iAttribute -> iAttribute.getAttributeName().equals(string))).flatMap(iAttribute -> hashSet.stream().filter(iValue -> iValue.getValueSpace().getAttribute().equals(iAttribute))).collect(Collectors.toSet());
                }
                if (hashMap.containsKey(n)) {
                    ((Set)hashMap.get(n)).addAll(set);
                    continue;
                }
                hashMap.put(n, new HashSet(set));
            }
            ++n;
        }
        return hashMap;
    }

    @Override
    public Map<Integer, Set<IValue>> getRowHeaders(IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary) {
        Object object;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n2 = 0;
        while (n2 < this.getFirstRowIndex()) {
            List<String> list = this.readLine(n2);
            int n3 = 0;
            while (n3 < this.getFirstColumnIndex()) {
                object = list.get(n3);
                if (iGenstarDictionary.containsAttribute((String)object) || iGenstarDictionary.containsRecord((String)object)) {
                    treeSet.add(n3);
                }
                if (((String)object).isEmpty()) {
                    List<String> list2 = this.readColumn(n3);
                    this.gspu.sysoStempMessage("trying to detect an attribute based on header values: " + String.valueOf(list2), LOG_LEVEL);
                    if (iGenstarDictionary.getAttributes().stream().anyMatch(attribute -> attribute.getValueSpace().containsAllLabels(list2))) {
                        treeSet.add(n3);
                    } else {
                        this.gspu.sysoStempMessage("the values " + String.valueOf(list2) + " match none of our attributes: " + String.valueOf(iGenstarDictionary.getAttributes().stream().map(attribute -> attribute.getValueSpace().getValues().stream().map(IValue::getStringValue).toList()).toList()), GSPerformanceUtil.Level.WARN);
                    }
                }
                ++n3;
            }
            ++n2;
        }
        HashMap<Integer, Set<IValue>> hashMap = new HashMap<Integer, Set<IValue>>();
        int n4 = this.getFirstRowIndex();
        while (n4 <= this.getLastRowIndex()) {
            List<String> list = this.readColumns(0, this.getFirstColumnIndex(), n4);
            object = treeSet.stream().map(n -> (String)list.get((int)n)).toList();
            int n5 = 0;
            while (n5 < object.size()) {
                String string = (String)object.get(n5);
                Set set = iGenstarDictionary.getAttributeAndRecord().stream().flatMap(iAttribute -> iAttribute.getValueSpace().getValues().stream()).filter(iValue -> iValue.getStringValue().equals(string)).collect(Collectors.toSet());
                if (!set.isEmpty()) {
                    if (set.size() > 1) {
                        HashSet hashSet = new HashSet();
                        List<String> list3 = this.readLines(0, this.getFirstRowIndex(), n5);
                        if (list3.stream().allMatch(String::isEmpty)) {
                            for (List<String> list2 : this.readColumns(0, this.getFirstColumnIndex())) {
                                hashSet.addAll(iGenstarDictionary.getAttributeAndRecord().stream().filter(iAttribute -> iAttribute.getValueSpace().getValues().stream().allMatch(iValue -> collection2.contains(iValue.getStringValue()))).collect(Collectors.toSet()));
                            }
                        } else {
                            hashSet.addAll(iGenstarDictionary.getAttributeAndRecord().stream().flatMap(iAttribute -> iGenstarDictionary.getAttributeAndRecord().stream().filter(iAttribute2 -> iAttribute2.getAttributeName().equals(iAttribute.getAttributeName()))).collect(Collectors.toSet()));
                        }
                        HashSet collection2 = new HashSet(set);
                        for (IValue iValue2 : collection2) {
                            if (hashSet.contains(iValue2.getValueSpace().getAttribute())) continue;
                            set.remove(iValue2);
                        }
                    }
                    if (hashMap.containsKey(n4)) {
                        ((Set)hashMap.get(n4)).addAll(set);
                    } else {
                        hashMap.put(n4, new HashSet(set));
                    }
                }
                ++n5;
            }
            ++n4;
        }
        return hashMap;
    }

    @Override
    public Map<Integer, Attribute<? extends IValue>> getColumnSample(IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary) {
        HashMap<Integer, Attribute<? extends IValue>> hashMap = new HashMap<Integer, Attribute<? extends IValue>>();
        int n = this.getFirstColumnIndex();
        while (n <= this.getLastColumnIndex()) {
            List<String> list = this.readLines(0, this.getFirstRowIndex(), n);
            Set set = iGenstarDictionary.getAttributes().stream().filter(attribute -> list.stream().anyMatch(string -> attribute.getAttributeName().equals(string))).collect(Collectors.toSet());
            if (!set.isEmpty()) {
                if (set.size() > 1) {
                    String string;
                    int n2 = this.getFirstRowIndex();
                    Optional<Attribute> optional = null;
                    do {
                        string = this.read(n2++, n);
                    } while ((optional = set.stream().filter(attribute -> attribute.getValueSpace().getValues().stream().anyMatch(iValue -> iValue.getStringValue().equals(string))).findAny()).isPresent());
                    hashMap.put(n, optional.get());
                } else {
                    hashMap.put(n, (Attribute)set.iterator().next());
                }
            }
            ++n;
        }
        return hashMap;
    }

    @Override
    public Map<String, Integer> getColumnIdAndWeight(IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = iGenstarDictionary.getIdentifierAttributeName();
        String string3 = iGenstarDictionary.getWeightAttributeName();
        if (!string2.isEmpty()) {
            arrayList.add(string2);
        }
        if (!string3.isEmpty()) {
            arrayList.add(string3);
        }
        if (arrayList.isEmpty()) {
            return hashMap;
        }
        int n = this.getFirstColumnIndex();
        while (n <= this.getLastColumnIndex()) {
            List<String> list = this.readLines(0, this.getFirstRowIndex(), n);
            Optional<String> optional = arrayList.stream().filter(string -> list.stream().anyMatch(string::equals)).findFirst();
            if (optional.isPresent()) {
                hashMap.put(optional.get(), n);
            }
            ++n;
        }
        return hashMap;
    }

    @Override
    public final GSSurveyType getDataFileType() {
        return this.dataFileType;
    }

    @Override
    public String getSurveyFilePath() {
        return this.surveyFilePath;
    }
}

