/*
 * Decompiled with CFR 0.152.
 */
package gospl.io.util;

import core.configuration.GenstarJsonUtil;
import core.configuration.dictionary.AttributeDictionary;
import core.configuration.dictionary.IGenstarDictionary;
import core.metamodel.attribute.Attribute;
import core.metamodel.value.IValue;
import core.util.exception.GenstarException;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;

public class ReadDictionaryUtils {
    public static boolean detectIsRange(Collection<String> collection) {
        if (collection.size() < 2) {
            return false;
        }
        Pattern pattern = Pattern.compile("[\\D]*\\d+[\\D]*");
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        boolean bl = false;
        if (pattern.matcher((CharSequence)arrayList.get(0)).matches()) {
            bl = true;
        }
        boolean bl2 = false;
        if (pattern.matcher((CharSequence)arrayList.get(arrayList.size() - 1)).matches()) {
            bl2 = true;
        }
        Pattern pattern2 = Pattern.compile("[\\D]*\\d+[\\D]+\\d+[\\D]*");
        int n = bl ? 1 : 0;
        while (n < arrayList.size() - (bl2 ? 2 : 1)) {
            if (!pattern2.matcher((CharSequence)arrayList.get(n)).matches()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean detectIsInteger(Collection<String> collection) {
        Pattern pattern = Pattern.compile("[\\D]*\\d+[\\D]*");
        for (String string : collection) {
            if (pattern.matcher(string).matches()) continue;
            return false;
        }
        return true;
    }

    private ReadDictionaryUtils() {
    }

    public static IGenstarDictionary<Attribute<? extends IValue>> readFromGenstarConfig(String string) {
        GenstarJsonUtil genstarJsonUtil = new GenstarJsonUtil();
        try {
            return genstarJsonUtil.unmarshalFromGenstarJson(FileSystems.getDefault().getPath(string, new String[0]), AttributeDictionary.class);
        }
        catch (IOException | IllegalArgumentException exception) {
            exception.printStackTrace();
            throw new GenstarException("error while reading the config file: " + exception.getMessage(), exception);
        }
    }
}

