/*
 * Decompiled with CFR 0.152.
 */
package gospl.io.util;

import core.configuration.dictionary.IGenstarDictionary;
import core.metamodel.attribute.Attribute;
import core.metamodel.io.GSSurveyType;
import core.metamodel.io.IGSSurvey;
import core.metamodel.value.IValue;
import core.util.exception.GenstarException;
import gospl.GosplPopulation;
import gospl.distribution.GosplInputDataManager;
import gospl.io.CsvInputHandler;
import gospl.io.GosplSurveyFactory;
import gospl.io.exception.InvalidSurveyFormatException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;

public class ReadPopulationsUtils {
    private ReadPopulationsUtils() {
    }

    public static GosplPopulation readFromCSVFile(String string, IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary) {
        char c;
        File file = new File(string);
        try {
            c = CsvInputHandler.detectSeparator(file);
        }
        catch (IOException iOException) {
            throw new GenstarException("error while trying to detect separator from file " + String.valueOf(file), iOException);
        }
        return ReadPopulationsUtils.readFromCSVFile(string, iGenstarDictionary, c);
    }

    public static GosplPopulation readFromCSVFile(String string, IGenstarDictionary<Attribute<? extends IValue>> iGenstarDictionary, char c) {
        IGSSurvey iGSSurvey;
        GosplSurveyFactory gosplSurveyFactory = new GosplSurveyFactory();
        try {
            iGSSurvey = gosplSurveyFactory.getSurvey(string, 0, c, 1, 0, GSSurveyType.Sample, ".csv");
        }
        catch (IOException iOException) {
            throw new GenstarException(iOException);
        }
        catch (InvalidSurveyFormatException invalidSurveyFormatException) {
            throw new IllegalArgumentException("Invalid survey format", invalidSurveyFormatException);
        }
        GosplPopulation gosplPopulation = null;
        try {
            gosplPopulation = GosplInputDataManager.getSample(iGSSurvey, iGenstarDictionary, null, Collections.emptyMap());
        }
        catch (InvalidSurveyFormatException | IOException exception) {
            throw new GenstarException(exception);
        }
        return gosplPopulation;
    }
}

