/*
 * Decompiled with CFR 0.152.
 */
package gospl.sampler.sr;

import core.metamodel.attribute.Attribute;
import core.metamodel.value.IValue;
import core.util.random.roulette.ARouletteWheelSelection;
import core.util.random.roulette.RouletteWheelSelectionFactory;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.coordinate.ACoordinate;
import gospl.sampler.IDistributionSampler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class GosplBasicSampler
implements IDistributionSampler {
    ARouletteWheelSelection<Double, ACoordinate<Attribute<? extends IValue>, IValue>> sampler;
    private final double EPSILON = Math.pow(10.0, -6.0);

    @Override
    public void setDistribution(AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix) {
        if (aFullNDimensionalMatrix == null) {
            throw new NullPointerException();
        }
        if (aFullNDimensionalMatrix.getMatrix().isEmpty()) {
            throw new IllegalArgumentException("Cannot setup a sampler with an empty distribution matrix " + String.valueOf(aFullNDimensionalMatrix));
        }
        Map<ACoordinate<Attribute<IValue>, IValue>, AControl<Double>> map = aFullNDimensionalMatrix.getMatrix();
        ArrayList<ACoordinate<Attribute<IValue>, IValue>> arrayList = new ArrayList<ACoordinate<Attribute<IValue>, IValue>>(map.keySet());
        ArrayList<Double> arrayList2 = new ArrayList<Double>(aFullNDimensionalMatrix.size());
        double d = 0.0;
        for (ACoordinate aCoordinate : arrayList) {
            double d2 = map.get(aCoordinate).getValue();
            d += d2;
            arrayList2.add(d2);
        }
        if (Math.abs(d - 1.0) > this.EPSILON) {
            throw new IllegalArgumentException("Sum of probabilities for this sampler is not equal to 1 (SOP = " + d + ")");
        }
        this.sampler = RouletteWheelSelectionFactory.getRouletteWheel(arrayList2, arrayList);
    }

    @Override
    public ACoordinate<Attribute<? extends IValue>, IValue> draw() {
        return (ACoordinate)this.sampler.drawObject();
    }

    @Override
    public final Collection<ACoordinate<Attribute<? extends IValue>, IValue>> draw(int n2) {
        return IntStream.range(0, n2).mapToObj(n -> this.draw()).toList();
    }

    @Override
    public String toCsv(String string) {
        ArrayList arrayList = new ArrayList(this.sampler.getKeys().parallelStream().flatMap(aCoordinate -> aCoordinate.getDimensions().stream()).collect(Collectors.toSet()));
        StringBuilder stringBuilder = new StringBuilder("Basic sampler: ").append(this.sampler.getKeys().size()).append(" discret probabilities\n");
        stringBuilder.append(String.join((CharSequence)string, arrayList.stream().map(Attribute::getAttributeName).toList())).append("; Probability\n");
        for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate2 : this.sampler.getKeys()) {
            StringBuilder stringBuilder2 = new StringBuilder();
            for (Attribute attribute : arrayList) {
                if (aCoordinate2.getDimensions().contains(attribute)) {
                    if (stringBuilder2.isEmpty()) {
                        stringBuilder2.append(aCoordinate2.getMap().get(attribute).getStringValue());
                        continue;
                    }
                    stringBuilder2.append(string).append(aCoordinate2.getMap().get(attribute).getStringValue());
                    continue;
                }
                if (stringBuilder2.isEmpty()) {
                    stringBuilder2.append(" ");
                    continue;
                }
                stringBuilder2.append(string).append(" ");
            }
            stringBuilder.append((CharSequence)stringBuilder2).append(string).append(this.sampler.getValue(aCoordinate2)).append("\n");
        }
        return stringBuilder.toString();
    }
}

