/*
 * Decompiled with CFR 0.152.
 */
package gospl.validation;

import core.metamodel.IPopulation;
import core.metamodel.IQueryablePopulation;
import core.metamodel.attribute.Attribute;
import core.metamodel.entity.ADemoEntity;
import core.metamodel.io.GSSurveyType;
import core.metamodel.value.IValue;
import core.util.GSPerformanceUtil;
import gama.dev.DEBUG;
import gospl.distribution.GosplNDimensionalMatrixFactory;
import gospl.distribution.matrix.AFullNDimensionalMatrix;
import gospl.distribution.matrix.INDimensionalMatrix;
import gospl.distribution.matrix.control.AControl;
import gospl.distribution.matrix.coordinate.ACoordinate;
import gospl.validation.GosplIndicator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;

public class GosplIndicatorFactory {
    private static final String INPUT_CONTINGENCY_ARGUMENT_CANNOT_BE = "Input contingency argument cannot be ";
    private static final String OF_TYPE = "of type ";
    private static Double EPSILON = Math.pow(10.0, -6.0);
    private static GosplIndicatorFactory gif = new GosplIndicatorFactory();
    private double criticalPValue = 0.05;
    private GSPerformanceUtil gspu;

    private GosplIndicatorFactory() {
    }

    public static GosplIndicatorFactory getFactory() {
        GosplIndicatorFactory.gif.gspu = new GSPerformanceUtil("GSUtil print for indicator factory");
        return gif;
    }

    public void setChiSquareCritivalPValue(double d) {
        this.criticalPValue = d;
    }

    public INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> getAbsoluteErrors(IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer> iNDimensionalMatrix2, Set<INDimensionalMatrix<Attribute<? extends IValue>, IValue, Integer>> set) {
        Set set2 = set.stream().flatMap(iNDimensionalMatrix -> iNDimensionalMatrix.getDimensions().stream()).collect(Collectors.toSet());
        if (iNDimensionalMatrix2.getDimensions().stream().allMatch(attribute -> set2.stream().anyMatch(attribute2 -> attribute2.isLinked((Attribute<? extends IValue>)attribute)))) {
            throw new IllegalArgumentException("Some attribute of the errorMatrix does not match with any marginals:\n" + iNDimensionalMatrix2.getDimensions().stream().filter(attribute -> set2.stream().noneMatch(attribute2 -> attribute2.isLinked((Attribute<? extends IValue>)attribute))).map(Attribute::getAttributeName).collect(Collectors.joining("; ")));
        }
        Map map = set2.stream().filter(attribute -> iPopulation.getPopulationAttributes().stream().anyMatch(attribute2 -> attribute.isLinked((Attribute<? extends IValue>)attribute2))).collect(Collectors.toMap(Function.identity(), attribute -> iPopulation.getPopulationAttributes().stream().filter(attribute2 -> attribute.isLinked((Attribute<? extends IValue>)attribute2)).findFirst().get()));
        AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix = GosplNDimensionalMatrixFactory.getFactory().createContingency(new HashSet<Attribute<? extends IValue>>(map.keySet()), iPopulation);
        for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : iNDimensionalMatrix2.getMatrix().keySet()) {
            int n = (Integer)set.stream().filter(iNDimensionalMatrix -> iNDimensionalMatrix.getDimensions().containsAll(aCoordinate.getDimensions())).findFirst().get().getVal(aCoordinate.values()).getValue();
            Collection collection = aFullNDimensionalMatrix.getDimensions().stream().flatMap(attribute -> ((Attribute)map.get(attribute)).findMappedAttributeValues((IValue)aCoordinate.getMap().get(attribute)).stream()).collect(Collectors.toSet());
            int n2 = aFullNDimensionalMatrix.getVal(collection, true).getValue();
            iNDimensionalMatrix2.setValue(aCoordinate, n - n2);
        }
        return iNDimensionalMatrix2;
    }

    public int getTACE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        double d = new ChiSquaredDistribution((double)iNDimensionalMatrix.getDegree()).inverseCumulativeProbability(this.criticalPValue);
        return switch (iNDimensionalMatrix.getMetaDataType()) {
            case GSSurveyType.ContingencyTable -> this.getIntegerTACE(iNDimensionalMatrix, GosplNDimensionalMatrixFactory.getFactory().createContingency(iPopulation), d);
            case GSSurveyType.GlobalFrequencyTable -> this.getDoubleTACE(iNDimensionalMatrix, GosplNDimensionalMatrixFactory.getFactory().createDistribution(iPopulation), d);
            case GSSurveyType.LocalFrequencyTable -> throw new IllegalArgumentException("Input contingency argument cannot be of type " + String.valueOf((Object)iNDimensionalMatrix.getMetaDataType()));
            default -> throw new IllegalArgumentException("Input contingency argument cannot be a segmented matrix with multiple matrix meta data type : it should have been collapse [see GosplInputDataManager#collapseDataTablesIntoDistribution]");
        };
    }

    public int getTACE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IQueryablePopulation<ADemoEntity, Attribute<? extends IValue>> iQueryablePopulation) {
        double d = new ChiSquaredDistribution((double)iNDimensionalMatrix.getDegree()).inverseCumulativeProbability(this.criticalPValue);
        return switch (iNDimensionalMatrix.getMetaDataType()) {
            case GSSurveyType.ContingencyTable -> this.getIntegerTACE(iNDimensionalMatrix, iQueryablePopulation, d);
            case GSSurveyType.GlobalFrequencyTable -> this.getDoubleTACE(iNDimensionalMatrix, iQueryablePopulation, d);
            case GSSurveyType.LocalFrequencyTable -> throw new IllegalArgumentException("Input contingency argument cannot be of type " + String.valueOf((Object)iNDimensionalMatrix.getMetaDataType()));
            default -> throw new IllegalArgumentException("Input contingency argument cannot be a segmented matrix with multiple matrix meta data type : it should have been collapse [see GosplInputDataManager#collapseDataTablesIntoDistribution]");
        };
    }

    public int getTACE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation, double d) {
        return switch (iNDimensionalMatrix.getMetaDataType()) {
            case GSSurveyType.ContingencyTable -> this.getIntegerTACE(iNDimensionalMatrix, GosplNDimensionalMatrixFactory.getFactory().createContingency(iPopulation), d);
            case GSSurveyType.GlobalFrequencyTable -> this.getDoubleTACE(iNDimensionalMatrix, GosplNDimensionalMatrixFactory.getFactory().createDistribution(iPopulation), d);
            case GSSurveyType.LocalFrequencyTable -> throw new IllegalArgumentException("Input contingency argument cannot be of type " + String.valueOf((Object)iNDimensionalMatrix.getMetaDataType()));
            default -> throw new IllegalArgumentException("Input contingency argument cannot be a segmented matrix with multiple matrix meta data type : it should have been collapse [see GosplInputDataManager#collapseDataTablesIntoDistribution]");
        };
    }

    public int getIntegerTACE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix, double d) {
        return iNDimensionalMatrix.getMatrix().entrySet().stream().mapToInt(entry -> (double)Math.abs((Integer)aFullNDimensionalMatrix.getVal(((ACoordinate)entry.getKey()).values(), true).getValue() - ((Number)((AControl)entry.getValue()).getValue()).intValue()) / ((Number)((AControl)entry.getValue()).getValue()).doubleValue() > d ? 1 : 0).sum();
    }

    public int getDoubleTACE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix, double d) {
        return iNDimensionalMatrix.getMatrix().entrySet().stream().mapToInt(entry -> Math.abs((Double)aFullNDimensionalMatrix.getVal(((ACoordinate)entry.getKey()).values(), true).getValue() - ((Number)((AControl)entry.getValue()).getValue()).doubleValue()) / ((Number)((AControl)entry.getValue()).getValue()).doubleValue() > d ? 1 : 0).sum();
    }

    public int getIntegerTACE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IQueryablePopulation<ADemoEntity, Attribute<? extends IValue>> iQueryablePopulation, double d) {
        return iNDimensionalMatrix.getMatrix().entrySet().stream().mapToInt(entry -> (double)Math.abs(iQueryablePopulation.getCountHavingValues(((ACoordinate)entry.getKey()).values().stream().collect(Collectors.groupingBy(iValue -> (Attribute)iNDimensionalMatrix.getDimension((IValue)iValue), Collectors.toCollection(ArrayList::new)))) - ((Number)((AControl)entry.getValue()).getValue()).intValue()) / ((Number)((AControl)entry.getValue()).getValue()).doubleValue() > d ? 1 : 0).sum();
    }

    public int getDoubleTACE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IQueryablePopulation<ADemoEntity, Attribute<? extends IValue>> iQueryablePopulation, double d) {
        return iNDimensionalMatrix.getMatrix().entrySet().stream().mapToInt(entry -> Math.abs((double)(iQueryablePopulation.getCountHavingValues(((ACoordinate)entry.getKey()).values().stream().collect(Collectors.groupingBy(iValue -> (Attribute)iNDimensionalMatrix.getDimension((IValue)iValue), Collectors.toCollection(ArrayList::new)))) / iQueryablePopulation.size()) - ((Number)((AControl)entry.getValue()).getValue()).doubleValue()) > d ? 1 : 0).sum();
    }

    public int getTAE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        return switch (iNDimensionalMatrix.getMetaDataType()) {
            case GSSurveyType.ContingencyTable -> this.getIntegerTAE(iNDimensionalMatrix, GosplNDimensionalMatrixFactory.getFactory().createContingency(iPopulation));
            case GSSurveyType.GlobalFrequencyTable -> (int)Math.round(this.getDoubleTAE(iNDimensionalMatrix, GosplNDimensionalMatrixFactory.getFactory().createDistribution(iPopulation)) * (double)iPopulation.size());
            case GSSurveyType.LocalFrequencyTable -> throw new IllegalArgumentException("Input contingency argument cannot be of type " + String.valueOf((Object)iNDimensionalMatrix.getMetaDataType()));
            default -> throw new IllegalArgumentException("Input contingency argument cannot be a segmented matrix with multiple matrix meta data type");
        };
    }

    public int getTAE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IQueryablePopulation<ADemoEntity, Attribute<? extends IValue>> iQueryablePopulation) {
        return switch (iNDimensionalMatrix.getMetaDataType()) {
            case GSSurveyType.ContingencyTable -> this.getIntegerTAE(iNDimensionalMatrix, iQueryablePopulation);
            case GSSurveyType.GlobalFrequencyTable -> (int)Math.round(this.getDoubleTAE(iNDimensionalMatrix, iQueryablePopulation) * (double)iQueryablePopulation.size());
            case GSSurveyType.LocalFrequencyTable -> throw new IllegalArgumentException("Input contingency argument cannot be of type " + String.valueOf((Object)iNDimensionalMatrix.getMetaDataType()));
            default -> throw new IllegalArgumentException("Input contingency argument cannot be a segmented matrix with multiple matrix meta data type");
        };
    }

    public int getIntegerTAE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix) {
        if (DEBUG.IS_ON()) {
            this.gspu.sysoStempMessage("Compute TAE for matrix " + iNDimensionalMatrix.getGenesisAsString() + " and " + aFullNDimensionalMatrix.getGenesisAsString());
            for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate2 : iNDimensionalMatrix.getMatrix().keySet()) {
                this.gspu.sysoStempMessage("Matrix coordinate :" + aCoordinate2.values().stream().map(IValue::getStringValue).collect(Collectors.joining("; ")));
                this.gspu.sysoStempMessage("\tValue = " + String.valueOf(iNDimensionalMatrix.getVal((IValue)((Object)aCoordinate2))));
                Collection collection = null;
                try {
                    collection = aFullNDimensionalMatrix.getCoordinates(aCoordinate2.values().stream().collect(Collectors.toSet())).stream().flatMap(aCoordinate -> aCoordinate.values().stream()).collect(Collectors.toSet());
                }
                catch (NullPointerException nullPointerException) {
                    this.gspu.sysoStempMessage(aFullNDimensionalMatrix.getAspects().stream().map(IValue::getStringValue).collect(Collectors.joining("; ")));
                    throw nullPointerException;
                }
                this.gspu.sysoStempMessage("Population coordinate :" + collection.stream().map(IValue::getStringValue).collect(Collectors.joining("; ")));
                this.gspu.sysoStempMessage("\tValue = " + String.valueOf(aFullNDimensionalMatrix.getVal(collection.stream().collect(Collectors.toSet()))));
            }
        }
        return iNDimensionalMatrix.getMatrix().entrySet().stream().mapToInt(entry -> Math.abs((Integer)aFullNDimensionalMatrix.getVal(((ACoordinate)entry.getKey()).values().stream().filter(iValue -> aFullNDimensionalMatrix.getAspects().contains(iValue)).collect(Collectors.toSet()), true).getValue() - ((Number)((AControl)entry.getValue()).getValue()).intValue())).sum();
    }

    public int getIntegerTAE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IQueryablePopulation<ADemoEntity, Attribute<? extends IValue>> iQueryablePopulation) {
        return iNDimensionalMatrix.getMatrix().entrySet().stream().mapToInt(entry -> Math.abs(iQueryablePopulation.getCountHavingValues(((ACoordinate)entry.getKey()).values().stream().collect(Collectors.groupingBy(iNDimensionalMatrix::getDimension, Collectors.toCollection(ArrayList::new)))) - ((Number)((AControl)entry.getValue()).getValue()).intValue())).sum();
    }

    public double getDoubleTAE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix) {
        return iNDimensionalMatrix.getMatrix().entrySet().stream().mapToDouble(entry -> Math.abs((Double)aFullNDimensionalMatrix.getVal(((ACoordinate)entry.getKey()).values(), true).getValue() - ((Number)((AControl)entry.getValue()).getValue()).doubleValue())).sum();
    }

    public double getDoubleTAE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IQueryablePopulation<ADemoEntity, Attribute<? extends IValue>> iQueryablePopulation) {
        return iNDimensionalMatrix.getMatrix().entrySet().stream().mapToDouble(entry -> Math.abs((double)iQueryablePopulation.getCountHavingValues(((ACoordinate)entry.getKey()).values().stream().collect(Collectors.groupingBy(iNDimensionalMatrix::getDimension, Collectors.toCollection(ArrayList::new)))) / (1.0 * (double)iQueryablePopulation.size()) - ((Number)((AControl)entry.getValue()).getValue()).doubleValue())).sum();
    }

    public double getAAPD(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        return (double)this.getTAE(iNDimensionalMatrix, iPopulation) / (double)iNDimensionalMatrix.size();
    }

    public double getAAPD(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IQueryablePopulation<ADemoEntity, Attribute<? extends IValue>> iQueryablePopulation) {
        return (double)this.getTAE(iNDimensionalMatrix, iQueryablePopulation) / (double)iNDimensionalMatrix.size();
    }

    public double getIntegerAAPD(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix) {
        return (double)this.getIntegerTAE(iNDimensionalMatrix, aFullNDimensionalMatrix) / (double)iNDimensionalMatrix.size();
    }

    public double getDoubleAAPD(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix) {
        return this.getDoubleTAE(iNDimensionalMatrix, aFullNDimensionalMatrix) / (double)iNDimensionalMatrix.size();
    }

    public double getSRMSE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        return switch (iNDimensionalMatrix.getMetaDataType()) {
            case GSSurveyType.ContingencyTable -> this.getIntegerSRMSE(iNDimensionalMatrix, GosplNDimensionalMatrixFactory.getFactory().createContingency(iPopulation));
            case GSSurveyType.GlobalFrequencyTable -> this.getDoubleSRMSE(iNDimensionalMatrix, GosplNDimensionalMatrixFactory.getFactory().createDistribution(iPopulation));
            case GSSurveyType.LocalFrequencyTable -> throw new IllegalArgumentException("Input contingency argument cannot be of type " + String.valueOf((Object)iNDimensionalMatrix.getMetaDataType()));
            default -> throw new IllegalArgumentException("Input contingency argument cannot be a segmented matrix with multiple matrix meta data type");
        };
    }

    public double getSRMSE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IQueryablePopulation<ADemoEntity, Attribute<? extends IValue>> iQueryablePopulation) {
        return switch (iNDimensionalMatrix.getMetaDataType()) {
            case GSSurveyType.ContingencyTable -> this.getIntegerSRMSE(iNDimensionalMatrix, iQueryablePopulation);
            case GSSurveyType.GlobalFrequencyTable -> this.getDoubleSRMSE(iNDimensionalMatrix, iQueryablePopulation);
            case GSSurveyType.LocalFrequencyTable -> throw new IllegalArgumentException("Input contingency argument cannot be of type " + String.valueOf((Object)iNDimensionalMatrix.getMetaDataType()));
            default -> throw new IllegalArgumentException("Input contingency argument cannot be a segmented matrix with multiple matrix meta data type");
        };
    }

    public double getIntegerSRMSE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix) {
        int n = iNDimensionalMatrix.size();
        double d = 0.0;
        int n2 = iNDimensionalMatrix.getMatrix().values().stream().mapToInt(aControl -> ((Number)aControl.getValue()).intValue()).min().getAsInt();
        int n3 = iNDimensionalMatrix.getMatrix().values().stream().mapToInt(aControl -> ((Number)aControl.getValue()).intValue()).max().getAsInt();
        for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : iNDimensionalMatrix.getMatrix().keySet()) {
            double d2 = iNDimensionalMatrix.getVal((IValue)((Object)aCoordinate)).getValue().doubleValue();
            double d3 = aFullNDimensionalMatrix.getVal(aCoordinate.values(), true).getValue().intValue();
            d += Math.pow(d2 - d3, 2.0) / (double)n;
        }
        return Math.sqrt(d) / (double)(n3 - n2);
    }

    public double getIntegerSRMSE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IQueryablePopulation<ADemoEntity, Attribute<? extends IValue>> iQueryablePopulation) {
        int n = iNDimensionalMatrix.size();
        double d = 0.0;
        int n2 = iNDimensionalMatrix.getMatrix().values().stream().mapToInt(aControl -> ((Number)aControl.getValue()).intValue()).min().getAsInt();
        int n3 = iNDimensionalMatrix.getMatrix().values().stream().mapToInt(aControl -> ((Number)aControl.getValue()).intValue()).max().getAsInt();
        for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : iNDimensionalMatrix.getMatrix().keySet()) {
            double d2 = iNDimensionalMatrix.getVal((IValue)((Object)aCoordinate)).getValue().doubleValue();
            double d3 = iQueryablePopulation.getCountHavingCoordinate(aCoordinate.getMap());
            d += Math.pow(d2 - d3, 2.0) / (double)n;
        }
        return Math.sqrt(d) / (double)(n3 - n2);
    }

    public double getDoubleSRMSE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix) {
        int n = iNDimensionalMatrix.size();
        double d = 0.0;
        double d2 = iNDimensionalMatrix.getMatrix().values().stream().mapToInt(aControl -> ((Number)aControl.getValue()).intValue()).min().getAsInt();
        double d3 = iNDimensionalMatrix.getMatrix().values().stream().mapToInt(aControl -> ((Number)aControl.getValue()).intValue()).max().getAsInt();
        for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : iNDimensionalMatrix.getMatrix().keySet()) {
            double d4 = iNDimensionalMatrix.getVal((IValue)((Object)aCoordinate)).getValue().doubleValue();
            double d5 = aFullNDimensionalMatrix.getVal(aCoordinate.values(), true).getValue();
            d += Math.pow(d4 - d5, 2.0) / (double)n;
        }
        return Math.sqrt(d) / (d3 - d2);
    }

    public double getDoubleSRMSE(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IQueryablePopulation<ADemoEntity, Attribute<? extends IValue>> iQueryablePopulation) {
        int n = iNDimensionalMatrix.size();
        double d = 0.0;
        double d2 = iNDimensionalMatrix.getMatrix().values().stream().mapToInt(aControl -> ((Number)aControl.getValue()).intValue()).min().getAsInt();
        double d3 = iNDimensionalMatrix.getMatrix().values().stream().mapToInt(aControl -> ((Number)aControl.getValue()).intValue()).max().getAsInt();
        for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : iNDimensionalMatrix.getMatrix().keySet()) {
            double d4 = iNDimensionalMatrix.getVal((IValue)((Object)aCoordinate)).getValue().doubleValue() * (double)iQueryablePopulation.size();
            double d5 = iQueryablePopulation.getCountHavingCoordinate(aCoordinate.getMap());
            d += Math.pow(d4 - d5, 2.0) / (double)n;
        }
        return Math.sqrt(d) / (d3 - d2);
    }

    public double getRSSZstar(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        return switch (iNDimensionalMatrix.getMetaDataType()) {
            case GSSurveyType.ContingencyTable -> this.getIntegerRSSZstar(iNDimensionalMatrix, GosplNDimensionalMatrixFactory.getFactory().createContingency(iPopulation));
            case GSSurveyType.GlobalFrequencyTable -> this.getDoubleRSSZstar(iNDimensionalMatrix, GosplNDimensionalMatrixFactory.getFactory().createDistribution(iPopulation));
            case GSSurveyType.LocalFrequencyTable -> throw new IllegalArgumentException("Input contingency argument cannot be of type " + String.valueOf((Object)iNDimensionalMatrix.getMetaDataType()));
            default -> throw new IllegalArgumentException("Input contingency argument cannot be a segmented matrix with multiple matrix meta data type");
        };
    }

    public double getRSSZstar(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, IQueryablePopulation<ADemoEntity, Attribute<? extends IValue>> iQueryablePopulation) {
        double d = 0.0;
        double d2 = new ChiSquaredDistribution((double)iNDimensionalMatrix.getDegree()).inverseCumulativeProbability(this.criticalPValue);
        switch (iNDimensionalMatrix.getMetaDataType()) {
            case ContingencyTable: {
                for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : iNDimensionalMatrix.getMatrix().keySet()) {
                    double d3 = iNDimensionalMatrix.getVal((IValue)((Object)aCoordinate)).getValue().doubleValue();
                    double d4 = iQueryablePopulation.getCountHavingCoordinate(aCoordinate.getMap());
                    d += Math.pow(d4 - d3, 2.0) / (d3 * (1.0 - d3 / (double)iQueryablePopulation.size()));
                }
                return d / d2;
            }
            case GlobalFrequencyTable: {
                for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : iNDimensionalMatrix.getMatrix().keySet()) {
                    double d5 = iNDimensionalMatrix.getVal((IValue)((Object)aCoordinate)).getValue().doubleValue() * (double)iQueryablePopulation.size();
                    double d6 = iQueryablePopulation.getCountHavingCoordinate(aCoordinate.getMap());
                    d += Math.pow(d6 - d5, 2.0) / (d5 * (1.0 - d5 / (double)iQueryablePopulation.size()));
                }
                return d / d2;
            }
            case LocalFrequencyTable: {
                throw new IllegalArgumentException("Input contingency argument cannot be of type " + String.valueOf((Object)iNDimensionalMatrix.getMetaDataType()));
            }
        }
        throw new IllegalArgumentException("Input contingency argument cannot be a segmented matrix with multiple matrix meta data type");
    }

    public double getIntegerRSSZstar(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, AFullNDimensionalMatrix<Integer> aFullNDimensionalMatrix) {
        double d = 0.0;
        double d2 = new ChiSquaredDistribution((double)iNDimensionalMatrix.getDegree()).inverseCumulativeProbability(this.criticalPValue);
        int n = aFullNDimensionalMatrix.getVal().getValue();
        for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : iNDimensionalMatrix.getMatrix().keySet()) {
            double d3 = iNDimensionalMatrix.getVal((IValue)((Object)aCoordinate)).getValue().doubleValue();
            double d4 = aFullNDimensionalMatrix.getVal(aCoordinate.values(), true).getValue().intValue();
            d += Math.pow(d4 - d3, 2.0) / (d3 * (1.0 - d3 / (double)n));
        }
        return d / d2;
    }

    public double getDoubleRSSZstar(INDimensionalMatrix<Attribute<? extends IValue>, IValue, ? extends Number> iNDimensionalMatrix, AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix) {
        double d = 0.0;
        double d2 = new ChiSquaredDistribution((double)iNDimensionalMatrix.getDegree()).inverseCumulativeProbability(this.criticalPValue);
        for (ACoordinate<Attribute<? extends IValue>, IValue> aCoordinate : iNDimensionalMatrix.getMatrix().keySet()) {
            double d3 = iNDimensionalMatrix.getVal((IValue)((Object)aCoordinate)).getValue().doubleValue();
            double d4 = aFullNDimensionalMatrix.getVal(aCoordinate.values(), true).getValue();
            d += Math.pow(d4 - d3, 2.0) / (d3 * (1.0 - d3));
        }
        return d / d2;
    }

    public Map<GosplIndicator, Number> getReport(Collection<GosplIndicator> collection, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Double> iNDimensionalMatrix, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        return collection.stream().collect(Collectors.toMap(Function.identity(), gosplIndicator -> this.getStats((GosplIndicator)((Object)gosplIndicator), iNDimensionalMatrix, iPopulation)));
    }

    public void saveReport(File file, Map<GosplIndicator, Number> map, String string, int n) throws IOException {
        DecimalFormat decimalFormat = new DecimalFormat("#.####");
        String string2 = ";";
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
            bufferedWriter.write("Algo" + string2 + "Pop size");
            for (GosplIndicator object : map.keySet()) {
                bufferedWriter.write(string2 + object.toString());
            }
            bufferedWriter.newLine();
            bufferedWriter.write(string + string2 + n);
            for (Map.Entry entry : map.entrySet()) {
                bufferedWriter.write(string2 + decimalFormat.format(((Number)entry.getValue()).doubleValue()));
            }
            bufferedWriter.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public double getIndicator(GosplIndicator gosplIndicator, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Double> iNDimensionalMatrix, AFullNDimensionalMatrix<Double> aFullNDimensionalMatrix) {
        return switch (gosplIndicator) {
            case GosplIndicator.TAE -> this.getDoubleTAE(iNDimensionalMatrix, aFullNDimensionalMatrix);
            case GosplIndicator.TACE -> this.getDoubleTACE(iNDimensionalMatrix, aFullNDimensionalMatrix, (double)EPSILON);
            case GosplIndicator.AAPD -> this.getDoubleAAPD(iNDimensionalMatrix, aFullNDimensionalMatrix);
            case GosplIndicator.SRMSE -> this.getDoubleSRMSE(iNDimensionalMatrix, aFullNDimensionalMatrix);
            case GosplIndicator.RSSZstar -> this.getDoubleRSSZstar(iNDimensionalMatrix, aFullNDimensionalMatrix);
            default -> throw new IllegalArgumentException(String.valueOf((Object)gosplIndicator) + " is an unknown indicator");
        };
    }

    private Number getStats(GosplIndicator gosplIndicator, INDimensionalMatrix<Attribute<? extends IValue>, IValue, Double> iNDimensionalMatrix, IPopulation<ADemoEntity, Attribute<? extends IValue>> iPopulation) {
        return switch (gosplIndicator) {
            case GosplIndicator.TAE -> this.getTAE(iNDimensionalMatrix, iPopulation);
            case GosplIndicator.TACE -> this.getTACE(iNDimensionalMatrix, iPopulation);
            case GosplIndicator.AAPD -> this.getAAPD(iNDimensionalMatrix, iPopulation);
            case GosplIndicator.SRMSE -> this.getSRMSE(iNDimensionalMatrix, iPopulation);
            case GosplIndicator.RSSZstar -> this.getRSSZstar(iNDimensionalMatrix, iPopulation);
            default -> this.getTAE(iNDimensionalMatrix, iPopulation);
        };
    }
}

