/*
 * Decompiled with CFR 0.152.
 */
package spll.localizer.distribution;

import core.util.random.roulette.ARouletteWheelSelection;
import core.util.random.roulette.RouletteWheelSelectionFactory;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.IList;
import java.util.HashMap;
import java.util.Map;
import spll.localizer.distribution.ISpatialDistribution;
import spll.localizer.distribution.function.ISpatialComplexFunction;

public class ComplexSpatialDistribution<N extends Number>
implements ISpatialDistribution<IShape> {
    private ISpatialComplexFunction<N> function;
    private IList<? extends IShape> candidates;
    private Map<IShape, ARouletteWheelSelection<N, ? extends IShape>> roulettes;

    public ComplexSpatialDistribution(ISpatialComplexFunction<N> iSpatialComplexFunction) {
        this.function = iSpatialComplexFunction;
    }

    @Override
    public IShape getCandidate(IScope iScope, IAgent iAgent, IList<? extends IShape> iList) {
        return (IShape)RouletteWheelSelectionFactory.getRouletteWheel(iList.stream().map(iShape -> (Number)this.function.apply(iAgent, iShape)).toList(), iList).drawObject();
    }

    @Override
    public IShape getCandidate(IScope iScope, IAgent iAgent) {
        if (this.candidates == null || this.candidates.isEmpty()) {
            throw new NullPointerException("No candidates have been setup, must use ISpatialDistribution.setCandidates(List) first");
        }
        if (this.roulettes == null) {
            this.roulettes = new HashMap<IShape, ARouletteWheelSelection<N, ? extends IShape>>();
        }
        if (this.roulettes.isEmpty() || !this.roulettes.containsKey(iAgent)) {
            this.roulettes.put((IShape)iAgent, RouletteWheelSelectionFactory.getRouletteWheel(this.candidates.stream().map(iShape -> (Number)this.function.apply(iAgent, iShape)).toList(), this.candidates));
        }
        return (IShape)this.roulettes.get(iAgent).drawObject();
    }

    @Override
    public void setCandidate(IList<? extends IShape> iList) {
        this.candidates = iList;
    }

    @Override
    public IList<IShape> getCandidates(IScope iScope) {
        return this.candidates.copy(iScope);
    }

    @Override
    public void removeNest(IShape iShape) {
        for (ARouletteWheelSelection<N, IShape> aRouletteWheelSelection : this.roulettes.values()) {
            aRouletteWheelSelection.remove((IShape)iShape);
        }
    }
}

