/*
 * Decompiled with CFR 0.152.
 */
package spll.util;

import core.metamodel.attribute.Attribute;
import core.metamodel.attribute.AttributeFactory;
import core.metamodel.value.IValue;
import core.util.data.GSEnumDataType;
import core.util.exception.GSIllegalRangedData;
import java.util.Set;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SpllGeotoolsAdapter {
    private static SpllGeotoolsAdapter gaw = new SpllGeotoolsAdapter();

    private SpllGeotoolsAdapter() {
    }

    public static SpllGeotoolsAdapter getInstance() {
        return gaw;
    }

    public SimpleFeatureType getGeotoolsFeatureType(String string, Set<Attribute<? extends IValue>> set, CoordinateReferenceSystem coordinateReferenceSystem, GeometryDescriptor geometryDescriptor) {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.setName(string);
        simpleFeatureTypeBuilder.setCRS(coordinateReferenceSystem);
        simpleFeatureTypeBuilder.add("the_geom", geometryDescriptor.getType().getBinding());
        set.stream().forEach(attribute -> simpleFeatureTypeBuilder.add(attribute.getAttributeName(), IValue.class));
        return simpleFeatureTypeBuilder.buildFeatureType();
    }

    public Attribute<? extends IValue> getAttribute(Property property) throws GSIllegalRangedData {
        return AttributeFactory.getFactory().createAttribute(property.getName().getLocalPart(), GSEnumDataType.getTypeForJavaType(property.getType().getBinding()));
    }
}

