/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFileChannel;
import io.jhdf.api.Attribute;
import io.jhdf.api.Node;
import io.jhdf.dataset.DatasetReader;
import io.jhdf.dataset.VariableLengthDatasetReader;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.VariableLength;
import io.jhdf.object.message.AttributeMessage;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeImpl
implements Attribute {
    private static final Logger logger = LoggerFactory.getLogger(AttributeImpl.class);
    private final HdfFileChannel hdfFc;
    private final Node node;
    private final String name;
    private final AttributeMessage message;

    public AttributeImpl(HdfFileChannel hdfFileChannel, Node node, AttributeMessage attributeMessage) {
        this.hdfFc = hdfFileChannel;
        this.node = node;
        this.name = attributeMessage.getName();
        this.message = attributeMessage;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.message.getDataSpace().getTotalLength();
    }

    @Override
    public long getDiskSize() {
        return this.getSize() * (long)this.message.getDataType().getSize();
    }

    @Override
    public int[] getDimensions() {
        return this.message.getDataSpace().getDimensions();
    }

    @Override
    public Object getData() {
        logger.debug("Getting data for attribute '{}' of '{}'...", (Object)this.name, (Object)this.node.getPath());
        if (this.isEmpty()) {
            return null;
        }
        DataType dataType = this.message.getDataType();
        ByteBuffer byteBuffer = this.message.getDataBuffer();
        if (dataType instanceof VariableLength) {
            return VariableLengthDatasetReader.readDataset((VariableLength)dataType, byteBuffer, this.getDimensions(), this.hdfFc);
        }
        return DatasetReader.readDataset(dataType, byteBuffer, this.getDimensions());
    }

    @Override
    public boolean isEmpty() {
        return this.message.getDataBuffer() == null;
    }

    @Override
    public boolean isScalar() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getDimensions().length == 0;
    }

    @Override
    public Class<?> getJavaType() {
        Class<?> clazz = this.message.getDataType().getJavaType();
        if (this.isScalar() && clazz.isPrimitive()) {
            return ClassUtils.primitiveToWrapper(clazz);
        }
        return clazz;
    }
}

