/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFileChannel;
import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FractalHeap {
    private static final Logger logger = LoggerFactory.getLogger(FractalHeap.class);
    private static final byte[] FRACTAL_HEAP_SIGNATURE = "FRHP".getBytes();
    private static final byte[] INDIRECT_BLOCK_SIGNATURE = "FHIB".getBytes();
    private static final byte[] DIRECT_BLOCK_SIGNATURE = "FHDB".getBytes();
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final long address;
    private final HdfFileChannel hdfFc;
    private final Superblock sb;
    private final int maxDirectBlockSize;
    private final long maxSizeOfManagedObjects;
    private final int idLength;
    private final int ioFiltersLength;
    private final int currentRowsInRootIndirectBlock;
    private final int startingRowsInRootIndirectBlock;
    private final int startingBlockSize;
    private final int tableWidth;
    private final long numberOfTinyObjectsInHeap;
    private final long sizeOfTinyObjectsInHeap;
    private final long numberOfHugeObjectsInHeap;
    private final long sizeOfHugeObjectsInHeap;
    private final long numberOfManagedObjectsInHeap;
    private final long offsetOfDirectBlockAllocationIteratorInManagedSpace;
    private final long amountOfAllocatedManagedSpaceInHeap;
    private final long amountOfManagedSpaceInHeap;
    private final long addressOfManagedBlocksFreeSpaceManager;
    private final long freeSpaceInManagedBlocks;
    private final long bTreeAddressOfHugeObjects;
    private final long nextHugeObjectId;
    private final BitSet flags;
    private int blockIndex = 0;
    private final NavigableMap<Long, DirectBlock> directBlocks = new TreeMap<Long, DirectBlock>();
    private final int bytesToStoreOffset;
    private final int bytesToStoreLength;

    public FractalHeap(HdfFileChannel hdfFileChannel, long l) {
        this.hdfFc = hdfFileChannel;
        this.sb = hdfFileChannel.getSuperblock();
        this.address = l;
        try {
            int n = 14 + 12 * this.sb.getSizeOfLengths() + 3 * this.sb.getSizeOfOffsets() + 2 + 2 + 2 + 2;
            ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, n);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray, 0, byArray.length);
            if (!Arrays.equals(FRACTAL_HEAP_SIGNATURE, byArray)) {
                throw new HdfException("Fractal heap signature 'FRHP' not matched, at address " + l);
            }
            byte by = byteBuffer.get();
            if (by != 0) {
                throw new HdfException("Unsupported fractal heap version detected. Version: " + by);
            }
            this.idLength = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            this.ioFiltersLength = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            this.flags = BitSet.valueOf(new byte[]{byteBuffer.get()});
            this.maxSizeOfManagedObjects = Utils.readBytesAsUnsignedLong(byteBuffer, 4);
            this.nextHugeObjectId = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfLengths());
            this.bTreeAddressOfHugeObjects = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfOffsets());
            this.freeSpaceInManagedBlocks = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfLengths());
            this.addressOfManagedBlocksFreeSpaceManager = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfOffsets());
            this.amountOfManagedSpaceInHeap = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfLengths());
            this.amountOfAllocatedManagedSpaceInHeap = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfLengths());
            this.offsetOfDirectBlockAllocationIteratorInManagedSpace = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfLengths());
            this.numberOfManagedObjectsInHeap = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfLengths());
            this.sizeOfHugeObjectsInHeap = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfLengths());
            this.numberOfHugeObjectsInHeap = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfLengths());
            this.sizeOfTinyObjectsInHeap = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfLengths());
            this.numberOfTinyObjectsInHeap = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfLengths());
            this.tableWidth = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            this.startingBlockSize = Utils.readBytesAsUnsignedInt(byteBuffer, this.sb.getSizeOfLengths());
            this.maxDirectBlockSize = Utils.readBytesAsUnsignedInt(byteBuffer, this.sb.getSizeOfLengths());
            int n2 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            this.bytesToStoreOffset = (int)Math.ceil((double)n2 / 8.0);
            this.bytesToStoreLength = Utils.bytesNeededToHoldNumber(Math.min((long)this.maxDirectBlockSize, this.maxSizeOfManagedObjects));
            this.startingRowsInRootIndirectBlock = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            long l2 = Utils.readBytesAsUnsignedLong(byteBuffer, this.sb.getSizeOfOffsets());
            this.currentRowsInRootIndirectBlock = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            if (this.ioFiltersLength > 0) {
                throw new UnsupportedHdfException("IO filters are currently not supported");
            }
            if (l2 != -1L) {
                if (this.currentRowsInRootIndirectBlock == 0) {
                    DirectBlock directBlock = new DirectBlock(l2);
                    this.directBlocks.put(directBlock.blockOffset, directBlock);
                } else {
                    IndirectBlock indirectBlock = new IndirectBlock(l2);
                    for (long l3 : indirectBlock.childBlockAddresses) {
                        int n3;
                        if ((n3 = this.getSizeOfDirectBlock(this.blockIndex++)) != -1) {
                            DirectBlock directBlock = new DirectBlock(l3);
                            this.directBlocks.put(directBlock.getBlockOffset(), directBlock);
                            continue;
                        }
                        new IndirectBlock(l);
                    }
                }
            }
            logger.debug("Read fractal heap at address {}, loaded {} direct blocks", (Object)l, (Object)this.directBlocks.size());
        }
        catch (Exception exception) {
            throw new HdfException("Error reading fractal heap at address " + l, exception);
        }
    }

    public ByteBuffer getId(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() != this.idLength) {
            throw new HdfException("ID length is incorrect accessing fractal heap at address " + this.address + ". IDs should be " + this.idLength + " bytes but was " + byteBuffer.capacity() + " bytes.");
        }
        BitSet bitSet = BitSet.valueOf(new byte[]{byteBuffer.get()});
        int n = Utils.bitsToInt(bitSet, 6, 2);
        if (n != 0) {
            throw new HdfException("Unsupported btree v2 ID version detected. Version: " + n);
        }
        int n2 = Utils.bitsToInt(bitSet, 4, 2);
        switch (n2) {
            case 0: {
                long l = Utils.readBytesAsUnsignedLong(byteBuffer, this.bytesToStoreOffset);
                int n3 = Utils.readBytesAsUnsignedInt(byteBuffer, this.bytesToStoreLength);
                logger.debug("Getting ID at offset={} length={}", (Object)l, (Object)n3);
                Map.Entry<Long, DirectBlock> entry = this.directBlocks.floorEntry(l);
                ByteBuffer byteBuffer2 = entry.getValue().getData();
                byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer2.position(Math.toIntExact(l - entry.getKey()));
                return Utils.createSubBuffer(byteBuffer2, n3);
            }
            case 1: {
                throw new UnsupportedHdfException("Huge objects are currently not supported");
            }
            case 2: {
                throw new UnsupportedHdfException("Tiny objects are currently not supported");
            }
        }
        throw new HdfException("Unrecognized ID type, type=" + n2);
    }

    private int getSizeOfDirectBlock(int n) {
        int n2 = n / this.tableWidth;
        if (n2 < 2) {
            return this.startingBlockSize;
        }
        int n3 = this.startingBlockSize * TWO.pow(n2 - 1).intValueExact();
        if (n3 < this.maxDirectBlockSize) {
            return n3;
        }
        return -1;
    }

    public String toString() {
        return "FractalHeap [address=" + this.address + ", idLength=" + this.idLength + ", numberOfTinyObjectsInHeap=" + this.numberOfTinyObjectsInHeap + ", numberOfHugeObjectsInHeap=" + this.numberOfHugeObjectsInHeap + ", numberOfManagedObjectsInHeap=" + this.numberOfManagedObjectsInHeap + "]";
    }

    public long getAddress() {
        return this.address;
    }

    public int getMaxDirectBlockSize() {
        return this.maxDirectBlockSize;
    }

    public long getMaxSizeOfManagedObjects() {
        return this.maxSizeOfManagedObjects;
    }

    public int getIdLength() {
        return this.idLength;
    }

    public int getIoFiltersLength() {
        return this.ioFiltersLength;
    }

    public int getStartingRowsInRootIndirectBlock() {
        return this.startingRowsInRootIndirectBlock;
    }

    public long getNumberOfTinyObjectsInHeap() {
        return this.numberOfTinyObjectsInHeap;
    }

    public long getSizeOfTinyObjectsInHeap() {
        return this.sizeOfTinyObjectsInHeap;
    }

    public long getNumberOfHugeObjectsInHeap() {
        return this.numberOfHugeObjectsInHeap;
    }

    public long getSizeOfHugeObjectsInHeap() {
        return this.sizeOfHugeObjectsInHeap;
    }

    public long getNumberOfManagedObjectsInHeap() {
        return this.numberOfManagedObjectsInHeap;
    }

    public long getOffsetOfDirectBlockAllocationIteratorInManagedSpace() {
        return this.offsetOfDirectBlockAllocationIteratorInManagedSpace;
    }

    public long getAmountOfAllocatedManagedSpaceInHeap() {
        return this.amountOfAllocatedManagedSpaceInHeap;
    }

    public long getAmountOfManagedSpaceInHeap() {
        return this.amountOfManagedSpaceInHeap;
    }

    public long getAddressOfManagedBlocksFreeSpaceManager() {
        return this.addressOfManagedBlocksFreeSpaceManager;
    }

    public long getFreeSpaceInManagedBlocks() {
        return this.freeSpaceInManagedBlocks;
    }

    public long getBTreeAddressOfHugeObjects() {
        return this.bTreeAddressOfHugeObjects;
    }

    public long getNextHugeObjectId() {
        return this.nextHugeObjectId;
    }

    private class DirectBlock {
        private static final int CHECKSUM_PRESENT_BIT = 1;
        private final long address;
        private final ByteBuffer data;
        private final long blockOffset;

        private DirectBlock(long l) {
            this.address = l;
            int n = 5 + FractalHeap.this.sb.getSizeOfOffsets() + FractalHeap.this.bytesToStoreOffset + 4;
            ByteBuffer byteBuffer = FractalHeap.this.hdfFc.readBufferFromAddress(l, n);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray, 0, byArray.length);
            if (!Arrays.equals(DIRECT_BLOCK_SIGNATURE, byArray)) {
                throw new HdfException("Fractal heap direct block signature 'FHDB' not matched, at address " + l);
            }
            byte by = byteBuffer.get();
            if (by != 0) {
                throw new HdfException("Unsupported direct block version detected. Version: " + by);
            }
            long l2 = Utils.readBytesAsUnsignedLong(byteBuffer, FractalHeap.this.sb.getSizeOfOffsets());
            if (l2 != FractalHeap.this.address) {
                throw new HdfException("Indirect block read from invalid fractal heap");
            }
            this.blockOffset = Utils.readBytesAsUnsignedLong(byteBuffer, FractalHeap.this.bytesToStoreOffset);
            if (this.checksumPresent()) {
                byteBuffer.position(byteBuffer.position() + 4);
            }
            this.data = FractalHeap.this.hdfFc.map(l, FractalHeap.this.getSizeOfDirectBlock(FractalHeap.this.blockIndex));
        }

        private boolean checksumPresent() {
            return FractalHeap.this.flags.get(1);
        }

        public ByteBuffer getData() {
            return this.data.order(ByteOrder.LITTLE_ENDIAN);
        }

        public long getBlockOffset() {
            return this.blockOffset;
        }

        public String toString() {
            return "DirectBlock [address=" + this.address + ", blockOffset=" + this.blockOffset + ", data=" + String.valueOf(this.data) + "]";
        }
    }

    private class IndirectBlock {
        private final List<Long> childBlockAddresses;

        private IndirectBlock(long l) {
            int n = 5 + FractalHeap.this.sb.getSizeOfOffsets() + FractalHeap.this.bytesToStoreOffset + FractalHeap.this.currentRowsInRootIndirectBlock * FractalHeap.this.tableWidth * this.getRowSize() + 4;
            ByteBuffer byteBuffer = FractalHeap.this.hdfFc.readBufferFromAddress(l, n);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray, 0, byArray.length);
            if (!Arrays.equals(INDIRECT_BLOCK_SIGNATURE, byArray)) {
                throw new HdfException("Fractal heap indirect block signature 'FHIB' not matched, at address " + l);
            }
            byte by = byteBuffer.get();
            if (by != 0) {
                throw new HdfException("Unsupported indirect block version detected. Version: " + by);
            }
            long l2 = Utils.readBytesAsUnsignedLong(byteBuffer, FractalHeap.this.sb.getSizeOfOffsets());
            if (l2 != FractalHeap.this.address) {
                throw new HdfException("Indirect block read from invalid fractal heap");
            }
            Utils.readBytesAsUnsignedLong(byteBuffer, FractalHeap.this.bytesToStoreOffset);
            this.childBlockAddresses = new ArrayList<Long>(FractalHeap.this.currentRowsInRootIndirectBlock * FractalHeap.this.tableWidth);
            int n2 = 0;
            while (n2 < FractalHeap.this.currentRowsInRootIndirectBlock * FractalHeap.this.tableWidth) {
                long l3 = Utils.readBytesAsUnsignedLong(byteBuffer, this.getRowSize());
                if (l3 == -1L) break;
                this.childBlockAddresses.add(l3);
                ++n2;
            }
        }

        private boolean isIoFilters() {
            return FractalHeap.this.ioFiltersLength > 0;
        }

        private int getRowSize() {
            int n = FractalHeap.this.sb.getSizeOfOffsets();
            if (this.isIoFilters()) {
                n += FractalHeap.this.sb.getSizeOfLengths();
                n += 4;
            }
            return n;
        }
    }
}

