/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.AbstractNode;
import io.jhdf.FractalHeap;
import io.jhdf.GroupSymbolTableNode;
import io.jhdf.HdfFile;
import io.jhdf.HdfFileChannel;
import io.jhdf.LocalHeap;
import io.jhdf.ObjectHeader;
import io.jhdf.SymbolTableEntry;
import io.jhdf.Utils;
import io.jhdf.api.Dataset;
import io.jhdf.api.Group;
import io.jhdf.api.Node;
import io.jhdf.api.NodeType;
import io.jhdf.btree.BTreeV1;
import io.jhdf.btree.BTreeV1Group;
import io.jhdf.btree.BTreeV2;
import io.jhdf.btree.record.LinkNameForIndexedGroupRecord;
import io.jhdf.dataset.DatasetLoader;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.HdfInvalidPathException;
import io.jhdf.links.ExternalLink;
import io.jhdf.links.SoftLink;
import io.jhdf.object.message.DataLayoutMessage;
import io.jhdf.object.message.DataSpaceMessage;
import io.jhdf.object.message.LinkInfoMessage;
import io.jhdf.object.message.LinkMessage;
import io.jhdf.object.message.SymbolTableMessage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupImpl
extends AbstractNode
implements Group {
    private static final Logger logger = LoggerFactory.getLogger(GroupImpl.class);
    private final LazyInitializer<Map<String, Node>> children;

    private GroupImpl(HdfFileChannel hdfFileChannel, long l, String string, Group group) {
        super(hdfFileChannel, l, string, group);
        logger.trace("Creating group '{}'...", (Object)string);
        this.children = new ChildrenLazyInitializer(hdfFileChannel, this);
        logger.debug("Created group '{}'", (Object)this.getPath());
    }

    private GroupImpl(HdfFileChannel hdfFileChannel, long l, HdfFile hdfFile) {
        super(hdfFileChannel, l, "", hdfFile);
        logger.trace("Creating root group...");
        this.children = new ChildrenLazyInitializer(hdfFileChannel, hdfFile);
        logger.debug("Created root group of file '{}'", (Object)hdfFile.getName());
    }

    static Group createGroup(HdfFileChannel hdfFileChannel, long l, String string, Group group) {
        return new GroupImpl(hdfFileChannel, l, string, group);
    }

    static Group createRootGroup(HdfFileChannel hdfFileChannel, long l, HdfFile hdfFile) {
        return new GroupImpl(hdfFileChannel, l, hdfFile);
    }

    @Override
    public Map<String, Node> getChildren() {
        try {
            return (Map)this.children.get();
        }
        catch (Exception exception) {
            throw new HdfException("Failed to load children for group '" + this.getPath() + "' at address '" + this.getAddress() + "'", exception);
        }
    }

    public String toString() {
        return "Group [name=" + this.name + ", path=" + this.getPath() + ", address=" + Utils.toHex(this.getAddress()) + "]";
    }

    @Override
    public String getPath() {
        return super.getPath() + "/";
    }

    @Override
    public NodeType getType() {
        return NodeType.GROUP;
    }

    @Override
    public Iterator<Node> iterator() {
        return this.getChildren().values().iterator();
    }

    @Override
    public Node getChild(String string) {
        try {
            return (Node)((Map)this.children.get()).get(string);
        }
        catch (Exception exception) {
            throw new HdfException("Failed to load children of group '" + this.getPath() + "' at address '" + this.getAddress() + "'", exception);
        }
    }

    @Override
    public Node getByPath(String string) {
        String[] stringArray = string.split("/", 2);
        Node node = this.getChild(stringArray[0]);
        if (stringArray.length == 1 && node != null) {
            return node;
        }
        if (node instanceof Group) {
            return ((Group)node).getByPath(stringArray[1]);
        }
        throw new HdfInvalidPathException(this.getPath() + string, this.getFile());
    }

    @Override
    public Dataset getDatasetByPath(String string) {
        Node node = this.getByPath(string);
        if (node instanceof Dataset) {
            return (Dataset)node;
        }
        throw new HdfInvalidPathException(this.getPath() + string, this.getFile());
    }

    @Override
    public boolean isLinkCreationOrderTracked() {
        ObjectHeader objectHeader = this.getHeader();
        if (objectHeader.hasMessageOfType(LinkInfoMessage.class)) {
            return objectHeader.getMessageOfType(LinkInfoMessage.class).isLinkCreationOrderTracked();
        }
        return false;
    }

    private final class ChildrenLazyInitializer
    extends LazyInitializer<Map<String, Node>> {
        private final HdfFileChannel hdfFc;
        private final Group parent;

        private ChildrenLazyInitializer(HdfFileChannel hdfFileChannel, Group group) {
            this.hdfFc = hdfFileChannel;
            this.parent = group;
        }

        protected Map<String, Node> initialize() throws ConcurrentException {
            logger.info("Lazy loading children of '{}'", (Object)GroupImpl.this.getPath());
            if (((ObjectHeader)GroupImpl.this.header.get()).hasMessageOfType(SymbolTableMessage.class)) {
                return this.createOldStyleGroup((ObjectHeader)GroupImpl.this.header.get());
            }
            return this.createNewStyleGroup((ObjectHeader)GroupImpl.this.header.get());
        }

        private Map<String, Node> createNewStyleGroup(ObjectHeader objectHeader) {
            Object object;
            Object object2;
            Object object3;
            List<LinkMessage> list;
            logger.debug("Loading 'new' style group");
            LinkInfoMessage linkInfoMessage = objectHeader.getMessageOfType(LinkInfoMessage.class);
            if (linkInfoMessage.getBTreeNameIndexAddress() == -1L) {
                list = objectHeader.getMessagesOfType(LinkMessage.class);
                logger.debug("Loaded group links from object header");
            } else {
                object3 = new BTreeV2(this.hdfFc, linkInfoMessage.getBTreeNameIndexAddress());
                FractalHeap object4 = new FractalHeap(this.hdfFc, linkInfoMessage.getFractalHeapAddress());
                List list2 = ((BTreeV2)object3).getRecords();
                list = new ArrayList<LinkMessage>(list2.size());
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    object2 = (LinkNameForIndexedGroupRecord)iterator.next();
                    ByteBuffer byteBuffer = ((LinkNameForIndexedGroupRecord)object2).getId();
                    object = object4.getId(byteBuffer);
                    list.add(LinkMessage.fromBuffer((ByteBuffer)object, this.hdfFc.getSuperblock()));
                }
                logger.debug("Loaded group links from fractal heap");
            }
            object3 = new LinkedHashMap(list.size());
            for (LinkMessage linkMessage : list) {
                object2 = linkMessage.getLinkName();
                switch (linkMessage.getLinkType()) {
                    case HARD: {
                        long l = linkMessage.getHardLinkAddress();
                        object = this.createNode((String)object2, l);
                        object3.put(object2, object);
                        break;
                    }
                    case SOFT: {
                        object3.put(object2, new SoftLink(linkMessage.getSoftLink(), (String)object2, this.parent));
                        break;
                    }
                    case EXTERNAL: {
                        object3.put(object2, new ExternalLink(linkMessage.getExternalFile(), linkMessage.getExternalPath(), (String)object2, this.parent));
                    }
                }
            }
            return object3;
        }

        private Map<String, Node> createOldStyleGroup(ObjectHeader objectHeader) {
            logger.debug("Loading 'old' style group");
            SymbolTableMessage symbolTableMessage = objectHeader.getMessageOfType(SymbolTableMessage.class);
            BTreeV1Group bTreeV1Group = BTreeV1.createGroupBTree(this.hdfFc, symbolTableMessage.getBTreeAddress());
            LocalHeap localHeap = new LocalHeap(this.hdfFc, symbolTableMessage.getLocalHeapAddress());
            ByteBuffer byteBuffer = localHeap.getDataBuffer();
            List<Long> list = bTreeV1Group.getChildAddresses();
            LinkedHashMap<String, Node> linkedHashMap = new LinkedHashMap<String, Node>(list.size());
            for (long l : list) {
                GroupSymbolTableNode groupSymbolTableNode = new GroupSymbolTableNode(this.hdfFc, l);
                SymbolTableEntry[] symbolTableEntryArray = groupSymbolTableNode.getSymbolTableEntries();
                int n = symbolTableEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SymbolTableEntry symbolTableEntry = symbolTableEntryArray[n2];
                    String string = this.readName(byteBuffer, symbolTableEntry.getLinkNameOffset());
                    linkedHashMap.put(string, switch (symbolTableEntry.getCacheType()) {
                        case 0 -> {
                            ObjectHeader var18_17;
                            try {
                                var18_17 = ObjectHeader.readObjectHeader(this.hdfFc, symbolTableEntry.getObjectHeaderAddress());
                            }
                            catch (HdfException var19_19) {
                                throw new HdfException("Failed to read '" + GroupImpl.this.getPath() + string + "'", var19_19);
                            }
                            if (var18_17.hasMessageOfType(DataLayoutMessage.class)) {
                                logger.trace("Creating dataset '{}'", (Object)string);
                                yield DatasetLoader.createDataset(this.hdfFc, var18_17, string, this.parent);
                            }
                            logger.trace("Creating group '{}'", (Object)string);
                            yield GroupImpl.createGroup(this.hdfFc, symbolTableEntry.getObjectHeaderAddress(), string, this.parent);
                        }
                        case 1 -> {
                            logger.trace("Creating group '{}'", (Object)string);
                            yield GroupImpl.createGroup(this.hdfFc, symbolTableEntry.getObjectHeaderAddress(), string, this.parent);
                        }
                        case 2 -> {
                            logger.trace("Creating soft link '{}'", (Object)string);
                            String var19_18 = this.readName(byteBuffer, symbolTableEntry.getLinkValueOffset());
                            yield new SoftLink(var19_18, string, this.parent);
                        }
                        default -> throw new HdfException("Unrecognized symbol table entry cache type. Type was: " + symbolTableEntry.getCacheType());
                    });
                    ++n2;
                }
            }
            return linkedHashMap;
        }

        private Node createNode(String string, long l) {
            ObjectHeader objectHeader = ObjectHeader.readObjectHeader(this.hdfFc, l);
            Node node = objectHeader.hasMessageOfType(DataSpaceMessage.class) ? DatasetLoader.createDataset(this.hdfFc, objectHeader, string, this.parent) : GroupImpl.createGroup(this.hdfFc, l, string, this.parent);
            return node;
        }

        private String readName(ByteBuffer byteBuffer, int n) {
            byteBuffer.position(n);
            return Utils.readUntilNull(byteBuffer);
        }
    }
}

