/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.Superblock;
import io.jhdf.exceptions.HdfException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;

public class HdfFileChannel {
    private final FileChannel fc;
    private final Superblock sb;

    public HdfFileChannel(FileChannel fileChannel, Superblock superblock) {
        this.fc = fileChannel;
        this.sb = superblock;
    }

    public ByteBuffer readBufferFromAddress(long l, int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        try {
            this.fc.read(byteBuffer, l + this.sb.getBaseAddressByte());
        }
        catch (IOException iOException) {
            throw new HdfException("Failed to read from file at address '" + l + "' (raw address '" + l + this.sb.getBaseAddressByte() + "'", iOException);
        }
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public ByteBuffer map(long l, long l2) {
        return this.mapNoOffset(l + this.sb.getBaseAddressByte(), l2);
    }

    public ByteBuffer mapNoOffset(long l, long l2) {
        try {
            return this.fc.map(FileChannel.MapMode.READ_ONLY, l, l2);
        }
        catch (IOException iOException) {
            throw new HdfException("Failed to map buffer at address '" + l + "' of length '" + l2 + "'", iOException);
        }
    }

    public long getUserBlockSize() {
        return this.sb.getBaseAddressByte();
    }

    public Superblock getSuperblock() {
        return this.sb;
    }

    public FileChannel getFileChannel() {
        return this.fc;
    }

    public int getSizeOfOffsets() {
        return this.sb.getSizeOfOffsets();
    }

    public int getSizeOfLengths() {
        return this.sb.getSizeOfLengths();
    }

    public final void close() {
        try {
            this.fc.close();
        }
        catch (IOException iOException) {
            throw new HdfException("Failed closing HDF5 file", iOException);
        }
    }

    public long size() {
        try {
            return this.fc.size();
        }
        catch (IOException iOException) {
            throw new HdfException("Failed to get size of HDF5 file", iOException);
        }
    }
}

