/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalHeap {
    private static final Logger logger = LoggerFactory.getLogger(LocalHeap.class);
    private static final byte[] HEAP_SIGNATURE = "HEAP".getBytes();
    private final long address;
    private final short version;
    private final long dataSegmentSize;
    private final long offsetToHeadOfFreeList;
    private final long addressOfDataSegment;
    private final ByteBuffer dataBuffer;

    public LocalHeap(HdfFileChannel hdfFileChannel, long l) {
        this.address = l;
        try {
            int n = 8 + hdfFileChannel.getSizeOfLengths() + hdfFileChannel.getSizeOfLengths() + hdfFileChannel.getSizeOfOffsets();
            ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, n);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray, 0, byArray.length);
            if (!Arrays.equals(HEAP_SIGNATURE, byArray)) {
                throw new HdfException("Heap signature not matched");
            }
            this.version = byteBuffer.get();
            byteBuffer.position(8);
            this.dataSegmentSize = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfLengths());
            logger.trace("dataSegmentSize = {}", (Object)this.dataSegmentSize);
            this.offsetToHeadOfFreeList = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfLengths());
            logger.trace("offsetToHeadOfFreeList = {}", (Object)this.offsetToHeadOfFreeList);
            this.addressOfDataSegment = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
            logger.trace("addressOfDataSegment = {}", (Object)this.addressOfDataSegment);
            this.dataBuffer = hdfFileChannel.map(this.addressOfDataSegment, this.dataSegmentSize);
        }
        catch (Exception exception) {
            throw new HdfException("Error reading local heap", exception);
        }
    }

    public short getVersion() {
        return this.version;
    }

    public long getDataSegmentSize() {
        return this.dataSegmentSize;
    }

    public long getOffsetToHeadOfFreeList() {
        return this.offsetToHeadOfFreeList;
    }

    public long getAddressOfDataSegment() {
        return this.addressOfDataSegment;
    }

    public String toString() {
        return "LocalHeap [address=" + Utils.toHex(this.address) + ", version=" + this.version + ", dataSegmentSize=" + this.dataSegmentSize + ", offsetToHeadOfFreeList=" + this.offsetToHeadOfFreeList + ", addressOfDataSegment=" + Utils.toHex(this.addressOfDataSegment) + "]";
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuffer;
    }
}

