/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolTableEntry {
    private static final Logger logger = LoggerFactory.getLogger(SymbolTableEntry.class);
    private final long address;
    private final int linkNameOffset;
    private final long objectHeaderAddress;
    private final int cacheType;
    private long bTreeAddress = -1L;
    private long nameHeapAddress = -1L;
    private int linkValueOffset = -1;

    public SymbolTableEntry(HdfFileChannel hdfFileChannel, long l) {
        this.address = l;
        int n = hdfFileChannel.getSizeOfOffsets() * 2 + 4 + 4 + 16;
        ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, n);
        this.linkNameOffset = Utils.readBytesAsUnsignedInt(byteBuffer, hdfFileChannel.getSizeOfOffsets());
        logger.trace("linkNameOffset = {}", (Object)this.linkNameOffset);
        this.objectHeaderAddress = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
        logger.trace("objectHeaderAddress = {}", (Object)this.objectHeaderAddress);
        this.cacheType = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
        logger.trace("cacheType = {}", (Object)this.cacheType);
        byteBuffer.get(new byte[4]);
        switch (this.cacheType) {
            case 0: {
                break;
            }
            case 1: {
                this.bTreeAddress = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
                logger.trace("addressOfBTree = {}", (Object)this.bTreeAddress);
                this.nameHeapAddress = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
                logger.trace("nameHeapAddress = {}", (Object)this.nameHeapAddress);
                break;
            }
            case 2: {
                this.linkValueOffset = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
                logger.trace("linkValueOffset = {}", (Object)this.linkValueOffset);
                break;
            }
            default: {
                throw new IllegalStateException("SymbolTableEntry: Unrecognized cache type = " + this.cacheType);
            }
        }
    }

    public long getAddress() {
        return this.address;
    }

    public long getBTreeAddress() {
        return this.bTreeAddress;
    }

    public int getCacheType() {
        return this.cacheType;
    }

    public int getLinkNameOffset() {
        return this.linkNameOffset;
    }

    public int getLinkValueOffset() {
        return this.linkValueOffset;
    }

    public long getNameHeapAddress() {
        return this.nameHeapAddress;
    }

    public long getObjectHeaderAddress() {
        return this.objectHeaderAddress;
    }

    public String toString() {
        return "SymbolTableEntry [address=" + Utils.toHex(this.address) + ", linkNameOffset=" + this.linkNameOffset + ", objectHeaderAddress=" + Utils.toHex(this.objectHeaderAddress) + ", cacheType=" + this.cacheType + ", bTreeAddress=" + Utils.toHex(this.bTreeAddress) + ", nameHeapAddress=" + Utils.toHex(this.nameHeapAddress) + ", linkValueOffset=" + this.linkValueOffset + "]";
    }
}

