/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;

public final class Utils {
    private static final CharsetEncoder ASCII = StandardCharsets.US_ASCII.newEncoder();
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private Utils() {
    }

    public static String toHex(long l) {
        if (l == -1L) {
            return "UNDEFINED";
        }
        return "0x" + Long.toHexString(l);
    }

    public static String readUntilNull(ByteBuffer byteBuffer) {
        StringBuilder stringBuilder = new StringBuilder(byteBuffer.remaining());
        while (byteBuffer.hasRemaining()) {
            byte by = byteBuffer.get();
            if (by == 0) {
                return stringBuilder.toString();
            }
            stringBuilder.append((char)by);
        }
        throw new IllegalArgumentException("End of buffer reached before NULL");
    }

    public static boolean validateName(String string) {
        return ASCII.canEncode(string) && !string.contains("/") && !string.contains(".");
    }

    public static void seekBufferToNextMultipleOfEight(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        if (n % 8 == 0) {
            return;
        }
        byteBuffer.position(n + (8 - n % 8));
    }

    public static int readBytesAsUnsignedInt(ByteBuffer byteBuffer, int n) {
        switch (n) {
            case 1: {
                return Byte.toUnsignedInt(byteBuffer.get());
            }
            case 2: {
                return Short.toUnsignedInt(byteBuffer.getShort());
            }
            case 3: {
                return Utils.readArbitraryLengthBytesAsUnsignedInt(byteBuffer, n);
            }
            case 4: {
                int n2 = byteBuffer.getInt();
                if (n2 < 0) {
                    throw new ArithmeticException("Could not convert to unsigned");
                }
                return n2;
            }
            case 5: 
            case 6: 
            case 7: {
                return Utils.readArbitraryLengthBytesAsUnsignedInt(byteBuffer, n);
            }
            case 8: {
                return Math.toIntExact(byteBuffer.getLong());
            }
        }
        throw new IllegalArgumentException("Couldn't read " + n + " bytes as int");
    }

    private static int readArbitraryLengthBytesAsUnsignedInt(ByteBuffer byteBuffer, int n) {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        if (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])byArray);
        }
        return new BigInteger(1, byArray).intValueExact();
    }

    public static long readBytesAsUnsignedLong(ByteBuffer byteBuffer, int n) {
        switch (n) {
            case 1: {
                return Byte.toUnsignedLong(byteBuffer.get());
            }
            case 2: {
                return Short.toUnsignedLong(byteBuffer.getShort());
            }
            case 3: {
                return Utils.readArbitraryLengthBytesAsUnsignedLong(byteBuffer, n);
            }
            case 4: {
                return Integer.toUnsignedLong(byteBuffer.getInt());
            }
            case 5: 
            case 6: 
            case 7: {
                return Utils.readArbitraryLengthBytesAsUnsignedLong(byteBuffer, n);
            }
            case 8: {
                long l = byteBuffer.getLong();
                if (l < 0L && l != -1L) {
                    throw new ArithmeticException("Could not convert to unsigned");
                }
                return l;
            }
        }
        throw new IllegalArgumentException("Couldn't read " + n + " bytes as int");
    }

    private static long readArbitraryLengthBytesAsUnsignedLong(ByteBuffer byteBuffer, int n) {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        if (byteBuffer.order() == ByteOrder.LITTLE_ENDIAN) {
            ArrayUtils.reverse((byte[])byArray);
        }
        return new BigInteger(1, byArray).longValueExact();
    }

    public static ByteBuffer createSubBuffer(ByteBuffer byteBuffer, int n) {
        ByteBuffer byteBuffer2 = byteBuffer.slice();
        byteBuffer2.limit(n);
        byteBuffer2.order(byteBuffer.order());
        byteBuffer.position(byteBuffer.position() + n);
        return byteBuffer2;
    }

    public static int bitsToInt(BitSet bitSet, int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("length must be >0");
        }
        BigInteger bigInteger = BigInteger.ZERO;
        int n3 = 0;
        while (n3 < n2) {
            if (bitSet.get(n + n3)) {
                bigInteger = bigInteger.add(TWO.pow(n3));
            }
            ++n3;
        }
        return bigInteger.intValue();
    }

    public static int bytesNeededToHoldNumber(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Only for unsigned numbers");
        }
        if (l == 0L) {
            return 1;
        }
        return (int)Math.ceil((double)BigInteger.valueOf(l).bitLength() / 8.0);
    }

    public static int[] linearIndexToDimensionIndex(int n, int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        int n2 = nArray2.length - 1;
        while (n2 >= 0) {
            nArray2[n2] = n % nArray[n2];
            n /= nArray[n2];
            --n2;
        }
        return nArray2;
    }

    public static int dimensionIndexToLinearIndex(int[] nArray, int[] nArray2) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray2.length) {
            int n3 = nArray[n2];
            int n4 = n2 + 1;
            while (n4 < nArray2.length) {
                n3 *= nArray2[n4];
                ++n4;
            }
            n += n3;
            ++n2;
        }
        return n;
    }
}

