/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree;

import io.jhdf.HdfFileChannel;
import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.btree.BTreeV1;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.dataset.chunked.indexing.ChunkImpl;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;

public abstract class BTreeV1Data
extends BTreeV1 {
    private BTreeV1Data(HdfFileChannel hdfFileChannel, long l) {
        super(hdfFileChannel, l);
    }

    public abstract List<Chunk> getChunks();

    static class BTreeV1DataLeafNode
    extends BTreeV1Data {
        private final ArrayList<Chunk> chunks;

        BTreeV1DataLeafNode(HdfFileChannel hdfFileChannel, long l, int n) {
            super(hdfFileChannel, l);
            int n2 = 8 + (n + 1) * 8;
            int n3 = (this.entriesUsed + 1) * n2;
            int n4 = this.entriesUsed * hdfFileChannel.getSizeOfOffsets();
            int n5 = n3 + n4;
            long l2 = l + 8L + (long)(2 * hdfFileChannel.getSizeOfOffsets());
            ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l2, n5);
            this.chunks = new ArrayList(this.entriesUsed);
            int n6 = 0;
            while (n6 < this.entriesUsed) {
                Chunk chunk = this.readKeyAsChunk(hdfFileChannel.getSuperblock(), n, byteBuffer);
                this.chunks.add(chunk);
                ++n6;
            }
            byteBuffer.position(byteBuffer.position() + n2);
        }

        private Chunk readKeyAsChunk(Superblock superblock, int n, ByteBuffer byteBuffer) {
            int n2 = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
            BitSet bitSet = BitSet.valueOf(new byte[]{byteBuffer.get(), byteBuffer.get(), byteBuffer.get(), byteBuffer.get()});
            int[] nArray = new int[n];
            int n3 = 0;
            while (n3 < n) {
                nArray[n3] = Utils.readBytesAsUnsignedInt(byteBuffer, 8);
                ++n3;
            }
            long l = Utils.readBytesAsUnsignedLong(byteBuffer, 8);
            if (l != 0L) {
                throw new HdfException("Invalid B tree chunk detected");
            }
            long l2 = Utils.readBytesAsUnsignedLong(byteBuffer, superblock.getSizeOfOffsets());
            return new ChunkImpl(l2, n2, nArray, bitSet);
        }

        @Override
        public List<Long> getChildAddresses() {
            return this.chunks.stream().map(Chunk::getAddress).collect(Collectors.toList());
        }

        @Override
        public List<Chunk> getChunks() {
            return this.chunks;
        }
    }

    static class BTreeV1DataNonLeafNode
    extends BTreeV1Data {
        private final List<BTreeV1Data> childNodes;

        BTreeV1DataNonLeafNode(HdfFileChannel hdfFileChannel, long l, int n) {
            super(hdfFileChannel, l);
            int n2 = 8 + (n + 1) * 8;
            int n3 = (this.entriesUsed + 1) * n2;
            int n4 = this.entriesUsed * hdfFileChannel.getSizeOfOffsets();
            int n5 = n3 + n4;
            long l2 = l + 8L + (long)(2 * hdfFileChannel.getSizeOfOffsets());
            ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l2, n5);
            this.childNodes = new ArrayList<BTreeV1Data>(this.entriesUsed);
            int n6 = 0;
            while (n6 < this.entriesUsed) {
                byteBuffer.position(byteBuffer.position() + n2);
                long l3 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
                this.childNodes.add(BTreeV1.createDataBTree(hdfFileChannel, l3, n));
                ++n6;
            }
        }

        @Override
        public List<Chunk> getChunks() {
            ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
            for (BTreeV1Data bTreeV1Data : this.childNodes) {
                arrayList.addAll(bTreeV1Data.getChunks());
            }
            return arrayList;
        }

        @Override
        public List<Long> getChildAddresses() {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (BTreeV1 bTreeV1 : this.childNodes) {
                arrayList.addAll(bTreeV1.getChildAddresses());
            }
            return arrayList;
        }
    }
}

