/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.btree.BTreeV1;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class BTreeV1Group
extends BTreeV1 {
    private BTreeV1Group(HdfFileChannel hdfFileChannel, long l) {
        super(hdfFileChannel, l);
    }

    static class BTreeV1GroupLeafNode
    extends BTreeV1Group {
        private final List<Long> childAddresses;

        BTreeV1GroupLeafNode(HdfFileChannel hdfFileChannel, long l) {
            super(hdfFileChannel, l);
            int n = (2 * this.entriesUsed + 1) * hdfFileChannel.getSizeOfLengths();
            int n2 = 2 * this.entriesUsed * hdfFileChannel.getSizeOfOffsets();
            int n3 = n + n2;
            long l2 = l + 8L + (long)(2 * hdfFileChannel.getSizeOfOffsets());
            ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l2, n3);
            this.childAddresses = new ArrayList<Long>(this.entriesUsed);
            int n4 = 0;
            while (n4 < this.entriesUsed) {
                byteBuffer.position(byteBuffer.position() + hdfFileChannel.getSizeOfLengths());
                this.childAddresses.add(Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets()));
                ++n4;
            }
        }

        @Override
        public List<Long> getChildAddresses() {
            return this.childAddresses;
        }
    }

    static class BTreeV1GroupNonLeafNode
    extends BTreeV1Group {
        private final List<BTreeV1> childNodes;

        BTreeV1GroupNonLeafNode(HdfFileChannel hdfFileChannel, long l) {
            super(hdfFileChannel, l);
            int n = (2 * this.entriesUsed + 1) * hdfFileChannel.getSizeOfLengths();
            int n2 = 2 * this.entriesUsed * hdfFileChannel.getSizeOfOffsets();
            int n3 = n + n2;
            long l2 = l + 8L + (long)(2 * hdfFileChannel.getSizeOfOffsets());
            ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l2, n3);
            this.childNodes = new ArrayList<BTreeV1>(this.entriesUsed);
            int n4 = 0;
            while (n4 < this.entriesUsed) {
                byteBuffer.position(byteBuffer.position() + hdfFileChannel.getSizeOfOffsets());
                long l3 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
                this.childNodes.add(BTreeV1GroupNonLeafNode.createGroupBTree(hdfFileChannel, l3));
                ++n4;
            }
        }

        @Override
        public List<Long> getChildAddresses() {
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (BTreeV1 bTreeV1 : this.childNodes) {
                arrayList.addAll(bTreeV1.getChildAddresses());
            }
            return arrayList;
        }
    }
}

