/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree;

import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.btree.record.BTreeRecord;
import io.jhdf.exceptions.HdfException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BTreeV2<T extends BTreeRecord> {
    private static final int NODE_OVERHEAD_BYTES = 10;
    private static final byte[] BTREE_NODE_V2_SIGNATURE = "BTHD".getBytes();
    private static final byte[] BTREE_INTERNAL_NODE_SIGNATURE = "BTIN".getBytes();
    private static final byte[] BTREE_LEAF_NODE_SIGNATURE = "BTLF".getBytes();
    private final long address;
    private final short nodeType;
    private final List<T> records;
    private final int nodeSize;
    private final int recordSize;

    public List<T> getRecords() {
        return this.records;
    }

    public BTreeV2(HdfFileChannel hdfFileChannel, long l) {
        this.address = l;
        try {
            int n = 16 + hdfFileChannel.getSizeOfOffsets() + 2 + hdfFileChannel.getSizeOfLengths() + 4;
            ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, n);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray, 0, byArray.length);
            if (!Arrays.equals(BTREE_NODE_V2_SIGNATURE, byArray)) {
                throw new HdfException("B tree V2 node signature not matched");
            }
            byte by = byteBuffer.get();
            if (by != 0) {
                throw new HdfException("Unsupported B tree v2 version detected. Version: " + by);
            }
            this.nodeType = byteBuffer.get();
            this.nodeSize = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
            this.recordSize = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            int n2 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            Utils.readBytesAsUnsignedInt(byteBuffer, 1);
            Utils.readBytesAsUnsignedInt(byteBuffer, 1);
            long l2 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
            int n3 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            int n4 = Utils.readBytesAsUnsignedInt(byteBuffer, hdfFileChannel.getSizeOfLengths());
            Utils.readBytesAsUnsignedLong(byteBuffer, 4);
            this.records = new ArrayList<T>(n4);
            this.readRecords(hdfFileChannel, l2, n2, n3, n4);
        }
        catch (HdfException hdfException) {
            throw new HdfException("Error reading B Tree node", hdfException);
        }
    }

    private void readRecords(HdfFileChannel hdfFileChannel, long l, int n, int n2, int n3) {
        boolean bl;
        ByteBuffer byteBuffer = hdfFileChannel.readBufferFromAddress(l, this.nodeSize);
        byte[] byArray = new byte[4];
        byteBuffer.get(byArray, 0, byArray.length);
        if (Arrays.equals(BTREE_INTERNAL_NODE_SIGNATURE, byArray)) {
            bl = false;
        } else if (Arrays.equals(BTREE_LEAF_NODE_SIGNATURE, byArray)) {
            bl = true;
        } else {
            throw new HdfException("B tree internal node signature not matched");
        }
        byte by = byteBuffer.get();
        if (by != 0) {
            throw new HdfException("Unsupported B tree v2 internal node version detected. Version: " + by);
        }
        byte by2 = byteBuffer.get();
        int n4 = 0;
        while (n4 < n2) {
            this.records.add(BTreeRecord.readRecord(by2, Utils.createSubBuffer(byteBuffer, this.recordSize)));
            ++n4;
        }
        if (!bl) {
            n4 = 0;
            while (n4 < n2 + 1) {
                long l2 = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
                int n5 = this.getSizeOfNumberOfRecords(this.nodeSize, n, n3, this.recordSize, hdfFileChannel.getSizeOfOffsets());
                int n6 = Utils.readBytesAsUnsignedInt(byteBuffer, n5);
                int n7 = n > 1 ? Utils.readBytesAsUnsignedInt(byteBuffer, this.getSizeOfTotalNumberOfChildRecords(this.nodeSize, n, this.recordSize)) : -1;
                this.readRecords(hdfFileChannel, l2, n - 1, n6, n7);
                ++n4;
            }
        }
    }

    private int getSizeOfNumberOfRecords(int n, int n2, int n3, int n4, int n5) {
        int n6 = n - 10;
        if (n2 > 1) {
            int n7 = this.bytesNeededToHoldNumber(n3) * 2 + n5;
            return this.bytesNeededToHoldNumber((n6 -= n7) / n4);
        }
        return this.bytesNeededToHoldNumber(n6 / n4);
    }

    private int bytesNeededToHoldNumber(int n) {
        return (Integer.numberOfTrailingZeros(Integer.highestOneBit(n)) + 8) / 8;
    }

    private int getSizeOfTotalNumberOfChildRecords(int n, int n2, int n3) {
        int n4 = n / n3;
        return (BigInteger.valueOf(n4).pow(n2).bitLength() + 8) / 8;
    }

    public String toString() {
        return "BTreeNodeV2 [address=" + this.address + ", nodeType=" + this.nodeType + "]";
    }
}

