/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree.record;

import io.jhdf.Utils;
import io.jhdf.btree.record.BTreeRecord;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class AttributeNameForIndexedAttributesRecord
extends BTreeRecord {
    private final ByteBuffer heapId;
    private final BitSet flags;
    private final long creationOrder;
    private final long hash;

    public AttributeNameForIndexedAttributesRecord(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() != 17) {
            throw new HdfException("Invalid length buffer for AttributeNameForIndexedAttributesRecord. remaining bytes = " + byteBuffer.remaining());
        }
        this.heapId = Utils.createSubBuffer(byteBuffer, 8);
        this.flags = BitSet.valueOf(new byte[]{byteBuffer.get()});
        this.creationOrder = Utils.readBytesAsUnsignedLong(byteBuffer, 4);
        this.hash = Utils.readBytesAsUnsignedLong(byteBuffer, 4);
    }

    public ByteBuffer getHeapId() {
        return this.heapId;
    }

    public BitSet getFlags() {
        return this.flags;
    }

    public long getCreationOrder() {
        return this.creationOrder;
    }

    public long getHash() {
        return this.hash;
    }
}

