/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.btree.record;

import io.jhdf.Utils;
import io.jhdf.btree.record.BTreeRecord;
import io.jhdf.exceptions.HdfException;
import java.nio.ByteBuffer;

public class LinkNameForIndexedGroupRecord
extends BTreeRecord {
    private final long hash;
    private final ByteBuffer id;

    public LinkNameForIndexedGroupRecord(ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() != 11) {
            throw new HdfException("Invalid length buffer for LinkNameForIndexedGroupRecord. remaining bytes = " + byteBuffer.remaining());
        }
        this.hash = Utils.readBytesAsUnsignedLong(byteBuffer, 4);
        this.id = Utils.createSubBuffer(byteBuffer, 7);
    }

    public long getHash() {
        return this.hash;
    }

    public ByteBuffer getId() {
        return this.id;
    }
}

