/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.Utils;
import io.jhdf.dataset.EnumDatasetReader;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.HdfTypeException;
import io.jhdf.object.datatype.ArrayDataType;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.EnumDataType;
import io.jhdf.object.datatype.FixedPoint;
import io.jhdf.object.datatype.FloatingPoint;
import io.jhdf.object.datatype.Reference;
import io.jhdf.object.datatype.StringData;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public final class DatasetReader {
    private DatasetReader() {
        throw new AssertionError((Object)"No instances of DatasetReader");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object readDataset(DataType dataType, ByteBuffer byteBuffer, int[] nArray) {
        boolean bl;
        Object object;
        block30: {
            block31: {
                block28: {
                    ByteOrder byteOrder;
                    FixedPoint fixedPoint;
                    block29: {
                        Class<?> clazz = dataType.getJavaType();
                        if (nArray.length == 0) {
                            object = Array.newInstance(clazz, 1);
                            bl = true;
                            nArray = new int[]{1};
                        } else {
                            object = Array.newInstance(clazz, nArray);
                            bl = false;
                        }
                        if (!(dataType instanceof FixedPoint)) break block28;
                        fixedPoint = (FixedPoint)dataType;
                        byteOrder = fixedPoint.getByteOrder();
                        if (!fixedPoint.isSigned()) break block29;
                        switch (fixedPoint.getSize()) {
                            case 1: {
                                DatasetReader.fillData(object, nArray, byteBuffer.order(byteOrder));
                                break block30;
                            }
                            case 2: {
                                DatasetReader.fillData(object, nArray, byteBuffer.order(byteOrder).asShortBuffer());
                                break block30;
                            }
                            case 4: {
                                DatasetReader.fillData(object, nArray, byteBuffer.order(byteOrder).asIntBuffer());
                                break block30;
                            }
                            case 8: {
                                DatasetReader.fillData(object, nArray, byteBuffer.order(byteOrder).asLongBuffer());
                                break block30;
                            }
                            default: {
                                throw new HdfTypeException("Unsupported signed integer type size " + fixedPoint.getSize() + " bytes");
                            }
                        }
                    }
                    switch (fixedPoint.getSize()) {
                        case 1: {
                            DatasetReader.fillDataUnsigned(object, nArray, byteBuffer.order(byteOrder));
                            break block30;
                        }
                        case 2: {
                            DatasetReader.fillDataUnsigned(object, nArray, byteBuffer.order(byteOrder).asShortBuffer());
                            break block30;
                        }
                        case 4: {
                            DatasetReader.fillDataUnsigned(object, nArray, byteBuffer.order(byteOrder).asIntBuffer());
                            break block30;
                        }
                        case 8: {
                            DatasetReader.fillDataUnsigned(object, nArray, byteBuffer.order(byteOrder).asLongBuffer());
                            break block30;
                        }
                        default: {
                            throw new HdfTypeException("Unsupported signed integer type size " + fixedPoint.getSize() + " bytes");
                        }
                    }
                }
                if (!(dataType instanceof FloatingPoint)) break block31;
                FloatingPoint floatingPoint = (FloatingPoint)dataType;
                ByteOrder byteOrder = floatingPoint.getByteOrder();
                switch (floatingPoint.getSize()) {
                    case 4: {
                        DatasetReader.fillData(object, nArray, byteBuffer.order(byteOrder).asFloatBuffer());
                        break block30;
                    }
                    case 8: {
                        DatasetReader.fillData(object, nArray, byteBuffer.order(byteOrder).asDoubleBuffer());
                        break block30;
                    }
                    default: {
                        throw new HdfTypeException("Unsupported floating point type size " + floatingPoint.getSize() + " bytes");
                    }
                }
            }
            if (dataType instanceof StringData) {
                int n = dataType.getSize();
                Charset charset = ((StringData)dataType).getCharset();
                DatasetReader.fillFixedLengthStringData(object, nArray, byteBuffer, n, charset);
            } else if (dataType instanceof Reference) {
                int n = dataType.getSize();
                if (n == 8) {
                    DatasetReader.fillData(object, nArray, byteBuffer.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer());
                } else {
                    if (n >= 8) throw new HdfTypeException("Unsupported address size in reference data type " + n + " bytes");
                    DatasetReader.fillLongData(object, nArray, byteBuffer.order(ByteOrder.LITTLE_ENDIAN), n);
                }
            } else if (dataType instanceof ArrayDataType) {
                ArrayDataType arrayDataType = (ArrayDataType)dataType;
                if (nArray.length != 1) {
                    throw new HdfException("Multi dimension array data types are not supported");
                }
                int n = 0;
                while (n < nArray[0]) {
                    byteBuffer.position(n * arrayDataType.getBaseType().getSize() * arrayDataType.getDimensions()[0]);
                    Object object2 = DatasetReader.readDataset(arrayDataType.getBaseType(), byteBuffer, arrayDataType.getDimensions());
                    Array.set(object, n, object2);
                    ++n;
                }
            } else {
                if (!(dataType instanceof EnumDataType)) throw new HdfException("DatasetReader was passed a type it cant fill. Type: " + dataType.getClass().getCanonicalName());
                EnumDataType enumDataType = (EnumDataType)dataType;
                return EnumDatasetReader.readEnumDataset(enumDataType, byteBuffer, nArray);
            }
        }
        if (!bl) return object;
        return Array.get(object, 0);
    }

    private static void fillData(Object object, int[] nArray, ByteBuffer byteBuffer) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                DatasetReader.fillData(object2, DatasetReader.stripLeadingIndex(nArray), byteBuffer);
                ++n;
            }
        } else {
            byteBuffer.get((byte[])object);
        }
    }

    private static void fillData(Object object, int[] nArray, ShortBuffer shortBuffer) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                DatasetReader.fillData(object2, DatasetReader.stripLeadingIndex(nArray), shortBuffer);
                ++n;
            }
        } else {
            shortBuffer.get((short[])object);
        }
    }

    private static void fillData(Object object, int[] nArray, IntBuffer intBuffer) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                DatasetReader.fillData(object2, DatasetReader.stripLeadingIndex(nArray), intBuffer);
                ++n;
            }
        } else {
            intBuffer.get((int[])object);
        }
    }

    private static void fillData(Object object, int[] nArray, LongBuffer longBuffer) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                DatasetReader.fillData(object2, DatasetReader.stripLeadingIndex(nArray), longBuffer);
                ++n;
            }
        } else {
            longBuffer.get((long[])object);
        }
    }

    private static void fillLongData(Object object, int[] nArray, ByteBuffer byteBuffer, int n) {
        if (nArray.length > 1) {
            int n2 = 0;
            while (n2 < nArray[0]) {
                Object object2 = Array.get(object, n2);
                DatasetReader.fillLongData(object2, DatasetReader.stripLeadingIndex(nArray), byteBuffer, n);
                ++n2;
            }
        } else {
            long[] lArray = (long[])object;
            int n3 = 0;
            while (n3 < lArray.length) {
                lArray[n3] = Utils.readBytesAsUnsignedLong(byteBuffer, n);
                ++n3;
            }
        }
    }

    private static void fillDataUnsigned(Object object, int[] nArray, ByteBuffer byteBuffer) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                DatasetReader.fillDataUnsigned(object2, DatasetReader.stripLeadingIndex(nArray), byteBuffer);
                ++n;
            }
        } else {
            byte[] byArray = new byte[nArray[nArray.length - 1]];
            byteBuffer.get(byArray);
            int[] nArray2 = (int[])object;
            int n = 0;
            while (n < byArray.length) {
                nArray2[n] = Byte.toUnsignedInt(byArray[n]);
                ++n;
            }
        }
    }

    private static void fillDataUnsigned(Object object, int[] nArray, ShortBuffer shortBuffer) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                DatasetReader.fillDataUnsigned(object2, DatasetReader.stripLeadingIndex(nArray), shortBuffer);
                ++n;
            }
        } else {
            short[] sArray = new short[nArray[nArray.length - 1]];
            shortBuffer.get(sArray);
            int[] nArray2 = (int[])object;
            int n = 0;
            while (n < sArray.length) {
                nArray2[n] = Short.toUnsignedInt(sArray[n]);
                ++n;
            }
        }
    }

    private static void fillDataUnsigned(Object object, int[] nArray, IntBuffer intBuffer) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                DatasetReader.fillDataUnsigned(object2, DatasetReader.stripLeadingIndex(nArray), intBuffer);
                ++n;
            }
        } else {
            int[] nArray2 = new int[nArray[nArray.length - 1]];
            intBuffer.get(nArray2);
            long[] lArray = (long[])object;
            int n = 0;
            while (n < nArray2.length) {
                lArray[n] = Integer.toUnsignedLong(nArray2[n]);
                ++n;
            }
        }
    }

    private static void fillDataUnsigned(Object object, int[] nArray, LongBuffer longBuffer) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                DatasetReader.fillDataUnsigned(object2, DatasetReader.stripLeadingIndex(nArray), longBuffer);
                ++n;
            }
        } else {
            long[] lArray = new long[nArray[nArray.length - 1]];
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            longBuffer.get(lArray);
            BigInteger[] bigIntegerArray = (BigInteger[])object;
            int n = 0;
            while (n < lArray.length) {
                byteBuffer.putLong(0, lArray[n]);
                bigIntegerArray[n] = new BigInteger(1, byteBuffer.array());
                ++n;
            }
        }
    }

    private static void fillData(Object object, int[] nArray, FloatBuffer floatBuffer) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                DatasetReader.fillData(object2, DatasetReader.stripLeadingIndex(nArray), floatBuffer);
                ++n;
            }
        } else {
            floatBuffer.get((float[])object);
        }
    }

    private static void fillData(Object object, int[] nArray, DoubleBuffer doubleBuffer) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                DatasetReader.fillData(object2, DatasetReader.stripLeadingIndex(nArray), doubleBuffer);
                ++n;
            }
        } else {
            doubleBuffer.get((double[])object);
        }
    }

    private static void fillFixedLengthStringData(Object object, int[] nArray, ByteBuffer byteBuffer, int n, Charset charset) {
        if (nArray.length > 1) {
            int n2 = 0;
            while (n2 < nArray[0]) {
                Object object2 = Array.get(object, n2);
                DatasetReader.fillFixedLengthStringData(object2, DatasetReader.stripLeadingIndex(nArray), byteBuffer, n, charset);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < nArray[0]) {
                byteBuffer.position(n3 * n);
                ByteBuffer byteBuffer2 = Utils.createSubBuffer(byteBuffer, n);
                Array.set(object, n3, charset.decode(byteBuffer2).toString().trim());
                ++n3;
            }
        }
    }

    private static int[] stripLeadingIndex(int[] nArray) {
        return Arrays.copyOfRange(nArray, 1, nArray.length);
    }
}

