/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.HdfTypeException;
import io.jhdf.object.datatype.DataType;
import io.jhdf.object.datatype.EnumDataType;
import io.jhdf.object.datatype.FixedPoint;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Map;

public class EnumDatasetReader {
    private EnumDatasetReader() {
        throw new AssertionError((Object)"No instances of EnumDatasetReader");
    }

    public static Object readEnumDataset(EnumDataType enumDataType, ByteBuffer byteBuffer, int[] nArray) {
        DataType dataType = enumDataType.getBaseType();
        if (dataType instanceof FixedPoint) {
            Object object = Array.newInstance(String.class, nArray);
            FixedPoint fixedPoint = (FixedPoint)dataType;
            switch (fixedPoint.getSize()) {
                case 1: {
                    EnumDatasetReader.fillDataUnsigned(object, nArray, byteBuffer.order(fixedPoint.getByteOrder()), enumDataType.getEnumMapping());
                    break;
                }
                case 2: {
                    EnumDatasetReader.fillDataUnsigned(object, nArray, byteBuffer.order(fixedPoint.getByteOrder()).asShortBuffer(), enumDataType.getEnumMapping());
                    break;
                }
                case 4: {
                    EnumDatasetReader.fillDataUnsigned(object, nArray, byteBuffer.order(fixedPoint.getByteOrder()).asIntBuffer(), enumDataType.getEnumMapping());
                    break;
                }
                case 8: {
                    EnumDatasetReader.fillDataUnsigned(object, nArray, byteBuffer.order(fixedPoint.getByteOrder()).asLongBuffer(), enumDataType.getEnumMapping());
                    break;
                }
                default: {
                    throw new HdfTypeException("Unsupported signed integer type size " + fixedPoint.getSize() + " bytes");
                }
            }
            return object;
        }
        throw new HdfException("Trying to fill enum dataset with non-integer base type: " + String.valueOf(dataType));
    }

    private static void fillDataUnsigned(Object object, int[] nArray, ByteBuffer byteBuffer, Map<Integer, String> map) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                EnumDatasetReader.fillDataUnsigned(object2, EnumDatasetReader.stripLeadingIndex(nArray), byteBuffer, map);
                ++n;
            }
        } else {
            byte[] byArray = new byte[nArray[nArray.length - 1]];
            byteBuffer.get(byArray);
            String[] stringArray = (String[])object;
            int n = 0;
            while (n < byArray.length) {
                stringArray[n] = map.get(Byte.toUnsignedInt(byArray[n]));
                ++n;
            }
        }
    }

    private static void fillDataUnsigned(Object object, int[] nArray, ShortBuffer shortBuffer, Map<Integer, String> map) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                EnumDatasetReader.fillDataUnsigned(object2, EnumDatasetReader.stripLeadingIndex(nArray), shortBuffer, map);
                ++n;
            }
        } else {
            short[] sArray = new short[nArray[nArray.length - 1]];
            shortBuffer.get(sArray);
            String[] stringArray = (String[])object;
            int n = 0;
            while (n < sArray.length) {
                stringArray[n] = map.get(Short.toUnsignedInt(sArray[n]));
                ++n;
            }
        }
    }

    private static void fillDataUnsigned(Object object, int[] nArray, IntBuffer intBuffer, Map<Integer, String> map) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                EnumDatasetReader.fillDataUnsigned(object2, EnumDatasetReader.stripLeadingIndex(nArray), intBuffer, map);
                ++n;
            }
        } else {
            int[] nArray2 = new int[nArray[nArray.length - 1]];
            intBuffer.get(nArray2);
            String[] stringArray = (String[])object;
            int n = 0;
            while (n < nArray2.length) {
                stringArray[n] = map.get(Math.toIntExact(Integer.toUnsignedLong(nArray2[n])));
                ++n;
            }
        }
    }

    private static void fillDataUnsigned(Object object, int[] nArray, LongBuffer longBuffer, Map<Integer, String> map) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                EnumDatasetReader.fillDataUnsigned(object2, EnumDatasetReader.stripLeadingIndex(nArray), longBuffer, map);
                ++n;
            }
        } else {
            long[] lArray = new long[nArray[nArray.length - 1]];
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            longBuffer.get(lArray);
            String[] stringArray = (String[])object;
            int n = 0;
            while (n < lArray.length) {
                byteBuffer.putLong(0, lArray[n]);
                stringArray[n] = map.get(new BigInteger(1, byteBuffer.array()).intValueExact());
                ++n;
            }
        }
    }

    private static int[] stripLeadingIndex(int[] nArray) {
        return Arrays.copyOfRange(nArray, 1, nArray.length);
    }
}

