/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset;

import io.jhdf.GlobalHeap;
import io.jhdf.HdfFileChannel;
import io.jhdf.Utils;
import io.jhdf.dataset.GlobalHeapId;
import io.jhdf.object.datatype.VariableLength;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;

public final class VariableLengthDatasetReader {
    private VariableLengthDatasetReader() {
    }

    public static Object readDataset(VariableLength variableLength, ByteBuffer byteBuffer, int[] nArray, HdfFileChannel hdfFileChannel) {
        boolean bl;
        Object object;
        Class<?> clazz = variableLength.getJavaType();
        if (nArray.length == 0) {
            object = Array.newInstance(clazz, 1);
            bl = true;
            nArray = new int[]{1};
        } else {
            object = Array.newInstance(clazz, nArray);
            bl = false;
        }
        HashMap<Long, GlobalHeap> hashMap = new HashMap<Long, GlobalHeap>();
        Charset charset = variableLength.getEncoding();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GlobalHeapId globalHeapId : VariableLengthDatasetReader.getGlobalHeapIds(byteBuffer, variableLength.getSize(), hdfFileChannel, VariableLengthDatasetReader.getTotalPoints(nArray))) {
            GlobalHeap globalHeap = hashMap.computeIfAbsent(globalHeapId.getHeapAddress(), l -> new GlobalHeap(hdfFileChannel, (long)l));
            ByteBuffer byteBuffer2 = globalHeap.getObjectData(globalHeapId.getIndex());
            String string = charset.decode(byteBuffer2).toString();
            arrayList.add(string);
        }
        VariableLengthDatasetReader.fillData(object, nArray, arrayList.iterator());
        if (bl) {
            return Array.get(object, 0);
        }
        return object;
    }

    private static void fillData(Object object, int[] nArray, Iterator<String> iterator) {
        if (nArray.length > 1) {
            int n = 0;
            while (n < nArray[0]) {
                Object object2 = Array.get(object, n);
                VariableLengthDatasetReader.fillData(object2, VariableLengthDatasetReader.stripLeadingIndex(nArray), iterator);
                ++n;
            }
        } else {
            int n = 0;
            while (n < nArray[0]) {
                Array.set(object, n, iterator.next());
                ++n;
            }
        }
    }

    private static int[] stripLeadingIndex(int[] nArray) {
        return Arrays.copyOfRange(nArray, 1, nArray.length);
    }

    private static List<GlobalHeapId> getGlobalHeapIds(ByteBuffer byteBuffer, int n, HdfFileChannel hdfFileChannel, int n2) {
        ArrayList<GlobalHeapId> arrayList = new ArrayList<GlobalHeapId>(n2);
        int n3 = n - hdfFileChannel.getSizeOfOffsets() - 4;
        while (byteBuffer.remaining() >= n) {
            byteBuffer.position(byteBuffer.position() + n3);
            long l = Utils.readBytesAsUnsignedLong(byteBuffer, hdfFileChannel.getSizeOfOffsets());
            int n4 = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
            GlobalHeapId globalHeapId = new GlobalHeapId(l, n4);
            arrayList.add(globalHeapId);
        }
        return arrayList;
    }

    private static int getTotalPoints(int[] nArray) {
        return IntStream.of(nArray).reduce(1, Math::multiplyExact);
    }
}

