/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.dataset.chunked;

import io.jhdf.HdfFileChannel;
import io.jhdf.ObjectHeader;
import io.jhdf.api.Group;
import io.jhdf.dataset.chunked.Chunk;
import io.jhdf.dataset.chunked.ChunkedDatasetBase;
import io.jhdf.dataset.chunked.indexing.ExtensibleArrayIndex;
import io.jhdf.dataset.chunked.indexing.FixedArrayIndex;
import io.jhdf.dataset.chunked.indexing.SingleChunkIndex;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.message.DataLayoutMessage;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkedDatasetV4
extends ChunkedDatasetBase {
    private static final Logger logger = LoggerFactory.getLogger(ChunkedDatasetV4.class);
    private final DataLayoutMessage.ChunkedDataLayoutMessageV4 layoutMessage;

    public ChunkedDatasetV4(HdfFileChannel hdfFileChannel, long l, String string, Group group, ObjectHeader objectHeader) {
        super(hdfFileChannel, l, string, group, objectHeader);
        this.layoutMessage = objectHeader.getMessageOfType(DataLayoutMessage.ChunkedDataLayoutMessageV4.class);
        logger.debug("Created chunked v4 dataset. Index type {}", (Object)this.layoutMessage.getIndexingType());
    }

    @Override
    protected int[] getChunkDimensions() {
        int[] nArray = this.layoutMessage.getChunkDimensions();
        return ArrayUtils.subarray((int[])nArray, (int)0, (int)(nArray.length - 1));
    }

    @Override
    protected Collection<Chunk> getAllChunks() {
        return (switch (this.layoutMessage.getIndexingType()) {
            case 1 -> {
                logger.debug("Reading single chunk indexed dataset");
                yield new SingleChunkIndex(this.layoutMessage, this.getChunkSizeInBytes(), this.getDimensions());
            }
            case 2 -> throw new UnsupportedHdfException("Implicit indexing is currently not supported");
            case 3 -> {
                logger.debug("Reading fixed array indexed dataset");
                yield new FixedArrayIndex(this.hdfFc, this.layoutMessage.getAddress(), this.getChunkSizeInBytes(), this.getDataType().getSize(), this.getDimensions());
            }
            case 4 -> {
                logger.debug("Reading extensible array indexed dataset");
                yield new ExtensibleArrayIndex(this.hdfFc, this.layoutMessage.getAddress(), this.getChunkSizeInBytes(), this.getDataType().getSize(), this.getDimensions());
            }
            case 5 -> throw new UnsupportedHdfException("B Tree V2");
            default -> throw new HdfException("Unrecognized chunk indexing type = " + this.layoutMessage.getIndexingType());
        }).getAllChunks();
    }

    private int getChunkSizeInBytes() {
        return Arrays.stream(this.getChunkDimensions()).reduce(1, Math::multiplyExact) * this.getDataType().getSize();
    }
}

