/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.DataType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CompoundDataType
extends DataType {
    private final List<CompoundDataMember> members;

    public CompoundDataType(ByteBuffer byteBuffer) {
        super(byteBuffer);
        if (this.getVersion() == 3) {
            throw new UnsupportedHdfException("Compound data type version 3 is not yet supported");
        }
        int n = Utils.bitsToInt(this.classBits, 0, 16);
        this.members = new ArrayList<CompoundDataMember>(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = byteBuffer.position();
            String string = Utils.readUntilNull(byteBuffer);
            int n5 = byteBuffer.position();
            int n6 = (n5 - n4) % 8;
            if (n6 != 0) {
                n3 = 8 - n6;
                byteBuffer.position(byteBuffer.position() + n3);
            }
            n3 = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
            int[] nArray = null;
            if (this.getVersion() == 1) {
                int n7 = Utils.readBytesAsUnsignedInt(byteBuffer, 1);
                byteBuffer.position(byteBuffer.position() + 3 + 4 + 4);
                nArray = new int[n7];
                int n8 = 0;
                while (n8 < 4) {
                    int n9 = Utils.readBytesAsUnsignedInt(byteBuffer, 4);
                    if (n8 < n7) {
                        nArray[n8] = n9;
                    }
                    ++n8;
                }
            }
            this.members.add(new CompoundDataMember(string, nArray, n3, DataType.readDataType(byteBuffer)));
            ++n2;
        }
    }

    @Override
    public Class<?> getJavaType() {
        return Map.class;
    }

    public List<CompoundDataMember> getMembers() {
        return this.members;
    }

    public static class CompoundDataMember {
        private final String name;
        private final int[] dimensionSize;
        private final int offset;
        private final DataType dataType;

        private CompoundDataMember(String string, int[] nArray, int n, DataType dataType) {
            this.name = string;
            this.dimensionSize = nArray;
            this.offset = n;
            this.dataType = dataType;
        }

        public String getName() {
            return this.name;
        }

        public int[] getDimensionSize() {
            return this.dimensionSize;
        }

        public int getOffset() {
            return this.offset;
        }

        public DataType getDataType() {
            return this.dataType;
        }
    }
}

