/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.datatype;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.HdfTypeException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.datatype.DataType;
import java.nio.ByteBuffer;

public class Reference
extends DataType {
    private final ReferenceType type;

    public Reference(ByteBuffer byteBuffer) {
        super(byteBuffer);
        int n = Utils.bitsToInt(this.classBits, 0, 4);
        switch (n) {
            case 0: {
                this.type = ReferenceType.OBJECT;
                break;
            }
            case 1: {
                this.type = ReferenceType.REGION;
                throw new UnsupportedHdfException("Dataset Region references not supported for Reference data type");
            }
            default: {
                throw new HdfException("Unrecognized Reference type. Index is: " + n);
            }
        }
    }

    public ReferenceType getType() {
        return this.type;
    }

    @Override
    public Class<?> getJavaType() {
        if (this.getSize() > 8) {
            throw new HdfTypeException("Unsupported address size in reference data type " + this.getSize() + "bytes");
        }
        return Long.TYPE;
    }

    public static enum ReferenceType {
        OBJECT,
        REGION;

    }
}

