/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class AttributeInfoMessage
extends Message {
    private static final int MAXIMUM_CREATION_INDEX_PRESENT = 0;
    private static final int ATTRIBUTE_CREATION_ORDER_PRESENT = 1;
    private final int maximumCreationIndex;
    private final long fractalHeapAddress;
    private final long attributeNameBTreeAddress;
    private final long attributeCreationOrderBTreeAddress;

    AttributeInfoMessage(ByteBuffer byteBuffer, Superblock superblock, BitSet bitSet) {
        super(bitSet);
        byte by = byteBuffer.get();
        if (by != 0) {
            throw new HdfException("Unrecognized version " + by);
        }
        BitSet bitSet2 = BitSet.valueOf(new byte[]{byteBuffer.get()});
        this.maximumCreationIndex = bitSet2.get(0) ? Utils.readBytesAsUnsignedInt(byteBuffer, 2) : -1;
        this.fractalHeapAddress = Utils.readBytesAsUnsignedLong(byteBuffer, superblock.getSizeOfOffsets());
        this.attributeNameBTreeAddress = Utils.readBytesAsUnsignedLong(byteBuffer, superblock.getSizeOfOffsets());
        this.attributeCreationOrderBTreeAddress = bitSet2.get(1) ? Utils.readBytesAsUnsignedLong(byteBuffer, superblock.getSizeOfOffsets()) : -1L;
    }

    public int getMaximumCreationIndex() {
        return this.maximumCreationIndex;
    }

    public long getFractalHeapAddress() {
        return this.fractalHeapAddress;
    }

    public long getAttributeNameBTreeAddress() {
        return this.attributeNameBTreeAddress;
    }

    public long getAttributeCreationOrderBTreeAddress() {
        return this.attributeCreationOrderBTreeAddress;
    }
}

