/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Utils;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class FilterPipelineMessage
extends Message {
    private static final int OPTIONAL = 0;
    private final List<FilterInfo> filters;

    public FilterPipelineMessage(ByteBuffer byteBuffer, BitSet bitSet) {
        super(bitSet);
        byte by = byteBuffer.get();
        if (by != 1 && by != 2) {
            throw new UnsupportedHdfException("Only filer pipeline version 1 or 2 are supported");
        }
        int n = byteBuffer.get();
        this.filters = new ArrayList<FilterInfo>(n);
        if (by == 1) {
            byteBuffer.position(byteBuffer.position() + 6);
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            int n4 = by == 2 && n3 < 256 ? 0 : Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            BitSet bitSet2 = BitSet.valueOf(new byte[]{byteBuffer.get(), byteBuffer.get()});
            boolean bl = bitSet2.get(0);
            int n5 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
            String string = n4 >= 2 ? Utils.readUntilNull(Utils.createSubBuffer(byteBuffer, n4)) : "undefined";
            int[] nArray = new int[n5];
            int n6 = 0;
            while (n6 < n5) {
                nArray[n6] = byteBuffer.getInt();
                ++n6;
            }
            if (by == 1 && n5 % 2 != 0) {
                byteBuffer.position(byteBuffer.position() + 4);
            }
            this.filters.add(new FilterInfo(n3, string, bl, nArray));
            ++n2;
        }
    }

    public List<FilterInfo> getFilters() {
        return this.filters;
    }

    public static class FilterInfo {
        private final int id;
        private final String name;
        private final boolean optional;
        private final int[] data;

        public FilterInfo(int n, String string, boolean bl, int[] nArray) {
            this.id = n;
            this.name = string;
            this.optional = bl;
            this.data = nArray;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public int[] getData() {
            return this.data;
        }

        public String toString() {
            return "FilterInfo [id=" + this.id + ", name=" + this.name + ", optional=" + this.optional + ", data=" + Arrays.toString(this.data) + "]";
        }
    }
}

