/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class LinkInfoMessage
extends Message {
    private static final int CREATION_ORDER_TRACKED = 0;
    private static final int CREATION_ORDER_INDEXED = 1;
    private final byte version;
    private final long maximumCreationIndex;
    private final long fractalHeapAddress;
    private final long bTreeNameIndexAddress;
    private final long bTreeCreationOrderIndexAddress;
    private final BitSet flags;

    LinkInfoMessage(ByteBuffer byteBuffer, Superblock superblock, BitSet bitSet) {
        super(bitSet);
        this.version = byteBuffer.get();
        this.flags = BitSet.valueOf(new byte[]{byteBuffer.get()});
        this.maximumCreationIndex = this.flags.get(0) ? Utils.readBytesAsUnsignedLong(byteBuffer, 8) : -1L;
        this.fractalHeapAddress = Utils.readBytesAsUnsignedLong(byteBuffer, superblock.getSizeOfOffsets());
        this.bTreeNameIndexAddress = Utils.readBytesAsUnsignedLong(byteBuffer, superblock.getSizeOfOffsets());
        this.bTreeCreationOrderIndexAddress = this.flags.get(1) ? Utils.readBytesAsUnsignedLong(byteBuffer, superblock.getSizeOfOffsets()) : -1L;
    }

    public int getVersion() {
        return this.version;
    }

    public long getMaximumCreationIndex() {
        return this.maximumCreationIndex;
    }

    public long getFractalHeapAddress() {
        return this.fractalHeapAddress;
    }

    public long getBTreeNameIndexAddress() {
        return this.bTreeNameIndexAddress;
    }

    public long getBTreeCreationOrderIndexAddress() {
        return this.bTreeCreationOrderIndexAddress;
    }

    public boolean isLinkCreationOrderTracked() {
        return this.flags.get(0);
    }
}

