/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public class LinkMessage
extends Message {
    private static final int CREATION_ORDER_PRESENT = 2;
    private static final int LINK_TYPE_PRESENT = 3;
    private static final int LINK_CHARACTER_SET_PRESENT = 4;
    private final byte version;
    private final LinkType linkType;
    private final long creationOrder;
    private final String linkName;
    private long hardLinkAddress;
    private String softLink;
    private String externalFile;
    private String externalPath;

    public static LinkMessage fromBuffer(ByteBuffer byteBuffer, Superblock superblock) {
        return new LinkMessage(byteBuffer, superblock, null);
    }

    LinkMessage(ByteBuffer byteBuffer, Superblock superblock, BitSet bitSet) {
        Charset charset;
        int n;
        int n2;
        block17: {
            block16: {
                super(bitSet);
                this.version = byteBuffer.get();
                if (this.version != 1) {
                    throw new HdfException("Unrecognized version = " + this.version);
                }
                BitSet bitSet2 = BitSet.valueOf(new byte[]{byteBuffer.get()});
                int n3 = Utils.bitsToInt(bitSet2, 0, 2);
                switch (n3) {
                    case 0: {
                        n2 = 1;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 4;
                        break;
                    }
                    case 3: {
                        n2 = 8;
                        break;
                    }
                    default: {
                        throw new HdfException("Unrecognized size of link name");
                    }
                }
                this.linkType = bitSet2.get(3) ? LinkType.fromInt(Utils.readBytesAsUnsignedInt(byteBuffer, 1)) : LinkType.HARD;
                this.creationOrder = bitSet2.get(2) ? Utils.readBytesAsUnsignedLong(byteBuffer, 8) : -1L;
                if (!bitSet2.get(4)) break block16;
                n = Utils.readBytesAsUnsignedInt(byteBuffer, 1);
                switch (n) {
                    case 0: {
                        charset = StandardCharsets.US_ASCII;
                        break block17;
                    }
                    case 1: {
                        charset = StandardCharsets.UTF_8;
                        break block17;
                    }
                    default: {
                        throw new HdfException("Unknown link charset value = " + n);
                    }
                }
            }
            charset = StandardCharsets.US_ASCII;
        }
        n = Utils.readBytesAsUnsignedInt(byteBuffer, n2);
        ByteBuffer byteBuffer2 = Utils.createSubBuffer(byteBuffer, n);
        this.linkName = charset.decode(byteBuffer2).toString();
        switch (this.linkType) {
            case HARD: {
                this.hardLinkAddress = Utils.readBytesAsUnsignedLong(byteBuffer, superblock.getSizeOfOffsets());
                break;
            }
            case SOFT: {
                int n4 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
                ByteBuffer byteBuffer3 = Utils.createSubBuffer(byteBuffer, n4);
                this.softLink = StandardCharsets.US_ASCII.decode(byteBuffer3).toString();
                break;
            }
            case EXTERNAL: {
                int n5 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
                ByteBuffer byteBuffer4 = Utils.createSubBuffer(byteBuffer, n5);
                byteBuffer4.position(1);
                this.externalFile = Utils.readUntilNull(byteBuffer4);
                this.externalPath = Utils.readUntilNull(byteBuffer4);
                break;
            }
            default: {
                throw new HdfException("Unrecognized link type = " + String.valueOf((Object)this.linkType));
            }
        }
    }

    public byte getVersion() {
        return this.version;
    }

    public LinkType getLinkType() {
        return this.linkType;
    }

    public long getCreationOrder() {
        return this.creationOrder;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public long getHardLinkAddress() {
        if (this.linkType == LinkType.HARD) {
            return this.hardLinkAddress;
        }
        throw new HdfException("This link message is not a hard link. Link type is: " + String.valueOf((Object)this.linkType));
    }

    public String getSoftLink() {
        if (this.linkType == LinkType.SOFT) {
            return this.softLink;
        }
        throw new HdfException("This link message is not a soft link. Link type is: " + String.valueOf((Object)this.linkType));
    }

    public String getExternalFile() {
        if (this.linkType == LinkType.EXTERNAL) {
            return this.externalFile;
        }
        throw new HdfException("This link message is not a external link. Link type is: " + String.valueOf((Object)this.linkType));
    }

    public String getExternalPath() {
        if (this.linkType == LinkType.EXTERNAL) {
            return this.externalPath;
        }
        throw new HdfException("This link message is not a external link. Link type is: " + String.valueOf((Object)this.linkType));
    }

    public static enum LinkType {
        HARD,
        SOFT,
        EXTERNAL;


        private static LinkType fromInt(int n) {
            switch (n) {
                case 0: {
                    return HARD;
                }
                case 1: {
                    return SOFT;
                }
                case 64: {
                    return EXTERNAL;
                }
            }
            throw new HdfException("Unrecognized link type: " + n);
        }
    }
}

