/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Superblock;
import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.exceptions.UnsupportedHdfException;
import io.jhdf.object.message.AttributeInfoMessage;
import io.jhdf.object.message.AttributeMessage;
import io.jhdf.object.message.BTreeKValuesMessage;
import io.jhdf.object.message.DataLayoutMessage;
import io.jhdf.object.message.DataSpaceMessage;
import io.jhdf.object.message.DataTypeMessage;
import io.jhdf.object.message.FillValueMessage;
import io.jhdf.object.message.FillValueOldMessage;
import io.jhdf.object.message.FilterPipelineMessage;
import io.jhdf.object.message.GroupInfoMessage;
import io.jhdf.object.message.LinkInfoMessage;
import io.jhdf.object.message.LinkMessage;
import io.jhdf.object.message.NilMessage;
import io.jhdf.object.message.ObjectCommentMessage;
import io.jhdf.object.message.ObjectHeaderContinuationMessage;
import io.jhdf.object.message.ObjectModificationTimeMessage;
import io.jhdf.object.message.ObjectReferenceCountMessage;
import io.jhdf.object.message.SymbolTableMessage;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message {
    private static final Logger logger = LoggerFactory.getLogger(Message.class);
    private static final int MESSAGE_DATA_CONSTANT = 0;
    private static final int MESSAGE_SHARED = 1;
    private static final int MESSAGE_SHOULD_NOT_BE_SHARED = 2;
    private static final int FAIL_ON_UNKNOWN_MESSAGE_TYPE_WITH_WRITE = 3;
    private static final int SET_FLAG_ON_MODIFICATION_WITH_UNKNOWN_MESSAGE = 4;
    private static final int OBJECT_MODIFIED_WITHOUT_UNDERSTANDING_MESSAGE = 5;
    private static final int MESSAGE_CAN_BE_SHARED = 6;
    private static final int ALWAYS_FAIL_ON_UNKNOWN_MESSAGE_TYPE = 7;
    private final BitSet flags;

    public Message(BitSet bitSet) {
        this.flags = bitSet;
    }

    public static Message readObjectHeaderV1Message(ByteBuffer byteBuffer, Superblock superblock) {
        Utils.seekBufferToNextMultipleOfEight(byteBuffer);
        int n = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
        int n2 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
        BitSet bitSet = BitSet.valueOf(new byte[]{byteBuffer.get()});
        byteBuffer.position(byteBuffer.position() + 3);
        ByteBuffer byteBuffer2 = Utils.createSubBuffer(byteBuffer, n2);
        Message message = Message.readMessage(byteBuffer2, superblock, n, bitSet);
        logger.debug("Read message: {}", (Object)message);
        if (byteBuffer2.remaining() > 7) {
            logger.warn("After reading message ({}) buffer still has {} bytes remaining", (Object)message.getClass().getSimpleName(), (Object)byteBuffer2.remaining());
        }
        return message;
    }

    public static Message readObjectHeaderV2Message(ByteBuffer byteBuffer, Superblock superblock) {
        return Message.readObjectHeaderV2Message(byteBuffer, superblock, false);
    }

    public static Message readObjectHeaderV2Message(ByteBuffer byteBuffer, Superblock superblock, boolean bl) {
        int n = Utils.readBytesAsUnsignedInt(byteBuffer, 1);
        int n2 = Utils.readBytesAsUnsignedInt(byteBuffer, 2);
        BitSet bitSet = BitSet.valueOf(new byte[]{byteBuffer.get()});
        if (bl) {
            byteBuffer.getShort();
        }
        ByteBuffer byteBuffer2 = Utils.createSubBuffer(byteBuffer, n2);
        Message message = Message.readMessage(byteBuffer2, superblock, n, bitSet);
        logger.debug("Read message: {}", (Object)message);
        if (byteBuffer2.hasRemaining()) {
            logger.warn("After reading message ({}) buffer still has {} bytes remaining", (Object)message.getClass().getSimpleName(), (Object)byteBuffer2.remaining());
        }
        return message;
    }

    private static Message readMessage(ByteBuffer byteBuffer, Superblock superblock, int n, BitSet bitSet) {
        switch (n) {
            case 0: {
                return new NilMessage(byteBuffer, bitSet);
            }
            case 1: {
                return new DataSpaceMessage(byteBuffer, superblock, bitSet);
            }
            case 2: {
                return new LinkInfoMessage(byteBuffer, superblock, bitSet);
            }
            case 3: {
                return new DataTypeMessage(byteBuffer, bitSet);
            }
            case 4: {
                return new FillValueOldMessage(byteBuffer, bitSet);
            }
            case 5: {
                return new FillValueMessage(byteBuffer, bitSet);
            }
            case 6: {
                return new LinkMessage(byteBuffer, superblock, bitSet);
            }
            case 8: {
                return DataLayoutMessage.createDataLayoutMessage(byteBuffer, superblock, bitSet);
            }
            case 9: {
                throw new HdfException("Encountered Bogus message. Is this a valid HDF5 file?");
            }
            case 10: {
                return new GroupInfoMessage(byteBuffer, bitSet);
            }
            case 11: {
                return new FilterPipelineMessage(byteBuffer, bitSet);
            }
            case 12: {
                return new AttributeMessage(byteBuffer, superblock, bitSet);
            }
            case 13: {
                return new ObjectCommentMessage(byteBuffer, bitSet);
            }
            case 16: {
                return new ObjectHeaderContinuationMessage(byteBuffer, superblock, bitSet);
            }
            case 17: {
                return new SymbolTableMessage(byteBuffer, superblock, bitSet);
            }
            case 18: {
                return new ObjectModificationTimeMessage(byteBuffer, bitSet);
            }
            case 19: {
                return new BTreeKValuesMessage(byteBuffer, bitSet);
            }
            case 20: {
                throw new UnsupportedHdfException("Encountered Driver Info Message, this is not supported by jHDF");
            }
            case 21: {
                return new AttributeInfoMessage(byteBuffer, superblock, bitSet);
            }
            case 22: {
                return new ObjectReferenceCountMessage(byteBuffer, bitSet);
            }
        }
        throw new HdfException("Unrecognized message type = " + n);
    }

    public boolean isMessageDataConstant() {
        return this.flags.get(0);
    }

    public boolean isMessageShared() {
        return this.flags.get(1);
    }

    public boolean isMessageNotShared() {
        return this.flags.get(2);
    }

    public boolean isFailOnUnknownTypeWithWrite() {
        return this.flags.get(3);
    }

    public boolean isFlagToBeSetOnUnknownType() {
        return this.flags.get(4);
    }

    public boolean isObjectModifiedWithoutUnderstandingOfThisMessage() {
        return this.flags.get(5);
    }

    public boolean isMessageShareable() {
        return this.flags.get(6);
    }

    public boolean isAlwaysFailOnUnknownType() {
        return this.flags.get(7);
    }
}

