/*
 * Decompiled with CFR 0.152.
 */
package io.jhdf.object.message;

import io.jhdf.Utils;
import io.jhdf.exceptions.HdfException;
import io.jhdf.object.message.Message;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.BitSet;

public class ObjectModificationTimeMessage
extends Message {
    private final long unixEpocSecond;

    ObjectModificationTimeMessage(ByteBuffer byteBuffer, BitSet bitSet) {
        super(bitSet);
        byte by = byteBuffer.get();
        if (by != 1) {
            throw new HdfException("Unrecognized version " + by);
        }
        byteBuffer.position(byteBuffer.position() + 3);
        this.unixEpocSecond = Utils.readBytesAsUnsignedLong(byteBuffer, 4);
    }

    public LocalDateTime getModifiedTime() {
        return LocalDateTime.ofEpochSecond(this.unixEpocSecond, 0, ZoneOffset.UTC);
    }

    public long getUnixEpocSecond() {
        return this.unixEpocSecond;
    }
}

