/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.ifcfile;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IAddressableContainer;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.GamaGeometryFile;
import gama.gaml.operators.spatial.SpatialCreation;
import gama.gaml.operators.spatial.SpatialTransformations;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import ifc2x3javatoolbox.ifc2x3tc1.DOUBLE;
import ifc2x3javatoolbox.ifc2x3tc1.IfcArbitraryClosedProfileDef;
import ifc2x3javatoolbox.ifc2x3tc1.IfcAxis2Placement;
import ifc2x3javatoolbox.ifc2x3tc1.IfcAxis2Placement2D;
import ifc2x3javatoolbox.ifc2x3tc1.IfcAxis2Placement3D;
import ifc2x3javatoolbox.ifc2x3tc1.IfcBooleanClippingResult;
import ifc2x3javatoolbox.ifc2x3tc1.IfcBooleanOperand;
import ifc2x3javatoolbox.ifc2x3tc1.IfcCartesianPoint;
import ifc2x3javatoolbox.ifc2x3tc1.IfcCurve;
import ifc2x3javatoolbox.ifc2x3tc1.IfcDirection;
import ifc2x3javatoolbox.ifc2x3tc1.IfcDoor;
import ifc2x3javatoolbox.ifc2x3tc1.IfcExtrudedAreaSolid;
import ifc2x3javatoolbox.ifc2x3tc1.IfcLengthMeasure;
import ifc2x3javatoolbox.ifc2x3tc1.IfcLocalPlacement;
import ifc2x3javatoolbox.ifc2x3tc1.IfcMaterialLayer;
import ifc2x3javatoolbox.ifc2x3tc1.IfcMaterialLayerSet;
import ifc2x3javatoolbox.ifc2x3tc1.IfcMaterialLayerSetUsage;
import ifc2x3javatoolbox.ifc2x3tc1.IfcMaterialSelect;
import ifc2x3javatoolbox.ifc2x3tc1.IfcObjectPlacement;
import ifc2x3javatoolbox.ifc2x3tc1.IfcOpeningElement;
import ifc2x3javatoolbox.ifc2x3tc1.IfcPolyline;
import ifc2x3javatoolbox.ifc2x3tc1.IfcProduct;
import ifc2x3javatoolbox.ifc2x3tc1.IfcProperty;
import ifc2x3javatoolbox.ifc2x3tc1.IfcPropertySet;
import ifc2x3javatoolbox.ifc2x3tc1.IfcPropertySetDefinition;
import ifc2x3javatoolbox.ifc2x3tc1.IfcPropertySingleValue;
import ifc2x3javatoolbox.ifc2x3tc1.IfcRectangleProfileDef;
import ifc2x3javatoolbox.ifc2x3tc1.IfcRelAssociates;
import ifc2x3javatoolbox.ifc2x3tc1.IfcRelAssociatesMaterial;
import ifc2x3javatoolbox.ifc2x3tc1.IfcRelDefines;
import ifc2x3javatoolbox.ifc2x3tc1.IfcRelDefinesByProperties;
import ifc2x3javatoolbox.ifc2x3tc1.IfcRelDefinesByType;
import ifc2x3javatoolbox.ifc2x3tc1.IfcRepresentation;
import ifc2x3javatoolbox.ifc2x3tc1.IfcRepresentationItem;
import ifc2x3javatoolbox.ifc2x3tc1.IfcRoof;
import ifc2x3javatoolbox.ifc2x3tc1.IfcSlab;
import ifc2x3javatoolbox.ifc2x3tc1.IfcSpace;
import ifc2x3javatoolbox.ifc2x3tc1.IfcTypeObject;
import ifc2x3javatoolbox.ifc2x3tc1.IfcWall;
import ifc2x3javatoolbox.ifc2x3tc1.IfcWindow;
import ifc4javatoolbox.ifcmodel.IfcModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;

@GamlAnnotations.file(name="ifc", extensions={"ifc"}, buffer_type=5, buffer_content=13, buffer_index=1, concept={"ifc", "file"})
public class GamaIFCFile
extends GamaGeometryFile {
    public GamaIFCFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    protected IShape buildGeometry(IScope iScope) {
        return GamaGeometryType.geometriesToGeometry((IScope)iScope, (IContainer)this.getBuffer());
    }

    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.create();
    }

    public GamaPoint toPoint(IfcDirection ifcDirection) {
        if (ifcDirection != null) {
            if (ifcDirection.getDirectionRatios().size() > 2) {
                return new GamaPoint(((DOUBLE)ifcDirection.getDirectionRatios().get((int)0)).value, ((DOUBLE)ifcDirection.getDirectionRatios().get((int)1)).value, ((DOUBLE)ifcDirection.getDirectionRatios().get((int)2)).value);
            }
            return new GamaPoint(((DOUBLE)ifcDirection.getDirectionRatios().get((int)0)).value, ((DOUBLE)ifcDirection.getDirectionRatios().get((int)1)).value);
        }
        return null;
    }

    public GamaPoint toPoint(IfcCartesianPoint ifcCartesianPoint) {
        if (ifcCartesianPoint != null) {
            if (ifcCartesianPoint.getCoordinates().size() > 2) {
                return new GamaPoint(((IfcLengthMeasure)ifcCartesianPoint.getCoordinates().get((int)0)).value, ((IfcLengthMeasure)ifcCartesianPoint.getCoordinates().get((int)1)).value, ((IfcLengthMeasure)ifcCartesianPoint.getCoordinates().get((int)2)).value);
            }
            return new GamaPoint(((IfcLengthMeasure)ifcCartesianPoint.getCoordinates().get((int)0)).value, ((IfcLengthMeasure)ifcCartesianPoint.getCoordinates().get((int)1)).value);
        }
        return null;
    }

    public IShape toGeom(IScope iScope, Collection<IfcCartesianPoint> collection, boolean bl) {
        ArrayList<GamaPoint> arrayList = new ArrayList<GamaPoint>();
        for (IfcCartesianPoint ifcCartesianPoint : collection) {
            arrayList.add(this.toPoint(ifcCartesianPoint));
        }
        return bl ? GamaGeometryType.buildPolygon(arrayList) : GamaGeometryType.buildPolyline(arrayList);
    }

    public IShape createOpening(IScope iScope, IfcOpeningElement ifcOpeningElement) {
        if (ifcOpeningElement.getObjectPlacement() == null) {
            return null;
        }
        Axe axe = new Axe();
        ArrayList<IfcAxis2Placement> arrayList = new ArrayList<IfcAxis2Placement>();
        this.relatedTo(iScope, ifcOpeningElement.getObjectPlacement(), arrayList);
        axe.update(arrayList, true);
        IShape iShape = SpatialCreation.sphere((IScope)iScope, (Double)0.2);
        this.addAttribtutes((IfcProduct)ifcOpeningElement, iShape);
        axe.transform(iShape);
        return iShape;
    }

    public Double defineDoorDepth(IScope iScope, IfcObjectPlacement ifcObjectPlacement, Map<IfcProduct, Double> map) {
        if (ifcObjectPlacement instanceof IfcLocalPlacement) {
            IfcObjectPlacement ifcObjectPlacement2 = ((IfcLocalPlacement)ifcObjectPlacement).getPlacementRelTo();
            if (ifcObjectPlacement2 != null && ifcObjectPlacement2.getPlacesObject_Inverse() != null) {
                for (IfcProduct ifcProduct : ifcObjectPlacement2.getPlacesObject_Inverse()) {
                    if (!map.containsKey(ifcProduct)) continue;
                    return map.get(ifcProduct);
                }
            }
            if (ifcObjectPlacement2 != null) {
                return this.defineDoorDepth(iScope, ifcObjectPlacement2, map);
            }
        }
        return null;
    }

    public IShape createDoor(IScope iScope, IfcDoor ifcDoor, Map<IfcProduct, Double> map) {
        if (ifcDoor.getObjectPlacement() == null) {
            return null;
        }
        Axe axe = new Axe();
        ArrayList<IfcAxis2Placement> arrayList = new ArrayList<IfcAxis2Placement>();
        this.relatedTo(iScope, ifcDoor.getObjectPlacement(), arrayList);
        axe.update(arrayList, true);
        double d = ifcDoor.getOverallHeight().value;
        double d2 = ifcDoor.getOverallWidth().value;
        Double d3 = this.defineDoorDepth(iScope, ifcDoor.getObjectPlacement(), map);
        if (d3 == null || d3 == 0.0) {
            d3 = d2 / 10.0;
        }
        IShape iShape = SpatialCreation.box((IScope)iScope, (double)d2, (double)d3, (double)d);
        iShape = SpatialTransformations.translated_by((IScope)iScope, (IShape)iShape, (GamaPoint)new GamaPoint(d2 / 2.0, 0.0));
        IList iList = GamaListFactory.create((IType)Types.GEOMETRY);
        iList.add((Object)new GamaPoint(-d3.doubleValue() / 2.0, 0.0));
        iList.add((Object)new GamaPoint(d3 / 2.0, 0.0));
        IShape iShape2 = SpatialCreation.line((IScope)iScope, (IContainer)iList);
        iShape.setAttribute("name", (Object)ifcDoor.getName().getDecodedValue());
        iShape = SpatialTransformations.translated_by((IScope)iScope, (IShape)iShape, (GamaPoint)new GamaPoint(iShape2.getLocation().getX() - ((GamaPoint)iShape2.getPoints().get(0)).getX(), iShape2.getLocation().getY() - ((GamaPoint)iShape2.getPoints().get(0)).getY()));
        this.addAttribtutes((IfcProduct)ifcDoor, iShape);
        axe.transform(iShape);
        return iShape;
    }

    public IShape createWindow(IScope iScope, IfcWindow ifcWindow, Map<IfcProduct, Double> map) {
        IfcAxis2Placement3D ifcAxis2Placement3D;
        if (ifcWindow.getObjectPlacement() == null) {
            return null;
        }
        Axe axe = new Axe();
        ArrayList<IfcAxis2Placement> arrayList = new ArrayList<IfcAxis2Placement>();
        ArrayList<IfcObjectPlacement> arrayList2 = new ArrayList<IfcObjectPlacement>();
        IfcObjectPlacement ifcObjectPlacement = ifcWindow.getObjectPlacement();
        IfcObjectPlacement ifcObjectPlacement2 = ifcWindow.getObjectPlacement();
        int n = 0;
        int n2 = 0;
        while (ifcObjectPlacement2 instanceof IfcLocalPlacement) {
            IfcObjectPlacement ifcObjectPlacement3 = ((IfcLocalPlacement)ifcObjectPlacement2).getPlacementRelTo();
            if (ifcObjectPlacement3 != null && ifcObjectPlacement3.getPlacesObject_Inverse() != null) {
                for (IfcProduct ifcProduct : ifcObjectPlacement3.getPlacesObject_Inverse()) {
                    if (!(ifcProduct instanceof IfcWall)) continue;
                    n = n2;
                    break;
                }
            }
            if (ifcObjectPlacement3 == null) break;
            arrayList2.add(ifcObjectPlacement3);
            if (n != 0) break;
            ifcObjectPlacement2 = ifcObjectPlacement3;
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            ifcObjectPlacement = (IfcObjectPlacement)arrayList2.remove(0);
            ++n3;
        }
        this.relatedTo(iScope, ifcObjectPlacement, arrayList);
        IfcAxis2Placement ifcAxis2Placement = null;
        if (ifcWindow.getObjectPlacement() instanceof IfcLocalPlacement) {
            ifcAxis2Placement = ((IfcLocalPlacement)ifcWindow.getObjectPlacement()).getRelativePlacement();
        }
        axe.update(arrayList, true);
        double d = ifcWindow.getOverallHeight().value;
        double d2 = ifcWindow.getOverallWidth().value;
        Double d3 = this.defineDoorDepth(iScope, ifcWindow.getObjectPlacement(), map);
        if (d3 == null) {
            d3 = d2 / 10.0;
        }
        IShape iShape = SpatialCreation.box((IScope)iScope, (double)d2, (double)d3, (double)d);
        iShape.setAttribute("name", (Object)ifcWindow.getName().getDecodedValue());
        IList iList = GamaListFactory.create((IType)Types.GEOMETRY);
        iList.add((Object)new GamaPoint(-d2 / 2.0, 0.0));
        iList.add((Object)new GamaPoint(d2 / 2.0, 0.0));
        IShape iShape2 = SpatialCreation.line((IScope)iScope, (IContainer)iList);
        iShape = SpatialTransformations.translated_by((IScope)iScope, (IShape)iShape, (GamaPoint)new GamaPoint(iShape2.getLocation().getX() - ((GamaPoint)iShape2.getPoints().get(0)).getX(), 1.5 * d3));
        this.addAttribtutes((IfcProduct)ifcWindow, iShape);
        axe.transform(iShape);
        if (ifcAxis2Placement instanceof IfcAxis2Placement2D) {
            IfcAxis2Placement2D ifcAxis2Placement2D = (IfcAxis2Placement2D)ifcAxis2Placement;
            if (ifcAxis2Placement2D.getRefDirection() != null) {
                GamaPoint gamaPoint = this.toPoint(ifcAxis2Placement2D.getRefDirection());
                iShape = SpatialTransformations.rotated_by((IScope)iScope, (IShape)iShape, (Double)(90.0 * gamaPoint.y));
            }
        } else if (ifcAxis2Placement instanceof IfcAxis2Placement3D && (ifcAxis2Placement3D = (IfcAxis2Placement3D)ifcAxis2Placement).getRefDirection() != null) {
            GamaPoint gamaPoint = this.toPoint(ifcAxis2Placement3D.getRefDirection());
            iShape = SpatialTransformations.rotated_by((IScope)iScope, (IShape)iShape, (Double)(90.0 * gamaPoint.y));
        }
        return iShape;
    }

    public IShape createWall(IScope iScope, IfcWall ifcWall, Map<IfcProduct, Double> map) {
        Object object;
        Iterator iterator;
        IShape iShape2;
        if (ifcWall.getObjectPlacement() == null) {
            return null;
        }
        Axe axe = new Axe();
        ArrayList<IfcAxis2Placement> arrayList = new ArrayList<IfcAxis2Placement>();
        this.relatedTo(iScope, ifcWall.getObjectPlacement(), arrayList);
        axe.update(arrayList, true);
        IList iList = GamaListFactory.create((IType)Types.POINT);
        for (IShape iShape2 : ifcWall.getRepresentation().getRepresentations()) {
            iterator = iShape2.getItems().iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = (IfcRepresentationItem)iterator.next();
                if (!(iterator2 instanceof IfcPolyline)) continue;
                object = (IfcPolyline)iterator2;
                for (Iterator iterator3 : object.getPoints()) {
                    iList.add((Object)this.toPoint((IfcCartesianPoint)iterator3));
                }
            }
        }
        iShape2 = SpatialCreation.line((IScope)iScope, (IContainer)iList);
        axe.transform(iShape2);
        for (Iterator iterator4 : ifcWall.getRepresentation().getRepresentations()) {
            object = iterator4.getItems().iterator();
            while (object.hasNext()) {
                IfcBooleanOperand ifcBooleanOperand;
                Iterator iterator5;
                Iterator iterator3;
                iterator3 = iterator = (IfcRepresentationItem)object.next();
                while (iterator3 instanceof IfcBooleanClippingResult) {
                    iterator5 = (IfcBooleanClippingResult)iterator3;
                    ifcBooleanOperand = iterator5.getFirstOperand();
                    iterator3 = (IfcRepresentationItem)ifcBooleanOperand;
                }
                if (!(iterator3 instanceof IfcExtrudedAreaSolid)) continue;
                iterator5 = (IfcExtrudedAreaSolid)iterator3;
                ifcBooleanOperand = (IfcRectangleProfileDef)iterator5.getSweptArea();
                Double d = ifcBooleanOperand.getXDim().value;
                Double d2 = ifcBooleanOperand.getYDim().value;
                Double d3 = iterator5.getDepth().value;
                map.put((IfcProduct)ifcWall, d2);
                IShape iShape3 = SpatialCreation.box((IScope)iScope, (double)d, (double)d2, (double)d3);
                axe.transform(iShape3);
                iShape3 = SpatialTransformations.translated_by((IScope)iScope, (IShape)iShape3, (GamaPoint)new GamaPoint(iShape2.getLocation().getX() - ((GamaPoint)iShape2.getPoints().get(0)).getX(), iShape2.getLocation().getY() - ((GamaPoint)iShape2.getPoints().get(0)).getY()));
                iShape3.setAttribute("name", (Object)ifcWall.getName().getDecodedValue());
                this.addAttribtutes((IfcProduct)ifcWall, iShape3);
                this.getMaterial((IfcProduct)ifcWall, iShape3);
                return iShape3;
            }
        }
        return null;
    }

    private void getMaterial(IfcProduct ifcProduct, IShape iShape) {
        IMap iMap = GamaMapFactory.create((IType)Types.STRING, (IType)Types.FLOAT);
        for (IfcRelAssociates ifcRelAssociates : ifcProduct.getHasAssociations_Inverse()) {
            Object object;
            Iterator iterator2;
            IfcMaterialLayerSet ifcMaterialLayerSet;
            IfcMaterialLayerSetUsage ifcMaterialLayerSetUsage;
            IfcRelAssociatesMaterial ifcRelAssociatesMaterial;
            IfcMaterialSelect ifcMaterialSelect;
            if (!(ifcRelAssociates instanceof IfcRelAssociatesMaterial) || (ifcMaterialSelect = (ifcRelAssociatesMaterial = (IfcRelAssociatesMaterial)ifcRelAssociates).getRelatingMaterial()) == null) continue;
            if (ifcMaterialSelect instanceof IfcMaterialLayerSetUsage) {
                ifcMaterialLayerSetUsage = (IfcMaterialLayerSetUsage)ifcMaterialSelect;
                ifcMaterialLayerSet = ifcMaterialLayerSetUsage.getForLayerSet();
                for (Iterator iterator2 : ifcMaterialLayerSet.getMaterialLayers()) {
                    object = iterator2.getMaterial();
                    String string = object.getName().getDecodedValue();
                    iMap.put((Object)string, (Object)iterator2.getLayerThickness().value);
                }
                continue;
            }
            if (!(ifcMaterialSelect instanceof IfcMaterialLayerSet)) continue;
            ifcMaterialLayerSetUsage = (IfcMaterialLayerSet)ifcMaterialSelect;
            iterator2 = ifcMaterialLayerSetUsage.getMaterialLayers().iterator();
            while (iterator2.hasNext()) {
                ifcMaterialLayerSet = (IfcMaterialLayer)iterator2.next();
                Iterator iterator3 = ifcMaterialLayerSet.getMaterial();
                object = iterator3.getName().getDecodedValue();
                iMap.put(object, (Object)ifcMaterialLayerSet.getLayerThickness().value);
            }
        }
        iShape.setAttribute("materials", (Object)iMap);
    }

    public IShape createSlab(IScope iScope, IfcSlab ifcSlab) {
        if (ifcSlab.getObjectPlacement() == null) {
            return null;
        }
        Axe axe = new Axe();
        ArrayList<IfcAxis2Placement> arrayList = new ArrayList<IfcAxis2Placement>();
        this.relatedTo(iScope, ifcSlab.getObjectPlacement(), arrayList);
        axe.update(arrayList, true);
        for (IfcRepresentation ifcRepresentation : ifcSlab.getRepresentation().getRepresentations()) {
            for (IfcRepresentationItem ifcRepresentationItem : ifcRepresentation.getItems()) {
                if (!(ifcRepresentationItem instanceof IfcExtrudedAreaSolid)) continue;
                IfcExtrudedAreaSolid ifcExtrudedAreaSolid = (IfcExtrudedAreaSolid)ifcRepresentationItem;
                Double d = ifcExtrudedAreaSolid.getDepth().value;
                if (ifcExtrudedAreaSolid.getPosition() != null) {
                    axe.update((IfcAxis2Placement)ifcExtrudedAreaSolid.getPosition());
                }
                if (ifcExtrudedAreaSolid.getSweptArea() instanceof IfcRectangleProfileDef) {
                    IfcRectangleProfileDef ifcRectangleProfileDef = (IfcRectangleProfileDef)ifcExtrudedAreaSolid.getSweptArea();
                    Double d2 = ifcRectangleProfileDef.getXDim().value;
                    Double d3 = ifcRectangleProfileDef.getYDim().value;
                    IShape iShape = SpatialCreation.box((IScope)iScope, (double)d2, (double)d3, (double)d);
                    iShape.setAttribute("name", (Object)ifcSlab.getName().getDecodedValue());
                    axe.transform(iShape);
                    this.addAttribtutes((IfcProduct)ifcSlab, iShape);
                    this.getMaterial((IfcProduct)ifcSlab, iShape);
                    iShape = SpatialTransformations.translated_by((IScope)iScope, (IShape)iShape, (GamaPoint)new GamaPoint(0.0, 0.0, -d.doubleValue()));
                    return iShape;
                }
                if (!(ifcExtrudedAreaSolid.getSweptArea() instanceof IfcArbitraryClosedProfileDef)) continue;
                IfcArbitraryClosedProfileDef ifcArbitraryClosedProfileDef = (IfcArbitraryClosedProfileDef)ifcExtrudedAreaSolid.getSweptArea();
                IfcCurve ifcCurve = ifcArbitraryClosedProfileDef.getOuterCurve();
                if (ifcCurve instanceof IfcPolyline) {
                    IShape iShape = this.toGeom(iScope, (Collection<IfcCartesianPoint>)((IfcPolyline)ifcCurve).getPoints(), true);
                    iShape.setDepth(d.doubleValue());
                    iShape.setAttribute("name", (Object)ifcSlab.getName().getDecodedValue());
                    this.addAttribtutes((IfcProduct)ifcSlab, iShape);
                    axe.transform(iShape);
                    this.getMaterial((IfcProduct)ifcSlab, iShape);
                    return iShape;
                }
                return null;
            }
        }
        return null;
    }

    public IShape createSpace(IScope iScope, IfcSpace ifcSpace) {
        if (ifcSpace.getObjectPlacement() == null) {
            return null;
        }
        Axe axe = new Axe();
        ArrayList<IfcAxis2Placement> arrayList = new ArrayList<IfcAxis2Placement>();
        this.relatedTo(iScope, ifcSpace.getObjectPlacement(), arrayList);
        axe.update(arrayList, true);
        for (IfcRepresentation ifcRepresentation : ifcSpace.getRepresentation().getRepresentations()) {
            for (IfcRepresentationItem ifcRepresentationItem : ifcRepresentation.getItems()) {
                if (!(ifcRepresentationItem instanceof IfcExtrudedAreaSolid)) continue;
                IfcExtrudedAreaSolid ifcExtrudedAreaSolid = (IfcExtrudedAreaSolid)ifcRepresentationItem;
                if (ifcExtrudedAreaSolid.getPosition() != null) {
                    axe.update((IfcAxis2Placement)ifcExtrudedAreaSolid.getPosition());
                }
                Double d = ifcExtrudedAreaSolid.getDepth().value;
                if (ifcExtrudedAreaSolid.getSweptArea() instanceof IfcRectangleProfileDef) {
                    IfcRectangleProfileDef ifcRectangleProfileDef = (IfcRectangleProfileDef)ifcExtrudedAreaSolid.getSweptArea();
                    Double d2 = ifcRectangleProfileDef.getXDim().value;
                    Double d3 = ifcRectangleProfileDef.getYDim().value;
                    IShape iShape = SpatialCreation.box((IScope)iScope, (double)d2, (double)d3, (double)d);
                    iShape.setAttribute("name", (Object)ifcSpace.getName().getDecodedValue());
                    axe.transform(iShape);
                    this.addAttribtutes((IfcProduct)ifcSpace, iShape);
                    return iShape;
                }
                if (!(ifcExtrudedAreaSolid.getSweptArea() instanceof IfcArbitraryClosedProfileDef)) continue;
                IfcArbitraryClosedProfileDef ifcArbitraryClosedProfileDef = (IfcArbitraryClosedProfileDef)ifcExtrudedAreaSolid.getSweptArea();
                IfcCurve ifcCurve = ifcArbitraryClosedProfileDef.getOuterCurve();
                if (ifcCurve instanceof IfcPolyline) {
                    IShape iShape = this.toGeom(iScope, (Collection<IfcCartesianPoint>)((IfcPolyline)ifcCurve).getPoints(), true);
                    iShape.setDepth(d.doubleValue());
                    iShape.setAttribute("name", (Object)ifcSpace.getName().getDecodedValue());
                    axe.transform(iShape);
                    this.addAttribtutes((IfcProduct)ifcSpace, iShape);
                    return iShape;
                }
                return null;
            }
        }
        return null;
    }

    public void managePropertySet(IfcPropertySet ifcPropertySet, IShape iShape) {
        for (IfcProperty ifcProperty : ifcPropertySet.getHasProperties()) {
            if (!(ifcProperty instanceof IfcPropertySingleValue)) continue;
            iShape.setAttribute(ifcProperty.getName().getDecodedValue(), (Object)((IfcPropertySingleValue)ifcProperty).getNominalValue().toString());
        }
    }

    public void addAttribtutes(IfcProduct ifcProduct, IShape iShape) {
        iShape.setAttribute("type", (Object)ifcProduct.getClass().getSimpleName());
        if (ifcProduct.getIsDefinedBy_Inverse() == null) {
            return;
        }
        for (IfcRelDefines ifcRelDefines : ifcProduct.getIsDefinedBy_Inverse()) {
            IfcTypeObject ifcTypeObject;
            IfcRelDefinesByProperties ifcRelDefinesByProperties;
            if (ifcRelDefines instanceof IfcRelDefinesByProperties) {
                ifcRelDefinesByProperties = (IfcRelDefinesByProperties)ifcRelDefines;
                if (!(ifcRelDefinesByProperties.getRelatingPropertyDefinition() instanceof IfcPropertySet)) continue;
                this.managePropertySet((IfcPropertySet)ifcRelDefinesByProperties.getRelatingPropertyDefinition(), iShape);
                continue;
            }
            if (!(ifcRelDefines instanceof IfcRelDefinesByType) || (ifcRelDefinesByProperties = (IfcRelDefinesByType)ifcRelDefines).getRelatingType() == null || (ifcTypeObject = ifcRelDefinesByProperties.getRelatingType()).getHasPropertySets() == null) continue;
            for (IfcPropertySetDefinition ifcPropertySetDefinition : ifcTypeObject.getHasPropertySets()) {
                if (!(ifcPropertySetDefinition instanceof IfcPropertySet)) continue;
                this.managePropertySet((IfcPropertySet)ifcPropertySetDefinition, iShape);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void fillBuffer(IScope var1_1) throws GamaRuntimeException {
        block17: {
            if (this.getBuffer() != null) {
                return;
            }
            var2_2 = GamaListFactory.create((IType)Types.GEOMETRY);
            try {
                var3_3 = new IfcModel();
                var3_3.readStepFile(this.getFile(var1_1));
                break block17;
            }
            catch (Exception v0) {
                var3_4 = new ifc2x3javatoolbox.ifcmodel.IfcModel();
                try {
                    var3_4.readStepFile(this.getFile(var1_1));
                }
                catch (Exception var4_5) {
                    var4_5.printStackTrace();
                }
                var4_6 = new Hashtable<IfcProduct, Double>();
                var5_7 = var3_4.getCollection(IfcWall.class);
                ** for (var6_9 : var5_7)
            }
lbl-1000:
            // 1 sources

            {
                var8_10 = this.createWall(var1_1, (IfcWall)var6_9, var4_6);
                if (var8_10 == null) continue;
                var2_2.add(var8_10);
                continue;
            }
lbl23:
            // 1 sources

            var6_9 = var3_4.getCollection(IfcSlab.class);
            var7_8 = new HashMap<K, V>();
            for (Object var8_10 : var6_9) {
                var10_12 = this.createSlab(var1_1, (IfcSlab)var8_10);
                if (var10_12 == null) continue;
                var2_2.add(var10_12);
                var7_8.put(var8_10.toString(), var10_12);
            }
            var8_10 = var3_4.getCollection(IfcRoof.class);
            var10_12 = var8_10.iterator();
            while (var10_12.hasNext()) {
                var9_11 = (IfcRoof)var10_12.next();
                if (var9_11.getIsDecomposedBy_Inverse() == null || var9_11.getIsDefinedBy_Inverse() == null) continue;
                var11_13 = new Hashtable<K, V>();
                var11_13.put("roof_id", var9_11.getTag().getDecodedValue());
                var11_13.put("roof_name", var9_11.getName().getDecodedValue());
                for (Object var12_14 : var9_11.getIsDefinedBy_Inverse()) {
                    if (!(var12_14 instanceof IfcRelDefinesByProperties) || !((var14_16 = (IfcRelDefinesByProperties)var12_14).getRelatingPropertyDefinition() instanceof IfcPropertySet)) continue;
                    var15_17 = (IfcPropertySet)var14_16.getRelatingPropertyDefinition();
                    for (String var16_18 : var15_17.getHasProperties()) {
                        if (!(var16_18 instanceof IfcPropertySingleValue)) continue;
                        var11_13.put(var16_18.getName().getDecodedValue(), ((IfcPropertySingleValue)var16_18).getNominalValue().toString());
                    }
                }
                for (Object var12_14 : var9_11.getIsDecomposedBy_Inverse()) {
                    for (IShape var14_16 : var12_14.getRelatedObjects()) {
                        var16_18 = var14_16.toString();
                        var17_19 = (IShape)var7_8.get(var16_18);
                        if (var17_19 == null) continue;
                        for (String var18_20 : var11_13.keySet()) {
                            var17_19.setAttribute(var18_20, var11_13.get(var18_20));
                        }
                    }
                }
            }
            var9_11 = var3_4.getCollection(IfcSpace.class);
            var11_13 = var9_11.iterator();
            while (var11_13.hasNext()) {
                var10_12 = (IfcSpace)var11_13.next();
                var12_14 = this.createSpace(var1_1, (IfcSpace)var10_12);
                if (var12_14 == null) continue;
                var2_2.add(var12_14);
            }
            var10_12 = var3_4.getCollection(IfcOpeningElement.class);
            var12_14 = var10_12.iterator();
            while (var12_14.hasNext()) {
                var11_13 = (IfcOpeningElement)var12_14.next();
                var13_15 = this.createOpening(var1_1, (IfcOpeningElement)var11_13);
                if (var13_15 == null) continue;
                var2_2.add(var13_15);
            }
            var11_13 = var3_4.getCollection(IfcDoor.class);
            var13_15 = var11_13.iterator();
            while (var13_15.hasNext()) {
                var12_14 = (IfcDoor)var13_15.next();
                var14_16 = this.createDoor(var1_1, (IfcDoor)var12_14, var4_6);
                if (var14_16 == null) continue;
                var2_2.add((Object)var14_16);
            }
            var12_14 = var3_4.getCollection(IfcWindow.class);
            var14_16 = var12_14.iterator();
            while (var14_16.hasNext()) {
                var13_15 = (IfcWindow)var14_16.next();
                var15_17 = this.createWindow(var1_1, (IfcWindow)var13_15, var4_6);
                if (var15_17 == null) continue;
                var2_2.add((Object)var15_17);
            }
            this.setBuffer((IAddressableContainer)var2_2);
        }
    }

    public void relatedTo(IScope iScope, IfcObjectPlacement ifcObjectPlacement, List<IfcAxis2Placement> list) {
        if (ifcObjectPlacement instanceof IfcLocalPlacement) {
            IfcObjectPlacement ifcObjectPlacement2 = ((IfcLocalPlacement)ifcObjectPlacement).getPlacementRelTo();
            IfcAxis2Placement ifcAxis2Placement = ((IfcLocalPlacement)ifcObjectPlacement).getRelativePlacement();
            list.add(ifcAxis2Placement);
            if (ifcObjectPlacement2 != null) {
                this.relatedTo(iScope, ifcObjectPlacement2, list);
            }
        }
    }

    public Envelope3D computeEnvelope(IScope iScope) {
        boolean bl = false;
        if (this.getBuffer() == null) {
            this.fillBuffer(iScope);
            bl = true;
        }
        if (this.getBuffer() == null) {
            return null;
        }
        Envelope3D envelope3D = GeometryUtils.computeEnvelopeFrom((IScope)iScope, (Object)this.getBuffer());
        if (bl) {
            GamaPoint gamaPoint = new GamaPoint(-envelope3D.getMinX(), -envelope3D.getMinY(), -envelope3D.getMinZ());
            IList iList = GamaListFactory.create((IType)Types.GEOMETRY);
            for (IShape iShape : (IList)this.getBuffer()) {
                iList.add((Object)SpatialTransformations.translated_by((IScope)iScope, (IShape)iShape, (GamaPoint)gamaPoint));
            }
            this.setBuffer((IAddressableContainer)iList);
            envelope3D = envelope3D.translate(-envelope3D.getMinX(), -envelope3D.getMinY(), -envelope3D.getMinZ());
        }
        return envelope3D;
    }

    public class Axe {
        public GamaPoint origin;
        GamaPoint xDir;
        GamaPoint yDir;
        GamaPoint zDir;

        public Axe() {
            this.origin = new GamaPoint(0.0, 0.0, 0.0);
            this.xDir = new GamaPoint(1.0, 0.0, 0.0);
            this.yDir = new GamaPoint(0.0, 1.0, 0.0);
            this.zDir = new GamaPoint(0.0, 0.0, 1.0);
        }

        public Axe(Axe axe) {
            this.origin = new GamaPoint((Coordinate)axe.origin);
            this.xDir = new GamaPoint((Coordinate)axe.xDir);
            this.yDir = new GamaPoint((Coordinate)axe.yDir);
            this.zDir = new GamaPoint((Coordinate)axe.zDir);
        }

        public GamaPoint toNewRef(Coordinate coordinate, boolean bl) {
            GamaPoint gamaPoint = new GamaPoint();
            gamaPoint.x = coordinate.x * this.xDir.x + coordinate.y * this.yDir.x + coordinate.z * this.zDir.x;
            gamaPoint.y = coordinate.x * this.xDir.y + coordinate.y * this.yDir.y + coordinate.z * this.zDir.y;
            gamaPoint.z = coordinate.x * this.xDir.z + coordinate.y * this.yDir.z + coordinate.z * this.zDir.z;
            if (bl) {
                double d = Math.sqrt(gamaPoint.x * gamaPoint.x + gamaPoint.y * gamaPoint.y + gamaPoint.z * gamaPoint.z);
                gamaPoint.x /= d;
                gamaPoint.y /= d;
                gamaPoint.z /= d;
            }
            return gamaPoint;
        }

        public void addTranslation(GamaPoint gamaPoint) {
            GamaPoint gamaPoint2 = this.toNewRef((Coordinate)gamaPoint, false);
            this.origin.x += gamaPoint2.x;
            this.origin.y += gamaPoint2.y;
            this.origin.z += gamaPoint2.z;
        }

        public void addRotation(GamaPoint gamaPoint) {
            this.xDir = this.toNewRef((Coordinate)gamaPoint, true);
            this.yDir = SpatialTransformations.rotated_by((IScope)GAMA.getRuntimeScope(), (IShape)gamaPoint, (Integer)90).getLocation();
        }

        public void addRotation(GamaPoint gamaPoint, GamaPoint gamaPoint2) {
            this.xDir = this.toNewRef((Coordinate)gamaPoint, true);
            this.zDir = this.toNewRef((Coordinate)gamaPoint2, true);
            this.yDir = new GamaPoint(-1.0 * (this.xDir.y * this.zDir.z - this.xDir.z * this.zDir.y), -1.0 * (this.xDir.z * this.zDir.x - this.xDir.x * this.zDir.z), -1.0 * (this.xDir.x * this.zDir.y - this.xDir.y * this.zDir.x));
        }

        public void transform(IShape iShape) {
            iShape.getInnerGeometry().apply(coordinate -> {
                GamaPoint gamaPoint = this.toNewRef(coordinate, false);
                coordinate.x = gamaPoint.x + this.origin.x;
                coordinate.y = gamaPoint.y + this.origin.y;
                coordinate.z = gamaPoint.z + this.origin.z;
            });
        }

        public void update(List<IfcAxis2Placement> list, boolean bl) {
            if (bl) {
                Collections.reverse(list);
            }
            for (IfcAxis2Placement ifcAxis2Placement : list) {
                this.update(ifcAxis2Placement);
            }
        }

        public void update(IfcAxis2Placement ifcAxis2Placement) {
            if (ifcAxis2Placement instanceof IfcAxis2Placement2D) {
                IfcAxis2Placement2D ifcAxis2Placement2D = (IfcAxis2Placement2D)ifcAxis2Placement;
                GamaPoint gamaPoint = GamaIFCFile.this.toPoint(ifcAxis2Placement2D.getLocation());
                this.addTranslation(gamaPoint);
                if (ifcAxis2Placement2D.getRefDirection() != null) {
                    GamaPoint gamaPoint2 = GamaIFCFile.this.toPoint(ifcAxis2Placement2D.getRefDirection());
                    this.addRotation(gamaPoint2);
                }
            } else if (ifcAxis2Placement instanceof IfcAxis2Placement3D) {
                IfcAxis2Placement3D ifcAxis2Placement3D = (IfcAxis2Placement3D)ifcAxis2Placement;
                GamaPoint gamaPoint = GamaIFCFile.this.toPoint(ifcAxis2Placement3D.getLocation());
                this.addTranslation(gamaPoint);
                if (ifcAxis2Placement3D.getRefDirection() != null) {
                    GamaPoint gamaPoint3 = GamaIFCFile.this.toPoint(ifcAxis2Placement3D.getRefDirection());
                    GamaPoint gamaPoint4 = GamaIFCFile.this.toPoint(ifcAxis2Placement3D.getAxis());
                    this.addRotation(gamaPoint3, gamaPoint4);
                }
            }
        }

        public String toString() {
            return "Axe [origin=" + String.valueOf(this.origin) + ", xDir=" + String.valueOf(this.xDir) + ", yDir=" + String.valueOf(this.yDir) + ", zDir=" + String.valueOf(this.zDir) + "]";
        }
    }
}

