/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.imageanalysis.boofcv;

import boofcv.abst.distort.FDistort;
import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.interpolate.InterpolationType;
import boofcv.alg.misc.ImageStatistics;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.image.ShowImages;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.ConfigLength;
import boofcv.struct.ConnectRule;
import boofcv.struct.distort.Point2Transform2_F32;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import gama.experimental.imageanalysis.boofcv.PointTransformHomography_F32;
import georegression.struct.homography.Homography2D_F32;
import georegression.struct.point.Point2D_F64;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.FMatrix;
import org.ejml.ops.ConvertMatrixData;

public class RemovePerspectiveDistortion<T extends ImageBase<T>> {
    FDistort distort;
    Estimate1ofEpipolar computeHomography = FactoryMultiView.homographyDLT((boolean)true);
    DMatrixRMaj H = new DMatrixRMaj(3, 3);
    Homography2D_F32 H32 = new Homography2D_F32();
    PointTransformHomography_F32 transform = new PointTransformHomography_F32();
    ArrayList<AssociatedPair> associatedPairs = new ArrayList();
    T output;

    public RemovePerspectiveDistortion(int n, int n2, ImageType<T> imageType) {
        this(n, n2);
        this.output = imageType.createImage(n, n2);
        this.distort = new FDistort(imageType);
        this.distort.output(this.output);
        this.distort.interp(InterpolationType.BILINEAR).transform((Point2Transform2_F32)this.transform);
    }

    public RemovePerspectiveDistortion(int n, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            this.associatedPairs.add(new AssociatedPair());
            ++n3;
        }
        this.associatedPairs.get((int)0).p1.setTo(0.0, 0.0);
        this.associatedPairs.get((int)1).p1.setTo((double)n, 0.0);
        this.associatedPairs.get((int)2).p1.setTo((double)n, (double)n2);
        this.associatedPairs.get((int)3).p1.setTo(0.0, (double)n2);
    }

    public boolean apply(T t, Point2D_F64 point2D_F64, Point2D_F64 point2D_F642, Point2D_F64 point2D_F643, Point2D_F64 point2D_F644) {
        if (this.createTransform(point2D_F64, point2D_F642, point2D_F643, point2D_F644)) {
            this.distort.input(t).apply();
            return true;
        }
        return false;
    }

    public boolean createTransform(Point2D_F64 point2D_F64, Point2D_F64 point2D_F642, Point2D_F64 point2D_F643, Point2D_F64 point2D_F644) {
        this.associatedPairs.get((int)0).p2.setTo(point2D_F64);
        this.associatedPairs.get((int)1).p2.setTo(point2D_F642);
        this.associatedPairs.get((int)2).p2.setTo(point2D_F643);
        this.associatedPairs.get((int)3).p2.setTo(point2D_F644);
        if (!this.computeHomography.process(this.associatedPairs, (Object)this.H)) {
            return false;
        }
        ConvertMatrixData.convert((DMatrix)this.H, (FMatrix)this.H32);
        this.transform.set(this.H32);
        return true;
    }

    public DMatrixRMaj getH() {
        return this.H;
    }

    public PointTransformHomography_F32 getTransform() {
        return this.transform;
    }

    public T getOutput() {
        return this.output;
    }

    public static void main(String[] stringArray) {
        BufferedImage bufferedImage = UtilImageIO.loadImageNotNull((String)"C:\\Users\\admin_ptaillandie\\Documents\\GitHub\\gama.experimental\\gama.experimental.imageanalysis\\src\\across\\gaml\\extensions\\imageanalysis\\operators\\real_map_sharpened.jpg");
        GrayF32 grayF32 = (GrayF32)ConvertBufferedImage.convertFromSingle((BufferedImage)bufferedImage, null, GrayF32.class);
        GrayU8 grayU8 = new GrayU8(grayF32.width, grayF32.height);
        ListDisplayPanel listDisplayPanel = new ListDisplayPanel();
        GThresholdImageOps.threshold((ImageGray)grayF32, (GrayU8)grayU8, (double)ImageStatistics.mean((GrayF32)grayF32), (boolean)true);
        listDisplayPanel.addImage(VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null), "Global: Mean");
        GThresholdImageOps.threshold((ImageGray)grayF32, (GrayU8)grayU8, (double)GThresholdImageOps.computeOtsu((ImageGray)grayF32, (double)0.0, (double)255.0), (boolean)true);
        listDisplayPanel.addImage(VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null), "Global: Otsu");
        GThresholdImageOps.threshold((ImageGray)grayF32, (GrayU8)grayU8, (double)GThresholdImageOps.computeEntropy((ImageGray)grayF32, (double)0.0, (double)255.0), (boolean)true);
        listDisplayPanel.addImage(VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null), "Global: Entropy");
        GThresholdImageOps.localMean((ImageGray)grayF32, (GrayU8)grayU8, (ConfigLength)ConfigLength.fixed((double)57.0), (double)1.0, (boolean)true, null, null, null);
        listDisplayPanel.addImage(VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null), "Local: Mean");
        GThresholdImageOps.localGaussian((ImageGray)grayF32, (GrayU8)grayU8, (ConfigLength)ConfigLength.fixed((double)85.0), (double)1.0, (boolean)true, null, null);
        listDisplayPanel.addImage(VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null), "Local: Gaussian");
        GThresholdImageOps.localNiblack((ImageGray)grayF32, (GrayU8)grayU8, (ConfigLength)ConfigLength.fixed((double)11.0), (float)0.3f, (boolean)true);
        listDisplayPanel.addImage(VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null), "Local: Niblack");
        GThresholdImageOps.localSauvola((ImageGray)grayF32, (GrayU8)grayU8, (ConfigLength)ConfigLength.fixed((double)11.0), (float)0.3f, (boolean)true);
        listDisplayPanel.addImage(VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null), "Local: Sauvola");
        GThresholdImageOps.localWolf((ImageGray)grayF32, (GrayU8)grayU8, (ConfigLength)ConfigLength.fixed((double)11.0), (float)0.3f, (boolean)true);
        listDisplayPanel.addImage(VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null), "Local: Wolf");
        GThresholdImageOps.localNick((ImageGray)grayF32, (GrayU8)grayU8, (ConfigLength)ConfigLength.fixed((double)11.0), (float)-0.2f, (boolean)true);
        listDisplayPanel.addImage(VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null), "Local: NICK");
        GThresholdImageOps.blockMinMax((ImageGray)grayF32, (GrayU8)grayU8, (ConfigLength)ConfigLength.fixed((double)21.0), (double)1.0, (boolean)true, (double)15.0);
        listDisplayPanel.addImage(VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null), "Block: Min-Max");
        GThresholdImageOps.blockMean((ImageGray)grayF32, (GrayU8)grayU8, (ConfigLength)ConfigLength.fixed((double)21.0), (double)1.0, (boolean)true);
        listDisplayPanel.addImage(VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null), "Block: Mean");
        GThresholdImageOps.blockOtsu((ImageGray)grayF32, (GrayU8)grayU8, (boolean)false, (ConfigLength)ConfigLength.fixed((double)21.0), (double)0.5, (double)1.0, (boolean)true);
        listDisplayPanel.addImage(VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null), "Block: Otsu");
        listDisplayPanel.addImage(ConvertBufferedImage.convertTo((GrayF32)grayF32, null), "Input Image");
        String string = "ttt";
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        GrayF32 grayF322 = (GrayF32)ConvertBufferedImage.convertFromSingle((BufferedImage)bufferedImage, null, GrayF32.class);
        GrayS32 grayS32 = new GrayS32(grayF322.width, grayF322.height);
        double d = GThresholdImageOps.computeOtsu((ImageGray)grayF322, (double)0.0, (double)255.0);
        ThresholdImageOps.threshold((GrayF32)grayF322, (GrayU8)grayU8, (float)((float)d), (boolean)true);
        GrayU8 grayU82 = BinaryImageOps.erode8((GrayU8)grayU8, (int)1, null);
        grayU82 = BinaryImageOps.dilate8((GrayU8)grayU82, (int)1, null);
        List list = BinaryImageOps.contour((GrayU8)grayU82, (ConnectRule)ConnectRule.EIGHT, (GrayS32)grayS32);
        int n = 0xFFFFFF;
        int n2 = 0xFF2020;
        BufferedImage bufferedImage2 = VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null);
        BufferedImage bufferedImage3 = VisualizeBinaryData.renderBinary((GrayU8)grayU82, (boolean)false, null);
        BufferedImage bufferedImage4 = VisualizeBinaryData.renderLabeledBG((GrayS32)grayS32, (int)list.size(), null);
        BufferedImage bufferedImage5 = VisualizeBinaryData.renderContours((List)list, (int)n, (int)n2, (int)grayF322.width, (int)grayF322.height, null);
        listDisplayPanel.addImage(bufferedImage2, "Binary Original");
        listDisplayPanel.addImage(bufferedImage3, "Binary Filtered");
        listDisplayPanel.addImage(bufferedImage4, "Labeled Blobs");
        listDisplayPanel.addImage(bufferedImage5, "Contours");
        ShowImages.showWindow((JComponent)listDisplayPanel, (String)string2);
    }
}

