/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.imageanalysis.operators;

import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.matrix.GamaIntMatrix;
import gama.core.util.matrix.IMatrix;
import gama.experimental.imageanalysis.operators.PatternMatching;
import gama.experimental.webcam.operators.WebcamOperators;
import gama.gaml.operators.spatial.SpatialCreation;
import georegression.struct.point.Point2D_I32;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.List;

public class GeneralOperators {
    @GamlAnnotations.operator(value={"remove_perspective"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="remove the perspective from an image using 4 reference points (top-left, top-right, bottom-right, bottom-left)")
    public static IMatrix removePerspective(IScope iScope, IMatrix iMatrix, IList<GamaPoint> iList) {
        return WebcamOperators.matrixValueFromImage((IScope)iScope, (BufferedImage)PatternMatching.removeDistortion(iScope, iList, GamaIntMatrix.constructBufferedImageFromMatrix((IScope)iScope, (IMatrix)iMatrix)));
    }

    @GamlAnnotations.operator(value={"to_binary_image"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="remove the perspective from an image using 4 reference points (top-left, top-right, bottom-right, bottom-left)")
    public static IMatrix removePerspective(IScope iScope, IMatrix iMatrix, double d) {
        BufferedImage bufferedImage = GamaIntMatrix.constructBufferedImageFromMatrix((IScope)iScope, (IMatrix)iMatrix);
        GrayF32 grayF32 = (GrayF32)ConvertBufferedImage.convertFromSingle((BufferedImage)bufferedImage, null, GrayF32.class);
        GrayU8 grayU8 = new GrayU8(grayF32.width, grayF32.height);
        ThresholdImageOps.threshold((GrayF32)grayF32, (GrayU8)grayU8, (float)((float)d), (boolean)true);
        GrayU8 grayU82 = BinaryImageOps.erode8((GrayU8)grayU8, (int)1, null);
        grayU82 = BinaryImageOps.dilate8((GrayU8)grayU82, (int)1, null);
        return WebcamOperators.matrixValueFromImage((IScope)iScope, (BufferedImage)VisualizeBinaryData.renderBinary((GrayU8)grayU82, (boolean)false, null));
    }

    @GamlAnnotations.operator(value={"huang_threshold"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="Compute the Huang Threshold from the image")
    public static Double computeHuang(IScope iScope, IMatrix iMatrix) {
        BufferedImage bufferedImage = GamaIntMatrix.constructBufferedImageFromMatrix((IScope)iScope, (IMatrix)iMatrix);
        GrayF32 grayF32 = (GrayF32)ConvertBufferedImage.convertFromSingle((BufferedImage)bufferedImage, null, GrayF32.class);
        return GThresholdImageOps.computeHuang((ImageGray)grayF32, (double)0.0, (double)255.0);
    }

    @GamlAnnotations.operator(value={"entropy_threshold"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="Compute the Entropy Threshold from the image")
    public static Double computeEntropy(IScope iScope, IMatrix iMatrix) {
        BufferedImage bufferedImage = GamaIntMatrix.constructBufferedImageFromMatrix((IScope)iScope, (IMatrix)iMatrix);
        GrayF32 grayF32 = (GrayF32)ConvertBufferedImage.convertFromSingle((BufferedImage)bufferedImage, null, GrayF32.class);
        return GThresholdImageOps.computeEntropy((ImageGray)grayF32, (double)0.0, (double)255.0);
    }

    @GamlAnnotations.operator(value={"otsu_threshold"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="Compute the Otsu Threshold from the image")
    public static Double computeOtsu(IScope iScope, IMatrix iMatrix) {
        BufferedImage bufferedImage = GamaIntMatrix.constructBufferedImageFromMatrix((IScope)iScope, (IMatrix)iMatrix);
        GrayF32 grayF32 = (GrayF32)ConvertBufferedImage.convertFromSingle((BufferedImage)bufferedImage, null, GrayF32.class);
        return GThresholdImageOps.computeOtsu((ImageGray)grayF32, (double)0.0, (double)255.0);
    }

    @GamlAnnotations.operator(value={"li_threshold"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="Compute the Li Threshold from the image")
    public static Double computeLi(IScope iScope, IMatrix iMatrix) {
        BufferedImage bufferedImage = GamaIntMatrix.constructBufferedImageFromMatrix((IScope)iScope, (IMatrix)iMatrix);
        GrayF32 grayF32 = (GrayF32)ConvertBufferedImage.convertFromSingle((BufferedImage)bufferedImage, null, GrayF32.class);
        return GThresholdImageOps.computeLi((ImageGray)grayF32, (double)0.0, (double)255.0);
    }

    @GamlAnnotations.operator(value={"to_binary_image"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="return a binary image using the given threshold")
    public static IMatrix toBinaryImage(IScope iScope, IMatrix iMatrix, Double d) {
        BufferedImage bufferedImage = GamaIntMatrix.constructBufferedImageFromMatrix((IScope)iScope, (IMatrix)iMatrix);
        GrayF32 grayF32 = (GrayF32)ConvertBufferedImage.convertFromSingle((BufferedImage)bufferedImage, null, GrayF32.class);
        GrayU8 grayU8 = new GrayU8(grayF32.width, grayF32.height);
        ThresholdImageOps.threshold((GrayF32)grayF32, (GrayU8)grayU8, (float)d.floatValue(), (boolean)true);
        GrayU8 grayU82 = BinaryImageOps.erode8((GrayU8)grayU8, (int)1, null);
        grayU82 = BinaryImageOps.dilate8((GrayU8)grayU82, (int)1, null);
        return WebcamOperators.matrixValueFromImage((IScope)iScope, (BufferedImage)VisualizeBinaryData.renderBinary((GrayU8)grayU82, (boolean)false, null));
    }

    @GamlAnnotations.operator(value={"detect_contours"}, can_be_const=false, category={"List-related operators"})
    @GamlAnnotations.doc(value="returns vector lines from the image")
    public static IMatrix tes1(IScope iScope, IMatrix iMatrix) {
        BufferedImage bufferedImage = GamaIntMatrix.constructBufferedImageFromMatrix((IScope)iScope, (IMatrix)iMatrix);
        GrayF32 grayF32 = (GrayF32)ConvertBufferedImage.convertFromSingle((BufferedImage)bufferedImage, null, GrayF32.class);
        GrayU8 grayU8 = new GrayU8(grayF32.width, grayF32.height);
        GrayS32 grayS32 = new GrayS32(grayF32.width, grayF32.height);
        double d = GThresholdImageOps.computeOtsu((ImageGray)grayF32, (double)0.0, (double)255.0);
        ThresholdImageOps.threshold((GrayF32)grayF32, (GrayU8)grayU8, (float)((float)d), (boolean)true);
        GrayU8 grayU82 = BinaryImageOps.erode8((GrayU8)grayU8, (int)1, null);
        grayU82 = BinaryImageOps.dilate8((GrayU8)grayU82, (int)1, null);
        List list = BinaryImageOps.contour((GrayU8)grayU82, (ConnectRule)ConnectRule.EIGHT, (GrayS32)grayS32);
        int n = 0xFFFFFF;
        int n2 = 0xFF2020;
        VisualizeBinaryData.renderBinary((GrayU8)grayU8, (boolean)false, null);
        VisualizeBinaryData.renderBinary((GrayU8)grayU82, (boolean)false, null);
        VisualizeBinaryData.renderLabeledBG((GrayS32)grayS32, (int)list.size(), null);
        BufferedImage bufferedImage2 = VisualizeBinaryData.renderContours((List)list, (int)n, (int)n2, (int)grayF32.width, (int)grayF32.height, null);
        return WebcamOperators.matrixValueFromImage((IScope)iScope, (BufferedImage)bufferedImage2);
    }

    @GamlAnnotations.operator(value={"vectorize"}, can_be_const=false, content_type=13, category={"List-related operators"})
    @GamlAnnotations.doc(value="returns vector lines from the image")
    public static IList<IShape> vectorizeImage(IScope iScope, IMatrix iMatrix) {
        IList iList = GamaListFactory.create();
        BufferedImage bufferedImage = GamaIntMatrix.constructBufferedImageFromMatrix((IScope)iScope, (IMatrix)iMatrix);
        GrayF32 grayF32 = (GrayF32)ConvertBufferedImage.convertFromSingle((BufferedImage)bufferedImage, null, GrayF32.class);
        GrayU8 grayU8 = new GrayU8(grayF32.width, grayF32.height);
        new BufferedImage(grayF32.width, grayF32.height, 1);
        double d = ImageStatistics.mean((GrayF32)grayF32);
        ThresholdImageOps.threshold((GrayF32)grayF32, (GrayU8)grayU8, (float)((float)d), (boolean)true);
        GrayU8 grayU82 = BinaryImageOps.erode8((GrayU8)grayU8, (int)1, null);
        grayU82 = BinaryImageOps.dilate8((GrayU8)grayU82, (int)1, null);
        List list = BinaryImageOps.contour((GrayU8)grayU82, (ConnectRule)ConnectRule.EIGHT, null);
        double d2 = iScope.getSimulation().getWidth() / (double)iMatrix.getCols(iScope);
        double d3 = iScope.getSimulation().getHeight() / (double)iMatrix.getRows(iScope);
        for (Contour contour : list) {
            IList iList2 = GamaListFactory.create();
            for (Object object : contour.external) {
                iList2.add((Object)new GamaPoint((double)((Point2D_I32)object).x * d2, (double)((Point2D_I32)object).y * d3));
            }
            if (!iList2.isEmpty()) {
                iList.add((Object)SpatialCreation.line((IScope)iScope, (IContainer)iList2));
            }
            for (Object object : contour.internal) {
                IList iList3 = GamaListFactory.create();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Point2D_I32 point2D_I32 = (Point2D_I32)iterator.next();
                    iList3.add((Object)new GamaPoint((double)point2D_I32.x * d2, (double)point2D_I32.y * d3));
                }
                if (iList3.isEmpty()) continue;
                iList.add((Object)SpatialCreation.line((IScope)iScope, (IContainer)iList3));
            }
        }
        return iList;
    }
}

