/*
 * Decompiled with CFR 0.152.
 */
package gama.experimental.launchpad.skills;

import gama.core.common.interfaces.IDisplaySurface;
import gama.core.common.interfaces.IEventLayerDelegate;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.ILayer;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.outputs.layers.EventLayerStatement;
import gama.core.outputs.layers.ILayerData;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.outputs.layers.LayerData;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.IStatement;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.thecodersbreakfast.lp4j.api.BackBufferOperation;
import net.thecodersbreakfast.lp4j.api.Button;
import net.thecodersbreakfast.lp4j.api.Color;
import net.thecodersbreakfast.lp4j.api.Launchpad;
import net.thecodersbreakfast.lp4j.api.LaunchpadClient;
import net.thecodersbreakfast.lp4j.api.LaunchpadListenerAdapter;
import net.thecodersbreakfast.lp4j.api.Pad;
import net.thecodersbreakfast.lp4j.midi.MidiDeviceConfiguration;
import net.thecodersbreakfast.lp4j.midi.MidiLaunchpad;

public class LaunchPadEventLayer
implements ILayer,
IEventLayerDelegate {
    MyLPListener myListener = null;
    IScope executionScope = null;
    public static final Set<String> EVENTS = new HashSet<String>(Arrays.asList("pad_down"));
    public static HashMap<String, Color> colorMap = new HashMap<String, Color>(){
        {
            this.put("black", Color.BLACK);
            this.put("red", Color.RED);
            this.put("darkred", Color.DARKRED);
            this.put("green", Color.GREEN);
            this.put("darkgreen", Color.DARKGREEN);
            this.put("orange", Color.ORANGE);
            this.put("brown", Color.BROWN);
            this.put("yellow", Color.YELLOW);
            this.put("lightyellow", Color.LIGHTYELLOW);
        }
    };
    protected ILayerStatement definition;
    private String name;
    boolean hasBeenDrawnOnce = false;
    private ILayerData data = null;
    public static boolean launch = false;
    Launchpad launchpad;
    public static LaunchpadClient client;
    public static Pad pressedPad;
    public static Button pressedButton;

    public LaunchPadEventLayer() {
        this.definition = null;
    }

    public LaunchPadEventLayer(ILayerStatement iLayerStatement) {
        this.definition = iLayerStatement;
        if (this.definition != null) {
            this.setName(this.definition.getName());
        }
        this.data = this.createData();
    }

    public void disableOn(IDisplaySurface iDisplaySurface) {
    }

    public void firstLaunchOn(IDisplaySurface iDisplaySurface) {
        launch = true;
        try {
            System.out.println("LaunchPad launched");
            this.launchpad = new MidiLaunchpad(MidiDeviceConfiguration.autodetect());
            client = this.launchpad.getClient();
            this.myListener = new MyLPListener(client);
            this.launchpad.setListener(this.myListener);
            client.reset();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dispose() {
        try {
            client.reset();
            this.launchpad.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public String getType() {
        return "Event layer";
    }

    private void executeEvent() {
        IStatement.WithArgs withArgs;
        SimulationAgent simulationAgent = ((EventLayerStatement)this.definition).executesInSimulation() ? this.executionScope.getSimulation() : this.executionScope.getExperiment();
        String string = ((EventLayerStatement)this.definition).getFacet(new String[]{"action"}).toString();
        IStatement.WithArgs withArgs2 = withArgs = simulationAgent == null ? null : simulationAgent.getSpecies().getAction(string);
        if (withArgs == null) {
            return;
        }
        this.executionScope.execute((IExecutable)withArgs, (IAgent)simulationAgent, null);
    }

    public ILayerStatement getDefinition() {
        return this.definition;
    }

    public ILayerData getData() {
        return this.data;
    }

    protected ILayerData createData() {
        return new LayerData(this.definition);
    }

    public void forceRedrawingOnce() {
        this.hasBeenDrawnOnce = false;
    }

    public void draw(IScope.IGraphicsScope iGraphicsScope, IGraphics iGraphics) throws GamaRuntimeException {
        if (!iGraphics.is2D() && !this.getData().isDynamic() && this.hasBeenDrawnOnce) {
            return;
        }
        if (iGraphics.isNotReadyToUpdate() && this.hasBeenDrawnOnce) {
            return;
        }
        this.getData().compute((IScope)iGraphicsScope, iGraphics);
        iGraphics.setAlpha(this.getData().getTransparency((IScope)iGraphicsScope).doubleValue());
        iGraphics.beginDrawingLayer((ILayer)this);
        iGraphics.endDrawingLayer((ILayer)this);
        this.hasBeenDrawnOnce = true;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public boolean acceptSource(IScope iScope, Object object) {
        return object.equals("launchpad");
    }

    public boolean createFrom(IScope iScope, Object object, EventLayerStatement eventLayerStatement) {
        this.executionScope = iScope;
        System.out.println("LAUNCHPAD event layer delegate " + String.valueOf(eventLayerStatement.getFacetValue(iScope, "action")));
        if (!launch) {
            this.definition = eventLayerStatement;
            this.firstLaunchOn(null);
        }
        return false;
    }

    public Set<String> getEvents() {
        return EVENTS;
    }

    public class MyLPListener
    extends LaunchpadListenerAdapter {
        private final LaunchpadClient client;

        public MyLPListener(LaunchpadClient launchpadClient) {
            this.client = launchpadClient;
        }

        @Override
        public void onPadPressed(Pad pad, long l) {
            this.client.setPadLight(pad, Color.YELLOW, BackBufferOperation.NONE);
            pressedPad = pad;
        }

        @Override
        public void onPadReleased(Pad pad, long l) {
            this.client.setPadLight(pad, Color.BLACK, BackBufferOperation.NONE);
            pressedPad = pad;
            LaunchPadEventLayer.this.executeEvent();
        }

        @Override
        public void onButtonPressed(Button button, long l) {
            pressedButton = button;
        }

        @Override
        public void onButtonReleased(Button button, long l) {
            pressedButton = button;
        }
    }
}

