/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.api;

public final class Brightness {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 15;
    private static final Brightness[] CACHE = new Brightness[16];
    public static final Brightness BRIGHTNESS_MIN;
    public static final Brightness BRIGHTNESS_MAX;
    private final int brightness;

    static {
        int n = 0;
        while (n < 16) {
            Brightness.CACHE[n] = new Brightness(n);
            ++n;
        }
        BRIGHTNESS_MIN = Brightness.of(0);
        BRIGHTNESS_MAX = Brightness.of(15);
    }

    public static Brightness of(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Invalid brightness level : " + n + ". Acceptable values are in range [0..15].");
        }
        return CACHE[n - 0];
    }

    private Brightness(int n) {
        this.brightness = n;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public Brightness more() {
        return this.brightness < 15 ? Brightness.of(this.brightness + 1) : this;
    }

    public Brightness less() {
        return this.brightness > 0 ? Brightness.of(this.brightness - 1) : this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Brightness brightness = (Brightness)object;
        return this.brightness == brightness.brightness;
    }

    public int hashCode() {
        return this.brightness;
    }
}

