/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.api;

public class Pad {
    public static final int X_MIN = 0;
    public static final int X_MAX = 7;
    public static final int Y_MIN = 0;
    public static final int Y_MAX = 7;
    private static final Pad[][] PADS = new Pad[8][8];
    private final int x;
    private final int y;

    static {
        int n = 0;
        while (n <= 7) {
            int n2 = 0;
            while (n2 <= 7) {
                Pad.PADS[n][n2] = new Pad(n, n2);
                ++n2;
            }
            ++n;
        }
    }

    public static Pad at(int n, int n2) {
        if (n < 0 || n > 7 || n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("Illegal pad coordinates : (" + n + "," + n2 + "). Acceptable values are in [0..7] on both axis.");
        }
        return PADS[n][n2];
    }

    private Pad(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Pad pad = (Pad)object;
        return this.x == pad.x && this.y == pad.y;
    }

    public int hashCode() {
        int n = this.x;
        n = 31 * n + this.y;
        return n;
    }

    public String toString() {
        return "Pad[" + this.x + "," + this.y + "]";
    }
}

