/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.api;

public class ScrollSpeed {
    public static final int MIN_VALUE = 1;
    public static final int MAX_VALUE = 7;
    private static final ScrollSpeed[] CACHE = new ScrollSpeed[7];
    public static final ScrollSpeed SPEED_MIN;
    public static final ScrollSpeed SPEED_MAX;
    private final int scrollSpeed;

    static {
        int n = 1;
        while (n <= 7) {
            ScrollSpeed.CACHE[n - 1] = new ScrollSpeed(n);
            ++n;
        }
        SPEED_MIN = ScrollSpeed.of(1);
        SPEED_MAX = ScrollSpeed.of(7);
    }

    public static ScrollSpeed of(int n) {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("Invalid speed value : " + n + ". Acceptable values are in range [1..7].");
        }
        return CACHE[n - 1];
    }

    private ScrollSpeed(int n) {
        this.scrollSpeed = n;
    }

    public int getScrollSpeed() {
        return this.scrollSpeed;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScrollSpeed scrollSpeed = (ScrollSpeed)object;
        return this.scrollSpeed == scrollSpeed.scrollSpeed;
    }

    public int hashCode() {
        return this.scrollSpeed;
    }
}

