/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.emulator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.thecodersbreakfast.lp4j.api.Button;
import net.thecodersbreakfast.lp4j.api.Launchpad;
import net.thecodersbreakfast.lp4j.api.LaunchpadClient;
import net.thecodersbreakfast.lp4j.api.LaunchpadListener;
import net.thecodersbreakfast.lp4j.api.Pad;
import net.thecodersbreakfast.lp4j.emulator.EmulatorLaunchpadClient;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.VertxFactory;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;

public class EmulatorLaunchpad
implements Launchpad {
    public static final String WEB_RESOURCES_PREFIX = "/web";
    public static final String EVENTBUS_ADDRESS = "/eventbus";
    public static final String EVENTBUS_SERVER_HANDLER_ID = "lp4j:server";
    private final EventBusHandler eventBusHandler = new EventBusHandler();
    private final Vertx vertx = VertxFactory.newVertx();

    public EmulatorLaunchpad(int n) {
        HttpServer httpServer = this.vertx.createHttpServer();
        httpServer.requestHandler((Handler)new WebResourceHandler());
        JsonObject jsonObject = new JsonObject().putString("prefix", EVENTBUS_ADDRESS);
        JsonArray jsonArray = new JsonArray().add((Object)new JsonObject());
        this.vertx.createSockJSServer(httpServer).bridge(jsonObject, jsonArray, jsonArray);
        this.vertx.eventBus().registerLocalHandler(EVENTBUS_SERVER_HANDLER_ID, (Handler)this.eventBusHandler);
        System.out.println("Launchpad emulator is ready on http://localhost:" + n + "/");
        httpServer.listen(n);
    }

    @Override
    public LaunchpadClient getClient() {
        return new EmulatorLaunchpadClient(this.vertx);
    }

    @Override
    public void setListener(LaunchpadListener launchpadListener) {
        this.eventBusHandler.setListener(launchpadListener);
    }

    @Override
    public void close() throws IOException {
        this.vertx.stop();
    }

    private static class EventBusHandler
    implements Handler<Message> {
        private LaunchpadListener listener;

        private EventBusHandler() {
        }

        public void handle(Message message) {
            if (this.listener == null) {
                return;
            }
            long l = System.currentTimeMillis();
            JsonObject jsonObject = (JsonObject)message.body();
            InputEventType inputEventType = InputEventType.valueOf(jsonObject.getString("evt"));
            switch (inputEventType) {
                case PP: {
                    Integer n = jsonObject.getInteger("x");
                    Integer n2 = jsonObject.getInteger("y");
                    this.listener.onPadPressed(Pad.at(n, n2), l);
                    break;
                }
                case PR: {
                    Integer n = jsonObject.getInteger("x");
                    Integer n3 = jsonObject.getInteger("y");
                    this.listener.onPadReleased(Pad.at(n, n3), l);
                    break;
                }
                case BP: {
                    int n = jsonObject.getInteger("x");
                    int n4 = jsonObject.getInteger("y");
                    int n5 = n == -1 ? n4 : n;
                    Button button = n != -1 ? Button.atTop(n5) : Button.atRight(n5);
                    this.listener.onButtonPressed(button, l);
                    break;
                }
                case BR: {
                    int n = jsonObject.getInteger("x");
                    int n6 = jsonObject.getInteger("y");
                    int n7 = n == -1 ? n6 : n;
                    Button button = n != -1 ? Button.atTop(n7) : Button.atRight(n7);
                    this.listener.onButtonReleased(button, l);
                    break;
                }
                case TS: {
                    this.listener.onTextScrolled(l);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown input event type " + inputEventType.name());
                }
            }
        }

        public void setListener(LaunchpadListener launchpadListener) {
            this.listener = launchpadListener;
        }

        private static enum InputEventType {
            PP,
            PR,
            BP,
            BR,
            TS;

        }
    }

    private static class WebResourceHandler
    implements Handler<HttpServerRequest> {
        private WebResourceHandler() {
        }

        public void handle(HttpServerRequest httpServerRequest) {
            String string = httpServerRequest.path();
            HttpServerResponse httpServerResponse = httpServerRequest.response();
            if (this.shouldRedirectToIndexHtml(string)) {
                this.redirectToIndexHtml(httpServerResponse);
                return;
            }
            if (!this.isLegalResource(string)) {
                this.sendResponseForbidden(httpServerResponse);
                return;
            }
            if (!this.writeResourceToResponse(httpServerResponse, string)) {
                this.sendResponseNotFound(httpServerResponse);
            }
        }

        private boolean shouldRedirectToIndexHtml(String string) {
            return "/".equals(string);
        }

        private void redirectToIndexHtml(HttpServerResponse httpServerResponse) {
            httpServerResponse.headers().add("Location", "/web/index.html");
            httpServerResponse.setStatusCode(301).end();
        }

        private boolean isLegalResource(String string) {
            return string.startsWith(EmulatorLaunchpad.WEB_RESOURCES_PREFIX);
        }

        private void sendResponseForbidden(HttpServerResponse httpServerResponse) {
            httpServerResponse.setStatusCode(403).end();
        }

        private void setResponseContentType(HttpServerResponse httpServerResponse, String string) {
            String string2 = this.findContentType(string);
            httpServerResponse.headers().add("Content-Type", string2);
        }

        private String findContentType(String string) {
            if (string.endsWith(".js")) {
                return "application/javascript";
            }
            return "text/html";
        }

        private boolean writeResourceToResponse(HttpServerResponse httpServerResponse, String string) {
            this.setResponseContentType(httpServerResponse, string);
            byte[] byArray = WebResourceHandler.readResource(string);
            if (byArray == null) {
                return false;
            }
            Buffer buffer = new Buffer(byArray);
            httpServerResponse.end(buffer);
            return true;
        }

        private static byte[] readResource(String string) {
            InputStream inputStream;
            block4: {
                inputStream = EmulatorLaunchpad.class.getResourceAsStream(string);
                if (inputStream != null) break block4;
                return null;
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n = inputStream.read();
                while (n != -1) {
                    byteArrayOutputStream.write(n);
                    n = inputStream.read();
                }
                return byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }

        private void sendResponseNotFound(HttpServerResponse httpServerResponse) {
            httpServerResponse.setStatusCode(404).end();
        }
    }
}

