/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.emulator;

import net.thecodersbreakfast.lp4j.api.BackBufferOperation;
import net.thecodersbreakfast.lp4j.api.Brightness;
import net.thecodersbreakfast.lp4j.api.Buffer;
import net.thecodersbreakfast.lp4j.api.Button;
import net.thecodersbreakfast.lp4j.api.Color;
import net.thecodersbreakfast.lp4j.api.LaunchpadClient;
import net.thecodersbreakfast.lp4j.api.LightIntensity;
import net.thecodersbreakfast.lp4j.api.Pad;
import net.thecodersbreakfast.lp4j.api.ScrollSpeed;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.json.JsonObject;

public class EmulatorLaunchpadClient
implements LaunchpadClient {
    private static final String EVENTBUS_CLIENT_HANDLER_ID = "lp4j:client";
    private final Vertx vertx;

    public EmulatorLaunchpadClient(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public void reset() {
        this.publishEvent(OutputEventType.RST);
    }

    @Override
    public void testLights(LightIntensity lightIntensity) {
        if (lightIntensity == null) {
            throw new IllegalArgumentException("Light intensity must not be null.");
        }
        int n = 0;
        if (lightIntensity == LightIntensity.LOW) {
            n = 5;
        }
        if (lightIntensity == LightIntensity.MEDIUM) {
            n = 10;
        }
        if (lightIntensity == LightIntensity.HIGH) {
            n = 15;
        }
        JsonObject jsonObject = new JsonObject().putNumber("i", (Number)n);
        this.publishEvent(OutputEventType.TST, jsonObject);
    }

    @Override
    public void setLights(Color[] colorArray, BackBufferOperation backBufferOperation) {
        if (colorArray == null) {
            throw new IllegalArgumentException("Colors must not be null");
        }
        if (backBufferOperation == null) {
            throw new IllegalArgumentException("BackBuffer operation must not be null.");
        }
    }

    @Override
    public void setPadLight(Pad pad, Color color, BackBufferOperation backBufferOperation) {
        if (pad == null) {
            throw new IllegalArgumentException("Pad must not be null");
        }
        if (color == null) {
            throw new IllegalArgumentException("Color must not be null.");
        }
        if (backBufferOperation == null) {
            throw new IllegalArgumentException("BackBuffer operation must not be null.");
        }
        JsonObject jsonObject = new JsonObject().putNumber("x", (Number)pad.getX()).putNumber("y", (Number)pad.getY()).putObject("c", new JsonObject().putNumber("r", (Number)color.getRed()).putNumber("g", (Number)color.getGreen())).putString("o", backBufferOperation.name());
        this.publishEvent(OutputEventType.PADLGT, jsonObject);
    }

    @Override
    public void setButtonLight(Button button, Color color, BackBufferOperation backBufferOperation) {
        if (button == null) {
            throw new IllegalArgumentException("Button must not be null.");
        }
        if (color == null) {
            throw new IllegalArgumentException("Color must not be null.");
        }
        if (backBufferOperation == null) {
            throw new IllegalArgumentException("BackBuffer operation must not be null.");
        }
        JsonObject jsonObject = new JsonObject().putBoolean("t", Boolean.valueOf(button.isTopButton())).putNumber("i", (Number)button.getCoordinate()).putObject("c", new JsonObject().putNumber("r", (Number)color.getRed()).putNumber("g", (Number)color.getGreen())).putString("o", backBufferOperation.name());
        this.publishEvent(OutputEventType.BTNLGT, jsonObject);
    }

    @Override
    public void setBrightness(Brightness brightness) {
        if (brightness == null) {
            throw new IllegalArgumentException("Brightness must not be null");
        }
        JsonObject jsonObject = new JsonObject().putNumber("b", (Number)brightness.getBrightness());
        this.publishEvent(OutputEventType.BRGHT, jsonObject);
    }

    @Override
    public void setBuffers(Buffer buffer, Buffer buffer2, boolean bl, boolean bl2) {
        if (buffer == null) {
            throw new IllegalArgumentException("Visible buffer must not be null.");
        }
        if (buffer2 == null) {
            throw new IllegalArgumentException("Write buffer must not be null.");
        }
        JsonObject jsonObject = new JsonObject().putString("v", buffer.name()).putString("w", buffer2.name()).putBoolean("c", Boolean.valueOf(bl)).putBoolean("a", Boolean.valueOf(bl2));
        this.publishEvent(OutputEventType.BUF, jsonObject);
    }

    @Override
    public void scrollText(String string, Color color, ScrollSpeed scrollSpeed, boolean bl, BackBufferOperation backBufferOperation) {
        if (color == null) {
            throw new IllegalArgumentException("Color must not be null.");
        }
    }

    private void publishEvent(OutputEventType outputEventType) {
        this.publishEvent(outputEventType, null);
    }

    private void publishEvent(OutputEventType outputEventType, JsonObject jsonObject) {
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.putString("evt", outputEventType.name());
        if (jsonObject != null) {
            jsonObject2.mergeIn(jsonObject);
        }
        this.vertx.eventBus().publish(EVENTBUS_CLIENT_HANDLER_ID, jsonObject2);
    }

    private static enum OutputEventType {
        RST,
        PADLGT,
        BTNLGT,
        TST,
        BRGHT,
        BUF;

    }
}

