/*
 * Decompiled with CFR 0.152.
 */
package net.thecodersbreakfast.lp4j.midi;

import java.io.IOException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;
import net.thecodersbreakfast.lp4j.api.Launchpad;
import net.thecodersbreakfast.lp4j.api.LaunchpadClient;
import net.thecodersbreakfast.lp4j.api.LaunchpadException;
import net.thecodersbreakfast.lp4j.api.LaunchpadListener;
import net.thecodersbreakfast.lp4j.midi.MidiDeviceConfiguration;
import net.thecodersbreakfast.lp4j.midi.MidiLaunchpadClient;
import net.thecodersbreakfast.lp4j.midi.protocol.DefaultMidiProtocolClient;
import net.thecodersbreakfast.lp4j.midi.protocol.DefaultMidiProtocolListener;
import net.thecodersbreakfast.lp4j.midi.protocol.DefaultMidiProtocolReceiver;

public class MidiLaunchpad
implements Launchpad {
    private final Receiver receiver;
    private final Transmitter transmitter;
    private MidiDeviceConfiguration configuration;
    private boolean openedOutputDevice = false;
    private boolean openedInputDevice = false;

    public MidiLaunchpad(MidiDeviceConfiguration midiDeviceConfiguration) throws MidiUnavailableException {
        if (midiDeviceConfiguration == null) {
            throw new IllegalArgumentException("Configuration must not be null");
        }
        this.configuration = midiDeviceConfiguration;
        MidiDevice midiDevice = midiDeviceConfiguration.getOutputDevice();
        if (midiDevice != null) {
            if (!midiDevice.isOpen()) {
                midiDevice.open();
            }
            this.openedOutputDevice = true;
            this.receiver = midiDevice.getReceiver();
        } else {
            this.receiver = null;
        }
        MidiDevice midiDevice2 = midiDeviceConfiguration.getInputDevice();
        if (midiDevice2 != null) {
            if (!midiDevice2.isOpen()) {
                midiDevice2.open();
            }
            this.openedInputDevice = true;
            this.transmitter = midiDevice2.getTransmitter();
        } else {
            this.transmitter = null;
        }
    }

    @Override
    public LaunchpadClient getClient() {
        if (this.receiver == null) {
            throw new LaunchpadException("Unable to provide a client, because no Receiver or Output Device have been configured.");
        }
        return new MidiLaunchpadClient(new DefaultMidiProtocolClient(this.receiver));
    }

    @Override
    public void setListener(LaunchpadListener launchpadListener) {
        if (this.transmitter == null) {
            throw new LaunchpadException("Unable to set the listener, because no Transmitter or Input Device have been configured.");
        }
        DefaultMidiProtocolListener defaultMidiProtocolListener = new DefaultMidiProtocolListener(launchpadListener);
        DefaultMidiProtocolReceiver defaultMidiProtocolReceiver = new DefaultMidiProtocolReceiver(defaultMidiProtocolListener);
        this.transmitter.setReceiver(defaultMidiProtocolReceiver);
    }

    @Override
    public void close() throws IOException {
        MidiDevice midiDevice;
        if (this.configuration == null) {
            return;
        }
        if (this.openedOutputDevice && (midiDevice = this.configuration.getOutputDevice()) != null && midiDevice.isOpen()) {
            midiDevice.close();
        }
        if (this.openedInputDevice && (midiDevice = this.configuration.getInputDevice()) != null && midiDevice.isOpen()) {
            midiDevice.close();
        }
    }
}

